/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntityVisitor;
import org.squashtest.tm.domain.actionword.GetActionWordTreeDefinitionVisitor;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.actionword.ActionWordPreview;
import org.squashtest.tm.service.internal.repository.CustomActionWordLibraryNodeDao;

public class ActionWordLibraryNodeDaoImpl
implements CustomActionWordLibraryNodeDao {
    @PersistenceContext
    EntityManager em;
    @Inject
    private DSLContext dsl;

    @Override
    public ActionWordLibraryNode findNodeFromEntity(ActionWordTreeEntity actionWordTreeEntity) {
        GetActionWordTreeDefinitionVisitor visitor = new GetActionWordTreeDefinitionVisitor();
        actionWordTreeEntity.accept((ActionWordTreeEntityVisitor)visitor);
        Query query = this.em.createNamedQuery("ActionWordLibraryNode.findNodeFromEntity");
        query.setParameter("entityType", (Object)visitor.getActionWordTreeDefinition());
        query.setParameter("entityId", (Object)actionWordTreeEntity.getId());
        return (ActionWordLibraryNode)query.getSingleResult();
    }

    @Override
    public List<Long> findAllFirstLevelDescendantIds(Long nodeId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(nodeId);
        return this.findAllFirstLevelDescendantIds(ids);
    }

    @Override
    public List<Long> findAllFirstLevelDescendantIds(List<Long> nodesIds) {
        Query query = this.em.createNamedQuery("ActionWordLibraryNodePathEdge.findAllFirstLevelDescendantIds");
        query.setParameter("ids", nodesIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findAllCanBeCopiedNodesInTarget(List<ActionWordLibraryNode> copiedNodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        Object actionWordTokenField = caseInsensitivity ? DSL.lower((Field)Tables.ACTION_WORD.TOKEN) : Tables.ACTION_WORD.TOKEN;
        Long targetId = target.getId();
        List<Long> nodeIds = copiedNodes.stream().map(ActionWordLibraryNode::getId).toList();
        if (!nodeIds.isEmpty() && targetId != null) {
            return this.dsl.selectDistinct((SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID).from((TableLike)Tables.ACTION_WORD).join((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).on(Tables.ACTION_WORD.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)"ACTION_WORD"))).where(Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID.in(nodeIds).and(actionWordTokenField.notIn((Select)this.dsl.selectDistinct((SelectField)actionWordTokenField).from((TableLike)Tables.AWLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).on(Tables.AWLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID)).join((TableLike)Tables.ACTION_WORD).on(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)"ACTION_WORD"))).where(Tables.AWLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)targetId).and(Tables.AWLN_RELATIONSHIP_CLOSURE.DEPTH.eq((Object)1)))))).fetch().into(Long.class);
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> getActionWordLibraryNodeIdsWithoutSteps(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID).from((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).leftJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).where(Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID.isNull()).and(Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID.in(ids)).fetchInto(Long.class);
    }

    @Override
    public List<ActionWordPreview> fetchActionWordPreviewDtos(List<Long> nodeIds) {
        return this.dsl.select((SelectField)Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID.as("ACTION_WORD_ID"), (SelectField)Tables.ACTION_WORD_LIBRARY_NODE.NAME.as("ACTION_WORD_NAME"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)DSL.count((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID).as("KEYWORD_TEST_STEP_COUNT")).from((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).join((TableLike)Tables.PROJECT).on(Tables.ACTION_WORD_LIBRARY_NODE.AWL_ID.eq((Field)Tables.PROJECT.AWL_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).where(Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID.in(nodeIds)).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)ActionWordTreeDefinition.ACTION_WORD.name())).groupBy(new GroupField[]{Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, Tables.PROJECT.PROJECT_ID}).orderBy((OrderField)Tables.PROJECT.NAME, (OrderField)Tables.ACTION_WORD_LIBRARY_NODE.NAME).fetchInto(ActionWordPreview.class);
    }
}

