/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.service.internal.display.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

public abstract class AbstractTreeNodeCollector
implements TreeNodeCollector {
    protected static final String PROJECT_ID_ALIAS = "projectId";
    protected static final String CHILD_COUNT_ALIAS = "CHILD_COUNT";
    protected static final String CUF_COLUMN_PREFIX = "CUF_COLUMN_";
    protected static final String NAME_ALIAS = "NAME";
    protected static final String MILESTONES_ALIAS = "MILESTONES";
    protected static final String DIRECT_BIND_MILESTONES_ALIAS = "DIRECT_MILESTONE_BIND";
    protected static final String INDIRECT_BIND_MILESTONES_ALIAS = "INDIRECT_MILESTONE_BIND";
    protected static final String ALL_MILESTONES_ALIAS = "ALL_MILESTONES";
    protected static final String CAMPAIGN_ID_ALIAS = "CAMPAIGN_ID";
    protected DSLContext dsl;
    protected CustomFieldValueDisplayDao customFieldValueDisplayDao;
    protected final ActiveMilestoneHolder activeMilestoneHolder;
    protected final MilestoneDisplayDao milestoneDisplayDao;

    protected AbstractTreeNodeCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        this.dsl = dsl;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.milestoneDisplayDao = milestoneDisplayDao;
    }

    @Override
    public Map<Long, DataRow> collect(List<Long> ids) {
        if (Objects.isNull(ids) || ids.isEmpty()) {
            return new HashMap<Long, DataRow>();
        }
        Map<Long, DataRow> dataRows = this.doCollect(ids);
        this.appendCustomFieldValues(ids, dataRows);
        this.appendIsBoundToBlockingMilestone(ids, dataRows);
        return dataRows;
    }

    private void appendIsBoundToBlockingMilestone(List<Long> ids, Map<Long, DataRow> dataRows) {
        Map<Long, List<MilestoneDto>> milestonesByBoundEntity = this.milestoneDisplayDao.getMilestonesByBoundEntity(ids, this.getHandledEntityType());
        dataRows.forEach((id, dataRow) -> {
            List<String> milestoneBlockingStatusNames = MilestoneStatus.MILESTONE_BLOCKING_STATUSES.stream().map(Enum::name).toList();
            List milestones = milestonesByBoundEntity.getOrDefault(id, Collections.emptyList());
            boolean isBoundToBlockingMilestone = milestones.stream().anyMatch(milestone -> milestoneBlockingStatusNames.contains(milestone.getStatus()));
            dataRow.addData("BOUND_TO_BLOCKING_MILESTONE", isBoundToBlockingMilestone);
        });
    }

    protected abstract Map<Long, DataRow> doCollect(List<Long> var1);

    protected void appendCustomFieldValues(List<Long> ids, Map<Long, DataRow> dataRows) {
        if (this.getHandledEntityType().isCufHolder()) {
            ListMultimap<Long, CustomFieldValueDto> customFieldValuesById = this.customFieldValueDisplayDao.findCustomFieldValues(this.getHandledEntityType().getBindableEntity(), ids);
            dataRows.forEach((id, dataRow) -> {
                List customFieldValues = customFieldValuesById.get(id);
                for (CustomFieldValueDto customFieldValue : customFieldValues) {
                    dataRow.getData().put(CUF_COLUMN_PREFIX + customFieldValue.getCufId(), customFieldValue.getValue());
                }
            });
        }
    }

    protected void appendMilestonesByProject(Map<Long, DataRow> libraryRows) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            Set<Long> projectIds = libraryRows.values().stream().map(DataRow::getProjectId).collect(Collectors.toSet());
            Multimap<Long, Long> milestonesByProjectId = this.milestoneDisplayDao.findMilestonesByProjectId(projectIds);
            libraryRows.forEach((aLong, dataRow) -> dataRow.addData(MILESTONES_ALIAS, milestonesByProjectId.get((Object)dataRow.getProjectId())));
        }
    }

    protected boolean mustAppendMilestone() {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        return activeMilestone.isPresent();
    }

    protected void appendMilestonesInheritedFromCampaign(Map<Long, DataRow> campaignDescendants) {
        if (this.mustAppendMilestone()) {
            this.doAppendMilestonesFromCampaigns(campaignDescendants);
        }
    }

    protected void doAppendMilestonesFromCampaigns(Map<Long, DataRow> campaignDescendants) {
        Map<Long, Long> campaignsIdByDescendantId = this.createCampaignByDescendantMap(campaignDescendants);
        Multimap<Long, MilestoneDto> milestonesByCampaignId = this.milestoneDisplayDao.findMilestonesByCampaignId(new HashSet<Long>(campaignsIdByDescendantId.values()));
        campaignDescendants.forEach((aLong, dataRow) -> {
            Long campaignId = (Long)campaignsIdByDescendantId.get(aLong);
            Collection milestones = milestonesByCampaignId.get((Object)campaignId);
            List<Long> milestoneIds = milestones.stream().map(MilestoneDto::getId).toList();
            List<String> milestoneStatuses = milestones.stream().map(MilestoneDto::getStatus).toList();
            dataRow.addData(MILESTONES_ALIAS, milestoneIds);
            dataRow.addData("MILESTONE_STATUS", milestoneStatuses);
        });
    }

    protected Map<Long, Long> createCampaignByDescendantMap(Map<Long, DataRow> campaignDescendants) {
        return campaignDescendants.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Long)((DataRow)entry.getValue()).getData().get(CAMPAIGN_ID_ALIAS)));
    }
}

