/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record9;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;

@Repository
@Transactional(readOnly=true)
public class SessionNoteDisplayDaoImpl
implements SessionNoteDisplayDao {
    private final DSLContext dsl;
    private final AttachmentDisplayDao attachmentDisplayDao;

    public SessionNoteDisplayDaoImpl(DSLContext dsl, AttachmentDisplayDao attachmentDisplayDao) {
        this.dsl = dsl;
        this.attachmentDisplayDao = attachmentDisplayDao;
    }

    @Override
    public List<SessionNoteDto> fetchSessionNotesByExecutionId(long executionId) {
        List sessionNoteViews = this.selectSessionNoteView().from((TableLike)Tables.SESSION_NOTE).where(Tables.SESSION_NOTE.EXECUTION_ID.eq((Object)executionId)).orderBy((OrderField)Tables.SESSION_NOTE.NOTE_ORDER).fetchInto(SessionNoteDto.class);
        for (SessionNoteDto sessionNoteView : sessionNoteViews) {
            Long attachmentListId = sessionNoteView.getAttachmentListId();
            sessionNoteView.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(attachmentListId));
        }
        return sessionNoteViews;
    }

    @Override
    public SessionNoteDto findById(long noteId) {
        SessionNoteDto sessionNoteView = (SessionNoteDto)this.selectSessionNoteView().from((TableLike)Tables.SESSION_NOTE).where(Tables.SESSION_NOTE.NOTE_ID.eq((Object)noteId)).fetchOneInto(SessionNoteDto.class);
        if (sessionNoteView != null) {
            Long attachmentListId = sessionNoteView.getAttachmentListId();
            sessionNoteView.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(attachmentListId));
            return sessionNoteView;
        }
        throw new UnknownEntityException(noteId, SessionNote.class);
    }

    private SelectSelectStep<Record9<Long, String, String, Integer, Timestamp, String, Timestamp, String, Long>> selectSessionNoteView() {
        return this.dsl.select((SelectField)Tables.SESSION_NOTE.NOTE_ID, (SelectField)Tables.SESSION_NOTE.KIND, (SelectField)Tables.SESSION_NOTE.CONTENT, (SelectField)Tables.SESSION_NOTE.NOTE_ORDER, (SelectField)Tables.SESSION_NOTE.CREATED_ON, (SelectField)Tables.SESSION_NOTE.CREATED_BY, (SelectField)Tables.SESSION_NOTE.LAST_MODIFIED_ON, (SelectField)Tables.SESSION_NOTE.LAST_MODIFIED_BY, (SelectField)Tables.SESSION_NOTE.ATTACHMENT_LIST_ID);
    }

    @Override
    public Long findProjectIdBySessionNoteId(long noteId) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).where(Tables.SESSION_NOTE.NOTE_ID.eq((Object)noteId)).fetchOneInto(Long.class);
    }

    @Override
    public List<SessionNoteDto> fetchSessionNotesByOverviewId(long overviewId) {
        List sessionNoteViews = this.selectSessionNoteView().from((TableLike)Tables.SESSION_NOTE).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.SESSION_NOTE.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.SESSION_NOTE.EXECUTION_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID).or(Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID))).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)overviewId)).orderBy((OrderField)DSL.coalesce((Field)Tables.SESSION_NOTE.LAST_MODIFIED_ON, (Field[])new Field[]{Tables.SESSION_NOTE.CREATED_ON}).desc()).fetchInto(SessionNoteDto.class);
        for (SessionNoteDto sessionNoteView : sessionNoteViews) {
            Long attachmentListId = sessionNoteView.getAttachmentListId();
            sessionNoteView.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(attachmentListId));
        }
        return sessionNoteViews;
    }
}

