/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record5;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectUnionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Repository
public class CustomFieldValueDisplayDaoImpl
implements CustomFieldValueDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<CustomFieldValueDto> findCustomFieldValues(BindableEntity bindableEntity, Long entityId) {
        ListMultimap<Long, CustomFieldValueDto> customFieldValues = this.findCustomFieldValues(bindableEntity, Collections.singletonList(entityId));
        return customFieldValues.get((Object)entityId);
    }

    @Override
    public ListMultimap<Long, CustomFieldValueDto> findCustomFieldValues(BindableEntity bindableEntity, List<Long> entityIds) {
        if (Objects.nonNull(bindableEntity) && Objects.nonNull(entityIds) && !entityIds.isEmpty()) {
            return this.fetchCustomFieldValues(bindableEntity, entityIds);
        }
        return ArrayListMultimap.create();
    }

    private ListMultimap<Long, CustomFieldValueDto> fetchCustomFieldValues(BindableEntity bindableEntity, List<Long> entityIds) {
        ArrayListMultimap values = ArrayListMultimap.create();
        SelectUnionStep<Record5<Long, Long, String, Long, String>> selectRequest = this.craftSelectRequest(bindableEntity, entityIds);
        selectRequest.fetch().into(CustomFieldValueDto.class).forEach(arg_0 -> CustomFieldValueDisplayDaoImpl.lambda$0((ListMultimap)values, arg_0));
        return values;
    }

    private SelectUnionStep<Record5<Long, Long, String, Long, String>> craftSelectRequest(BindableEntity bindableEntity, List<Long> entityIds) {
        EnumSet<CustomFieldValueType> customFieldValueTypes = EnumSet.allOf(CustomFieldValueType.class);
        Deque clauses = customFieldValueTypes.stream().map(type -> this.getSelectClause(bindableEntity, (CustomFieldValueType)type, entityIds)).collect(Collectors.toCollection(ArrayDeque::new));
        SelectUnionStep selectRequest = (SelectUnionStep)clauses.pop();
        while (clauses.peek() != null) {
            selectRequest.unionAll((Select)clauses.pop());
        }
        return selectRequest;
    }

    private SelectUnionStep<Record5<Long, Long, String, Long, String>> getSelectClause(BindableEntity bindableEntity, CustomFieldValueType type, List<Long> entityIds) {
        if (type.isMultiValue()) {
            return this.getMultiValueClause(bindableEntity, type, entityIds);
        }
        return this.getSingleValueClause(bindableEntity, type, entityIds);
    }

    private SelectUnionStep<Record5<Long, Long, String, Long, String>> getMultiValueClause(BindableEntity bindableEntity, CustomFieldValueType type, List<Long> entityIds) {
        Table customFieldValueOption = this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL, (SelectField)Tables.CUSTOM_FIELD_VALUE_OPTION.POSITION).from((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).orderBy((OrderField)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID, (OrderField)Tables.CUSTOM_FIELD_VALUE_OPTION.POSITION).asTable("CUSTOM_FIELD_VALUE_OPTION");
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID.as("CUF_ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)DSL.listAgg((Field)type.getValueColumn(), (String)"|").withinGroupOrderBy(new OrderField[]{Tables.CUSTOM_FIELD_VALUE_OPTION.POSITION}).as("VALUE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID.as("ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).leftJoin((TableLike)customFieldValueOption).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)bindableEntity.name())).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)type.getDiscriminatorValue())).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID});
    }

    private SelectUnionStep<Record5<Long, Long, String, Long, String>> getSingleValueClause(BindableEntity bindableEntity, CustomFieldValueType type, List<Long> entityIds) {
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID.as("CUF_ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)type.getValueColumn().as("VALUE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID.as("ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)bindableEntity.name())).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)type.getDiscriminatorValue()));
    }

    private static /* synthetic */ void lambda$0(ListMultimap listMultimap, CustomFieldValueDto customFieldValueDto) {
        if (customFieldValueDto.getFieldType().equals(CustomFieldValueType.RTF.name())) {
            String sanitized = HTMLCleanupUtils.cleanHtml(customFieldValueDto.getValue());
            customFieldValueDto.setValue(sanitized);
        }
        listMultimap.put((Object)customFieldValueDto.getBoundEntityId(), (Object)customFieldValueDto);
    }
}

