/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import javax.persistence.QueryHint;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.SprintReqVersion;

public interface SprintReqVersionDao
extends JpaRepository<SprintReqVersion, Long> {
    public List<SprintReqVersion> findAllBySprintIdAndRequirementVersionIdInOrderByRequirementVersionId(Long var1, List<Long> var2);

    @Query(value="    select sr from SprintReqVersion sr\n    left join fetch sr.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    left join fetch sr.sprint sp\n    where sr.id = :sprintReqVersionId\n")
    public SprintReqVersion findByIdWithTestPlanAndSprint(@Param(value="sprintReqVersionId") Long var1);

    @Query(value="update SprintReqVersion sr set sr.requirementVersion = null where sr.requirementVersion.id in (select rv.id from RequirementVersion rv where rv.requirement.id in (:requirementIds))")
    @Modifying
    public void removeReqVersionsFromSprintReqVersion(@Param(value="requirementIds") List<Long> var1);

    @Query(value="delete SprintReqVersion sr where sr.id in (:sprintReqVersionIds)")
    @Modifying
    public void deleteAllSprintReqVersionsByIds(@Param(value="sprintReqVersionIds") List<Long> var1);

    @Query(value="    update SprintReqVersion sr\n    set\n        sr.mode = :#{T(org.squashtest.tm.domain.requirement.ManagementMode).NATIVE},\n        sr.reference = case when sr.requirementVersion is not null then null else sr.reference end,\n        sr.name = case when sr.requirementVersion is not null then null else sr.name end,\n        sr.status = case when sr.requirementVersion is not null then null else sr.status end,\n        sr.criticality = case when sr.requirementVersion is not null then null else sr.criticality end,\n        sr.category = case when sr.requirementVersion is not null then null else sr.category end\n    where sr.sprint.id\n        in (select sp.id from Sprint sp where sp.remoteSynchronisation.id in (:remoteSyncIds))\n")
    @Modifying
    @UsedInPlugin(value="xsquash-4-jira")
    public void setAllSprintReqVersionToNativeByRemoteSyncIds(@Param(value="remoteSyncIds") List<Long> var1);

    @Query(value="    update SprintReqVersion sr\n    set\n        sr.mode = :#{T(org.squashtest.tm.domain.requirement.ManagementMode).NATIVE},\n        sr.reference = case when sr.requirementVersion is not null then null else sr.reference end,\n        sr.name = case when sr.requirementVersion is not null then null else sr.name end,\n        sr.status = case when sr.requirementVersion is not null then null else sr.status end,\n        sr.criticality = case when sr.requirementVersion is not null then null else sr.criticality end,\n        sr.category = case when sr.requirementVersion is not null then null else sr.category end\n    where sr.sprint.id = (:sprintId)\n")
    @Modifying
    public void setAllSprintReqVersionsToNativeBySprintId(@Param(value="sprintId") Long var1);

    @Query(value="update SprintReqVersion sr set sr.reference = :reference, sr.name = :name, sr.status = :status, sr.criticality = :criticality, sr.category = :category, sr.description = :description where sr.id = :id")
    @Modifying
    public void updateForDenormalization(@Param(value="id") Long var1, @Param(value="reference") String var2, @Param(value="name") String var3, @Param(value="status") String var4, @Param(value="criticality") String var5, @Param(value="category") String var6, @Param(value="description") String var7);

    @Query(value="    select sr from SprintReqVersion sr\n    left join fetch sr.sprint sp\n    left join fetch sr.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    where tpi.id = :testPlanItemId\n")
    public SprintReqVersion findWithSprintByTestPlanItemId(@Param(value="testPlanItemId") Long var1);

    @Query(value="    select sr from SprintReqVersion sr\n    left join fetch sr.sprint sp\n    left join fetch sr.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    where tpi.id in :testPlanItemIds\n")
    public List<SprintReqVersion> findWithSprintByTestPlanItemIds(@Param(value="testPlanItemIds") List<Long> var1);

    @QueryHints(value={@QueryHint(name="hibernate.query.passDistinctThrough", value="false")})
    @Query(value="    select distinct sr.id from SprintReqVersion sr\n    inner join sr.testPlan tp\n    inner join tp.testPlanItems tpi\n    inner join tpi.executions e\n    where sr.id in (:sprintReqVersionIds)\n")
    public List<Long> findSprintReqVersionWithExecutions(@Param(value="sprintReqVersionIds") Collection<Long> var1);
}

