/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.remotesynchronisation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.exception.sync.PathAlreadyInUseException;
import org.squashtest.tm.exception.sync.PathContainsASprintGroupException;
import org.squashtest.tm.service.internal.repository.CustomRemoteSynchronisationDao;
import org.squashtest.tm.service.internal.utils.JSONUtils;
import org.squashtest.tm.service.remotesynchronisation.RemoteSynchronisationService;

@Service(value="RemoteSynchronisationService")
public class RemoteSynchronisationServiceImpl
implements RemoteSynchronisationService {
    public static final String SYNCHRONISATION_PATH = "synchronisationPath";
    public static final String SPRINT_SYNCHRONISATION_PATH = "sprintSynchronisationPath";
    @Inject
    private CustomRemoteSynchronisationDao customRemoteSynchronisationDao;

    @Override
    public void checkPathAvailability(String projectName, String synchronisationPath) {
        Set<String> existingPaths = this.getExistingPaths(projectName, SYNCHRONISATION_PATH);
        synchronisationPath = PathUtils.removeAllUnnecessarySpaces((String)synchronisationPath);
        for (String existingPath : existingPaths) {
            if (!synchronisationPath.equals(existingPath)) continue;
            throw new PathAlreadyInUseException(SYNCHRONISATION_PATH);
        }
    }

    @Override
    public void checkSprintPathAvailability(String projectName, String sprintSynchronisationPath) {
        Set<String> existingPaths = this.getExistingPaths(projectName, SPRINT_SYNCHRONISATION_PATH);
        sprintSynchronisationPath = PathUtils.removeAllUnnecessarySpaces((String)sprintSynchronisationPath);
        for (String existingPath : existingPaths) {
            if (sprintSynchronisationPath.equals(existingPath)) {
                throw new PathAlreadyInUseException(SPRINT_SYNCHRONISATION_PATH);
            }
            if (!(String.valueOf(sprintSynchronisationPath) + "/").startsWith(String.valueOf(existingPath) + "/")) continue;
            throw new PathContainsASprintGroupException(SPRINT_SYNCHRONISATION_PATH);
        }
    }

    private Set<String> getExistingPaths(String projectName, String key) {
        List<String> allOptions = this.customRemoteSynchronisationDao.findAllRemoteSynchronisationOptionsFromProjectName(projectName);
        return allOptions.stream().map(json -> this.getCleanPath((String)json, key)).collect(Collectors.toSet());
    }

    private String getCleanPath(String json, String key) {
        String valueFromKey = JSONUtils.getValueFromKey(json, key);
        return PathUtils.removeAllUnnecessarySpaces((String)valueFromKey);
    }
}

