/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.license;

import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.license.UltimateLicenseAvailability;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;

@Service
@Transactional
public class UltimateLicenseAvailabilityServiceImpl
implements UltimateLicenseAvailabilityService {
    private final UltimateLicenseAvailability ultimateLicenseAvailability;

    @Autowired
    public UltimateLicenseAvailabilityServiceImpl(Optional<UltimateLicenseAvailability> ultimateLicenseAvailability) {
        this.ultimateLicenseAvailability = ultimateLicenseAvailability.orElse(null);
    }

    @Override
    public boolean isAvailable() {
        return Objects.nonNull(this.ultimateLicenseAvailability) && this.ultimateLicenseAvailability.isAvailable();
    }

    @Override
    public void checkIfAvailable() {
        if (!Objects.nonNull(this.ultimateLicenseAvailability)) {
            throw new AccessDeniedException("No ultimate license available");
        }
        this.ultimateLicenseAvailability.checkIfAvailable();
    }
}

