/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.SheetCorruptedException;
import org.squashtest.tm.service.internal.importer.ExcelTestCaseParser;
import org.squashtest.tm.service.internal.importer.ImportSummaryImpl;
import org.squashtest.tm.service.internal.importer.PseudoTestCase;

public class ExcelTestCaseParserImpl
implements ExcelTestCaseParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelTestCaseParserImpl.class);
    private final List<FieldPopulator> fieldPopulators = new ArrayList<FieldPopulator>(6);
    private final FieldPopulator defaultPopulator = new FieldPopulator(""){

        @Override
        public void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
            String tag = this.tagCell(row).getStringCellValue();
            String value = this.valueCell(row).getStringCellValue();
            String[] desc = ExcelTestCaseParserImpl.pairedString(tag, value);
            pseudoTestCase.getDescriptionElements().add(desc);
        }
    };

    public ExcelTestCaseParserImpl() {
        this.fieldPopulators.add(new FieldPopulator("Description"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String tag = this.tagCell(row).getStringCellValue();
                String value = this.valueCell(row).getStringCellValue();
                String[] desc = ExcelTestCaseParserImpl.pairedString(tag, value);
                pseudoTestCase.getDescriptionElements().add(0, desc);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Importance"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setImportance(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Nature"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setNature(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Type"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setType(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Status"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setStatus(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Automatable"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setAutomatable(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Created_by"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setCreatedBy(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Created_on"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                Cell cell = this.valueCell(row);
                if (CellType.NUMERIC == cell.getCellType() || CellType.FORMULA == cell.getCellType()) {
                    Date value = this.valueCell(row).getDateCellValue();
                    pseudoTestCase.setCreatedOnDate(value);
                } else {
                    String value = this.valueCell(row).getStringCellValue();
                    pseudoTestCase.setCreatedOn(value);
                }
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Prerequisite"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String value = this.valueCell(row).getStringCellValue();
                pseudoTestCase.getPrerequisites().add(value);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("Action_step"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String action = this.valueCell(row).getStringCellValue();
                String expectation = "";
                Cell cell2 = row.getCell(2);
                if (cell2 != null) {
                    expectation = cell2.getStringCellValue();
                }
                String[] stepInfo = ExcelTestCaseParserImpl.pairedString(action, expectation);
                pseudoTestCase.getStepElements().add(stepInfo);
            }
        });
        this.fieldPopulators.add(new FieldPopulator("UUID"){

            @Override
            protected void doPopulate(PseudoTestCase pseudoTestCase, Row row) {
                String uuid = this.valueCell(row).getStringCellValue();
                pseudoTestCase.setUuid(uuid);
            }
        });
    }

    @Override
    public TestCase parseFile(InputStream stream, ImportSummaryImpl summary) throws SheetCorruptedException {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)stream);
            return this.parseFile(workbook, summary);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.warn(e.getMessage(), new Object[0]);
            throw new SheetCorruptedException(e);
        }
    }

    @Override
    public TestCase parseFile(Workbook workbook, ImportSummaryImpl summary) throws SheetCorruptedException {
        PseudoTestCase pseudoTestCase = new PseudoTestCase();
        Sheet sheet = workbook.getSheetAt(0);
        int r = 0;
        while (r <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(r);
            this.parseRow(row, pseudoTestCase);
            ++r;
        }
        return this.generateTestCase(pseudoTestCase, summary);
    }

    @Override
    public String stripFileExtension(String fullName) {
        return fullName.replaceAll("\\.xlsx$", "").replaceAll("\\.xls$", "");
    }

    private void parseRow(Row row, PseudoTestCase pseudoTestCase) {
        if (this.validateRow(row)) {
            this.parseValidRow(row, pseudoTestCase);
        }
    }

    private void parseValidRow(Row row, PseudoTestCase pseudoTestCase) {
        for (FieldPopulator populator : this.fieldPopulators) {
            if (!populator.populate(pseudoTestCase, row)) continue;
            return;
        }
        this.defaultPopulator.doPopulate(pseudoTestCase, row);
    }

    private static String[] pairedString(String index0, String index1) {
        String[] pair = new String[]{index0, index1};
        return pair;
    }

    private TestCase generateTestCase(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary) {
        TestCase testCase = new TestCase();
        testCase = this.setTestCaseCreatedOnByInfos(pseudoTestCase, summary, testCase);
        this.setTestCaseDescription(pseudoTestCase, testCase);
        this.setTestCasePrerequisite(pseudoTestCase, testCase);
        this.setTestCaseImportance(pseudoTestCase, summary, testCase);
        this.setTestCaseNature(pseudoTestCase, summary, testCase);
        this.setTestCaseType(pseudoTestCase, summary, testCase);
        this.setTestCaseStatus(pseudoTestCase, summary, testCase);
        this.setTestCaseAutomatable(pseudoTestCase, summary, testCase);
        this.setTestCaseSteps(pseudoTestCase, testCase);
        this.setTestCaseUuid(pseudoTestCase, testCase);
        return testCase;
    }

    private TestCase setTestCaseCreatedOnByInfos(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        if (pseudoTestCase.getCreatedOnDate() != null && pseudoTestCase.getCreatedBy() != null) {
            testCase = new TestCase(pseudoTestCase.getCreatedOnDate(), pseudoTestCase.getCreatedBy());
        } else if (pseudoTestCase.getCreatedOn() != null && pseudoTestCase.getCreatedBy() != null) {
            try {
                Date createdDate = new SimpleDateFormat("dd/MM/yyyy").parse(pseudoTestCase.getCreatedOn());
                testCase = new TestCase(createdDate, pseudoTestCase.getCreatedBy());
            }
            catch (ParseException ex) {
                LOGGER.warn(ex.getMessage(), new Object[0]);
                summary.incrModified();
                testCase = new TestCase();
            }
        }
        return testCase;
    }

    private void setTestCaseSteps(PseudoTestCase pseudoTestCase, TestCase testCase) {
        List<TestStep> steps = pseudoTestCase.formatSteps();
        for (TestStep step : steps) {
            testCase.addStep(step);
        }
    }

    private void setTestCaseStatus(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        try {
            TestCaseStatus status = pseudoTestCase.formatStatus();
            testCase.setStatus(status);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
            summary.incrModified();
            testCase.setStatus(TestCaseStatus.defaultValue());
        }
    }

    private void setTestCaseAutomatable(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        try {
            TestCaseAutomatable automatable = pseudoTestCase.formatAutomatable();
            testCase.setAutomatable(automatable);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
            summary.incrModified();
            testCase.setAutomatable(TestCaseAutomatable.defaultValue());
        }
    }

    private void setTestCaseType(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        try {
            InfoListItem type = pseudoTestCase.formatType();
            if (type != null) {
                testCase.setType(type);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
            summary.incrModified();
        }
    }

    private void setTestCaseNature(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        try {
            InfoListItem nature = pseudoTestCase.formatNature();
            if (nature != null) {
                testCase.setNature(nature);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
            summary.incrModified();
        }
    }

    private void setTestCaseImportance(PseudoTestCase pseudoTestCase, ImportSummaryImpl summary, TestCase testCase) {
        try {
            TestCaseImportance importance = pseudoTestCase.formatImportance();
            testCase.setImportance(importance);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
            summary.incrModified();
            testCase.setImportance(TestCaseImportance.defaultValue());
        }
    }

    private void setTestCasePrerequisite(PseudoTestCase pseudoTestCase, TestCase testCase) {
        String prereqs = pseudoTestCase.formatPreRequisites();
        testCase.setPrerequisite(prereqs);
    }

    private void setTestCaseDescription(PseudoTestCase pseudoTestCase, TestCase testCase) {
        String desc = pseudoTestCase.formatDescription();
        testCase.setDescription(desc);
    }

    private void setTestCaseUuid(PseudoTestCase pseudoTestCase, TestCase testCase) {
        Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}");
        String uuid = pseudoTestCase.getUuid();
        if (StringUtils.isBlank((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
        } else if (!uuidPattern.matcher(uuid).matches()) {
            throw new IllegalArgumentException("The value: " + uuid + " for column TC_UUID does not match the regular" + " expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]" + "{4}-[0-9a-fA-F]{12}");
        }
        testCase.setUuid(uuid);
    }

    private boolean validateRow(Row row) {
        boolean validated = true;
        if (row == null) {
            validated = false;
        } else if (!this.validateRegularRow(row) && !this.validateStepRow(row)) {
            validated = false;
        }
        return validated;
    }

    private boolean validateRegularRow(Row row) {
        int nbCell;
        short lastCell = row.getLastCellNum();
        boolean validated = this.lessThan2Cells(lastCell, nbCell = row.getPhysicalNumberOfCells()) ? false : this.checkCellsContent(row);
        return validated;
    }

    private boolean checkCellsContent(Row row) {
        boolean valueIsTextOrDateDependingOnKey;
        String text1 = this.findFirstCellValue(row);
        Date date2 = null;
        String text2 = "";
        try {
            if (row.getCell(1) != null) {
                text2 = row.getCell(1).getStringCellValue();
            }
        }
        catch (IllegalStateException illegalStateException) {
            date2 = row.getCell(1).getDateCellValue();
        }
        boolean keyIsPresent = !text1.isEmpty();
        boolean keyIsCreatedOn = text1.equalsIgnoreCase("Created_on");
        boolean bl = valueIsTextOrDateDependingOnKey = keyIsCreatedOn && (!text2.isEmpty() || date2 != null) || !text2.isEmpty();
        return keyIsPresent && valueIsTextOrDateDependingOnKey;
    }

    private String findFirstCellValue(Row row) {
        String text1 = "";
        if (row.getCell(0) != null) {
            text1 = row.getCell(0).getStringCellValue();
        }
        return text1;
    }

    private boolean lessThan2Cells(int lastCell, int nbCell) {
        return lastCell < 2 || nbCell < 2;
    }

    private boolean validateStepRow(Row row) {
        short lastCell = row.getLastCellNum();
        int nbCell = row.getPhysicalNumberOfCells();
        String text1 = row.getCell(0) != null ? row.getCell(0).getStringCellValue() : "";
        String text2 = "";
        Cell cell2 = row.getCell(1);
        if (cell2 != null && CellType.STRING == cell2.getCellType()) {
            text2 = cell2.getStringCellValue();
        } else {
            LOGGER.debug("validateStepRow : Cell 1 of row {} was not of string type, empty string will be used", new Object[]{row});
        }
        boolean validated = text1.equals("Action_step") && !text2.isEmpty() && lastCell >= 3 && nbCell >= 3;
        return validated;
    }

    private static abstract class FieldPopulator {
        protected final String managedFieldTag;

        public FieldPopulator(String managedFieldTag) {
            this.managedFieldTag = managedFieldTag;
        }

        public final boolean populate(PseudoTestCase pseudoTestCase, Row row) {
            if (this.manages(row)) {
                this.doPopulate(pseudoTestCase, row);
                return true;
            }
            return false;
        }

        private boolean manages(Row row) {
            Cell fieldTagCell = this.tagCell(row);
            String candidateFieldTag = fieldTagCell.getStringCellValue();
            return this.managedFieldTag.equalsIgnoreCase(candidateFieldTag);
        }

        protected final Cell tagCell(Row row) {
            return row.getCell(0);
        }

        protected final Cell valueCell(Row row) {
            return row.getCell(1);
        }

        protected abstract void doPopulate(PseudoTestCase var1, Row var2);
    }
}

