/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution.automatedexecution;

import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFailureDetailService;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.internal.repository.IssueDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.display.FailureDetailDisplayDao;

@Service
@Transactional
public class AutomatedExecutionFailureDetailServiceImpl
implements AutomatedExecutionFailureDetailService {
    private final FailureDetailDao failureDetailDao;
    private final FailureDetailDisplayDao failureDetailDisplayDao;
    private final IssueDao issueDao;
    private final ProjectDao projectDao;

    public AutomatedExecutionFailureDetailServiceImpl(FailureDetailDao failureDetailDao, FailureDetailDisplayDao failureDetailDisplayDao, IssueDao issueDao, ProjectDao projectDao) {
        this.failureDetailDao = failureDetailDao;
        this.failureDetailDisplayDao = failureDetailDisplayDao;
        this.issueDao = issueDao;
        this.projectDao = projectDao;
    }

    @Override
    public void upsertFailureDetail(String failureDetailMessage, List<FailureDetail> existingFailureDetailList, AutomatedExecutionExtender extender, IterationTestPlanItem itpi) {
        FailureDetail matchingFailureDetail = existingFailureDetailList.stream().filter(fd -> fd.getMessage().equals(failureDetailMessage)).findFirst().orElse(null);
        if (matchingFailureDetail != null) {
            matchingFailureDetail.addExecutionExtender(extender);
            FailureDetail fd2 = (FailureDetail)this.failureDetailDao.save(matchingFailureDetail);
            this.addFailureDetailIssuesToNewExecution(fd2, extender.getExecution());
        } else {
            String userLogin = UserContextHolder.getUsername();
            FailureDetail failureDetail = new FailureDetail(failureDetailMessage, userLogin, new Date(), itpi);
            failureDetail.addExecutionExtender(extender);
            this.failureDetailDao.save(failureDetail);
        }
    }

    private void addFailureDetailIssuesToNewExecution(FailureDetail failureDetail, Execution execution) {
        if (failureDetail.getIssueList().getAllIssues() == null | failureDetail.getIssueList().getAllIssues().isEmpty()) {
            return;
        }
        List<Issue> newExecIssues = failureDetail.getIssueList().getAllIssues().stream().map(fdIssue -> fdIssue.duplicateFailureDetailExecutionForExecution(execution)).toList();
        this.issueDao.saveAll(newExecIssues);
    }

    @Override
    public Project findProjectByFailureDetailId(Long failureDetailId) {
        Long projectId = this.failureDetailDisplayDao.findProjectIdByFailureDetailId(failureDetailId);
        if (projectId == null) {
            throw new UnknownEntityException(failureDetailId.longValue(), FailureDetail.class);
        }
        return (Project)this.projectDao.findById(projectId).orElseThrow();
    }

    @Override
    public FailureDetail findFailureDetailById(Long failureDetailId) {
        return this.failureDetailDao.findById(failureDetailId).orElse(null);
    }
}

