/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.testcaseworkspace;

import gherkin.AstBuilder;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.Parser;
import gherkin.Token;
import gherkin.TokenMatcher;
import gherkin.TokenScanner;
import gherkin.ast.Background;
import gherkin.ast.Comment;
import gherkin.ast.DataTable;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.prittergherkin.GherkinDocumentPrinter;

public class GherkinScriptedStep {
    private static final Pattern BR_HTML_TAGS = Pattern.compile("(<\\s*br\\s*/\\s*>)|(<\\s*br\\s*>\\s*</\\s*br\\s*\\s*>)");
    private static final Pattern PARAMETER_GHERKIN_PATTERN = Pattern.compile("(?<!\\\\)<([^>]+)>");
    private String gherkinLanguage;
    private String featureName;
    private String scenarioName;
    private List<String> backgroundInstructions;
    private Map<Integer, Map<String, String>> datasetTable;

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public void setBackgroundInstructions(List<String> backgroundInstructions) {
        this.backgroundInstructions = backgroundInstructions;
    }

    public void setDatasetTable(Map<Integer, Map<String, String>> datasetTable) {
        this.datasetTable = datasetTable;
    }

    public String getGherkinLanguage() {
        return this.gherkinLanguage;
    }

    public void addFormattedBackground(String background, List<String> backgroundInstructions) {
        backgroundInstructions.addAll(List.of(BR_HTML_TAGS.split(background)));
    }

    public String generateGherkinScript(String language, List<CustomFieldXrayDto> gherkinStepCufs) {
        String steps = this.convertStepXrayToString(gherkinStepCufs);
        if (StringUtils.isNotBlank((CharSequence)steps)) {
            List<Token> tokens = this.getMatchedGherkinTokens(language, steps);
            if (tokens.isEmpty()) {
                return "";
            }
            this.gherkinLanguage = this.getGherkinScriptLanguage(tokens);
            GherkinKeywords gherkinKeywords = this.getGherkinKeywords(this.gherkinLanguage);
            steps = this.convertScriptToValidGherkinDocument(gherkinKeywords, this.gherkinLanguage, steps, tokens);
            int lastLine = steps.split("[\\n\\r]").length;
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(steps);
            gherkinDocument = this.mergeBackground(gherkinDocument, gherkinKeywords);
            gherkinDocument = this.mergeDatasetTableGherkinDocument(gherkinDocument, gherkinKeywords, lastLine);
            return GherkinDocumentPrinter.print(gherkinDocument);
        }
        return "";
    }

    private String convertStepXrayToString(List<CustomFieldXrayDto> gherkinStepCufs) {
        return gherkinStepCufs.stream().map(CustomFieldXrayDto::getValue).filter(StringUtils::isNotEmpty).map(cufValue -> BR_HTML_TAGS.matcher((CharSequence)cufValue).replaceAll(System.lineSeparator())).collect(Collectors.joining(System.lineSeparator()));
    }

    private List<Token> getMatchedGherkinTokens(String language, String xrayScript) {
        if (Objects.isNull(language)) {
            return this.getMatchedGherkinTokensEachLanguage(xrayScript);
        }
        List<Token> tokens = this.getMatchedGherkinTokensPrecedingLanguage(xrayScript, language);
        if (tokens.isEmpty()) {
            tokens = this.getMatchedGherkinTokensEachLanguage(xrayScript);
        }
        return tokens;
    }

    private List<Token> getMatchedGherkinTokensPrecedingLanguage(String xrayScript, String language) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringReader stringReader = new StringReader(xrayScript);){
            TokenScanner tokenScanner = new TokenScanner((Reader)stringReader);
            TokenMatcher tokenMatcher = new TokenMatcher(language);
            return this.matchGherkinTokens(tokenScanner, tokenMatcher);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Token> getMatchedGherkinTokensEachLanguage(String xrayScript) {
        return new GherkinDialectProvider().getLanguages().stream().map(language -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (StringReader stringReader = new StringReader(xrayScript);){
                TokenScanner tokenScanner = new TokenScanner((Reader)stringReader);
                TokenMatcher tokenMatcher = new TokenMatcher(language);
                return this.matchGherkinTokens(tokenScanner, tokenMatcher);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }).filter(tokens -> !tokens.isEmpty()).max(Comparator.comparingInt(List::size)).orElseThrow(RuntimeException::new);
    }

    private List<Token> matchGherkinTokens(TokenScanner tokenScanner, TokenMatcher tokenMatcher) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token token = tokenScanner.read();
        while (Objects.nonNull(token.line)) {
            tokenMatcher.match_FeatureLine(token);
            tokenMatcher.match_ScenarioLine(token);
            tokenMatcher.match_ScenarioOutlineLine(token);
            tokenMatcher.match_StepLine(token);
            tokenMatcher.match_ExamplesLine(token);
            tokenMatcher.match_BackgroundLine(token);
            if (Objects.nonNull(token.matchedType)) {
                tokens.add(token);
            }
            token = tokenScanner.read();
        }
        return tokens;
    }

    private String getGherkinScriptLanguage(List<Token> tokens) {
        return tokens.stream().map(token -> token.matchedGherkinDialect.getLanguage()).collect(Collectors.groupingBy(language -> language, Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(RuntimeException::new);
    }

    private GherkinKeywords getGherkinKeywords(String language) {
        GherkinDialect gherkinDialect = new GherkinDialectProvider().getDialect(language, null);
        return new GherkinKeywords(gherkinDialect);
    }

    private String convertScriptToValidGherkinDocument(GherkinKeywords gherkinKeywords, String language, String script, List<Token> tokens) {
        Token token = tokens.get(0);
        StringBuilder stringBuilder = new StringBuilder();
        this.convertScriptAddGherkinLine(stringBuilder, gherkinKeywords.getLanguage(), language);
        switch (token.matchedType) {
            case FeatureLine: {
                stringBuilder.append(script);
                break;
            }
            case BackgroundLine: 
            case ScenarioLine: 
            case ScenarioOutlineLine: {
                this.convertScriptAddGherkinLine(stringBuilder, gherkinKeywords.getFeature(), this.featureName);
                stringBuilder.append(script);
                break;
            }
            default: {
                this.convertScriptHandleStepLine(stringBuilder, script, gherkinKeywords, tokens);
            }
        }
        return stringBuilder.toString();
    }

    private void convertScriptHandleStepLine(StringBuilder stringBuilder, String script, GherkinKeywords gherkinKeywords, List<Token> tokens) {
        Optional<Token> scenarioToken = tokens.stream().filter(token -> token.matchedType == Parser.TokenType.ExamplesLine).findFirst();
        this.convertScriptAddGherkinLine(stringBuilder, gherkinKeywords.getFeature(), this.featureName);
        this.convertScriptAddGherkinLine(stringBuilder, gherkinKeywords.getScenario(scenarioToken.isPresent()), this.scenarioName);
        stringBuilder.append(script);
    }

    private void convertScriptAddGherkinLine(StringBuilder stringBuilder, String keyword, String value) {
        stringBuilder.append(keyword).append(":");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            stringBuilder.append(" ").append(value);
        }
        stringBuilder.append(System.lineSeparator());
    }

    private GherkinDocument mergeBackground(GherkinDocument gherkinDocument, GherkinKeywords gherkinKeywords) {
        if (this.backgroundInstructions == null || this.backgroundInstructions.isEmpty()) {
            return gherkinDocument;
        }
        LinkedList<Background> children = new LinkedList<Background>(gherkinDocument.getFeature().getChildren());
        Optional<Background> backgroundOptional = children.stream().filter(Background.class::isInstance).map(Background.class::cast).findFirst();
        if (backgroundOptional.isPresent()) {
            Background background = backgroundOptional.get();
            ArrayList<Step> steps = new ArrayList<Step>(background.getSteps());
            Location lastLocation = steps.isEmpty() ? background.getLocation() : ((Step)steps.get(steps.size() - 1)).getLocation();
            steps.addAll(this.backgroundInstructions.stream().map(instruction -> new Step(lastLocation, "", instruction, null)).toList());
            Background backgroundMerged = new Background(background.getLocation(), background.getKeyword(), background.getName(), background.getDescription(), steps);
            children.set(children.indexOf(background), backgroundMerged);
        } else {
            Location lastLocation = gherkinDocument.getFeature().getLocation();
            List<Step> steps = this.backgroundInstructions.stream().map(instruction -> new Step(lastLocation, "", instruction, null)).toList();
            Background backgroundMerged = new Background(lastLocation, gherkinKeywords.getBackground(), null, null, steps);
            children.add(0, backgroundMerged);
        }
        this.backgroundInstructions.clear();
        Feature feature = new Feature(gherkinDocument.getFeature().getTags(), gherkinDocument.getFeature().getLocation(), gherkinDocument.getFeature().getLanguage(), gherkinDocument.getFeature().getKeyword(), gherkinDocument.getFeature().getName(), gherkinDocument.getFeature().getDescription(), children);
        return new GherkinDocument(feature, gherkinDocument.getComments());
    }

    private GherkinDocument mergeDatasetTableGherkinDocument(GherkinDocument gherkinDocument, GherkinKeywords gherkinKeywords, int lastLine) {
        HashSet<String> matchDatasetParameters = new HashSet<String>();
        if (this.datasetTable == null || this.datasetTable.isEmpty()) {
            return gherkinDocument;
        }
        Set headers = this.datasetTable.values().stream().collect(TreeSet::new, (set, map) -> {
            boolean bl = set.addAll(map.keySet());
        }, Set::addAll);
        LinkedList<ScenarioDefinition> children = new LinkedList<ScenarioDefinition>(gherkinDocument.getFeature().getChildren());
        for (ScenarioDefinition child : children) {
            if (child instanceof Scenario var9_9) {
                matchDatasetParameters.addAll(this.mergeDatasetHandleScenario((Scenario)scenario, headers, gherkinKeywords, children));
                continue;
            }
            if (!(child instanceof ScenarioOutline var12_11)) continue;
            matchDatasetParameters.addAll(this.mergeDatasetHandleScenarioOutline((ScenarioOutline)scenarioOutline, headers, gherkinKeywords, children));
        }
        headers.clear();
        this.clearDatasetTableElementMerged(matchDatasetParameters);
        List<Comment> comments = this.addDatasetNotUsedToComment(gherkinDocument, lastLine);
        Feature feature = new Feature(gherkinDocument.getFeature().getTags(), gherkinDocument.getFeature().getLocation(), gherkinDocument.getFeature().getLanguage(), gherkinDocument.getFeature().getKeyword(), gherkinDocument.getFeature().getName(), gherkinDocument.getFeature().getDescription(), children);
        return new GherkinDocument(feature, comments);
    }

    private List<Comment> addDatasetNotUsedToComment(GherkinDocument gherkinDocument, int lastLine) {
        if (this.datasetTable.isEmpty()) {
            return gherkinDocument.getComments();
        }
        lastLine += 200;
        Set headers = this.datasetTable.values().stream().collect(TreeSet::new, (set, map) -> {
            boolean bl = set.addAll(map.keySet());
        }, Set::addAll);
        Map<String, Integer> columnWidths = this.calculateColumnWidths(headers, this.datasetTable);
        ArrayList<Comment> comments = new ArrayList<Comment>(gherkinDocument.getComments());
        comments.add(new Comment(new Location(lastLine++, 0), "# Dataset not used in the script"));
        comments.add(new Comment(new Location(lastLine++, 0), this.commentHeaderDataTable(headers, columnWidths)));
        for (Map<String, String> tableRow : this.datasetTable.values()) {
            comments.add(new Comment(new Location(lastLine++, 0), this.commentBodyDataTable(headers, tableRow, columnWidths)));
        }
        return comments;
    }

    private Map<String, Integer> calculateColumnWidths(Set<String> headers, Map<Integer, Map<String, String>> datasetTable) {
        HashMap<String, Integer> columnWidths = new HashMap<String, Integer>();
        headers.forEach(header -> {
            Integer n = columnWidths.put((String)header, header.length());
        });
        for (Map<String, String> row : datasetTable.values()) {
            for (String header2 : headers) {
                String value = row.getOrDefault(header2, "null");
                columnWidths.put(header2, Math.max((Integer)columnWidths.get(header2), value.length()));
            }
        }
        return columnWidths;
    }

    private String commentHeaderDataTable(Set<String> headers, Map<String, Integer> columnWidths) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# |");
        headers.forEach(header -> {
            String format = "%-" + columnWidths.get(header) + "s";
            stringBuilder.append(" ").append(String.format(format, header)).append(" |");
        });
        return stringBuilder.toString();
    }

    private String commentBodyDataTable(Set<String> headers, Map<String, String> tableRow, Map<String, Integer> columnWidths) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# |");
        headers.forEach(header -> {
            String value = tableRow.getOrDefault(header, "null");
            String format = "%-" + columnWidths.get(header) + "s";
            stringBuilder.append(" ").append(String.format(format, value)).append(" |");
        });
        return stringBuilder.toString();
    }

    private Set<String> mergeDatasetHandleScenarioOutline(ScenarioOutline scenarioOutline, Set<String> headers, GherkinKeywords gherkinKeywords, List<ScenarioDefinition> children) {
        HashSet<String> matchDatasetParameters = new HashSet<String>();
        this.getParametersInsideStep(scenarioOutline.getSteps(), headers, matchDatasetParameters);
        if (!matchDatasetParameters.isEmpty()) {
            ArrayList<Examples> examplesList = new ArrayList<Examples>(scenarioOutline.getExamples());
            Location lastLocation = this.getLastLocationExample(examplesList, scenarioOutline);
            if (examplesList.size() == 1) {
                this.mergeExamples(examplesList, lastLocation, matchDatasetParameters, gherkinKeywords);
            } else {
                examplesList.add(this.createNewExamples(lastLocation, matchDatasetParameters, gherkinKeywords));
            }
            ScenarioOutline scenarioOutlineMerged = new ScenarioOutline(scenarioOutline.getTags(), scenarioOutline.getLocation(), gherkinKeywords.getScenario(true), scenarioOutline.getName(), scenarioOutline.getDescription(), scenarioOutline.getSteps(), examplesList);
            children.set(children.indexOf(scenarioOutline), (ScenarioDefinition)scenarioOutlineMerged);
        }
        return matchDatasetParameters;
    }

    private Location getLastLocationExample(List<Examples> examplesList, ScenarioOutline scenarioOutline) {
        if (examplesList.isEmpty()) {
            return scenarioOutline.getLocation();
        }
        return examplesList.get(examplesList.size() - 1).getLocation();
    }

    private Set<String> mergeDatasetHandleScenario(Scenario scenario, Set<String> headers, GherkinKeywords gherkinKeywords, List<ScenarioDefinition> children) {
        HashSet<String> matchDatasetParameters = new HashSet<String>();
        this.getParametersInsideStep(scenario.getSteps(), headers, matchDatasetParameters);
        if (!matchDatasetParameters.isEmpty()) {
            Location lastLocation = ((Step)scenario.getSteps().get(scenario.getSteps().size() - 1)).getLocation();
            Examples example = this.createNewExamples(lastLocation, matchDatasetParameters, gherkinKeywords);
            ScenarioOutline scenarioOutline = new ScenarioOutline(scenario.getTags(), scenario.getLocation(), gherkinKeywords.getScenario(true), scenario.getName(), scenario.getDescription(), scenario.getSteps(), List.of(example));
            children.set(children.indexOf(scenario), (ScenarioDefinition)scenarioOutline);
        }
        return matchDatasetParameters;
    }

    private void clearDatasetTableElementMerged(Set<String> matchDatasetParameters) {
        this.datasetTable.values().forEach(row -> {
            boolean bl = row.keySet().removeIf(matchDatasetParameters::contains);
        });
        this.datasetTable.values().removeIf(Map::isEmpty);
    }

    private void mergeDatasetHandleMatchParameters(String line, Set<String> headers, Set<String> matchDatasetParameters) {
        Matcher stepParameterMatch = PARAMETER_GHERKIN_PATTERN.matcher(line);
        while (stepParameterMatch.find()) {
            String parameter = stepParameterMatch.group(1);
            if (!headers.contains(parameter)) continue;
            matchDatasetParameters.add(parameter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getParametersInsideStep(List<Step> steps, Set<String> headers, Set<String> matchDatasetParameters) {
        for (Step step : steps) {
            void dataTable;
            DataTable dataTable2;
            Node node;
            this.mergeDatasetHandleMatchParameters(step.getText(), headers, matchDatasetParameters);
            if (step.getArgument() == null || !((node = step.getArgument()) instanceof DataTable) || (dataTable2 = (DataTable)node) != (DataTable)node) continue;
            dataTable.getRows().forEach(row -> row.getCells().forEach(cell -> this.mergeDatasetHandleMatchParameters(cell.getValue(), headers, matchDatasetParameters)));
        }
    }

    private Examples createNewExamples(Location location, Set<String> matchDatasetParameters, GherkinKeywords gherkinKeywords) {
        List<TableCell> headerTableCells = matchDatasetParameters.stream().map(parameter -> new TableCell(location, parameter)).toList();
        TableRow headerTable = new TableRow(location, headerTableCells);
        List<TableRow> bodyTables = this.datasetTable.values().stream().map(datasetRowMap -> matchDatasetParameters.stream().map(parameter -> new TableCell(location, datasetRowMap.getOrDefault(parameter, "null"))).toList()).map(cells -> new TableRow(location, cells)).toList();
        return new Examples(location, Collections.emptyList(), gherkinKeywords.getExample(), null, null, headerTable, bodyTables);
    }

    private void mergeExamples(List<Examples> examplesList, Location location, Set<String> matchDatasetParameters, GherkinKeywords gherkinKeywords) {
        Examples examples = examplesList.get(0);
        TableRow headerTable = examples.getTableHeader();
        Set headers = headerTable.getCells().stream().map(TableCell::getValue).collect(Collectors.toSet());
        if (headers.containsAll(matchDatasetParameters)) {
            List<TableRow> datasetToMerge = this.datasetTable.values().stream().map(datasetRowMap -> headerTable.getCells().stream().map(cell -> new TableCell(location, datasetRowMap.getOrDefault(cell.getValue(), "null"))).toList()).map(cells -> new TableRow(location, cells)).toList();
            List<TableRow> bodyTables = this.mergeBodyTable(examples, datasetToMerge);
            Examples examplesMerged = new Examples(examples.getLocation(), examples.getTags(), examples.getKeyword(), examples.getName(), examples.getDescription(), examples.getTableHeader(), bodyTables);
            examplesList.set(0, examplesMerged);
        } else {
            examplesList.add(this.createNewExamples(location, matchDatasetParameters, gherkinKeywords));
        }
    }

    private List<TableRow> mergeBodyTable(Examples examples, List<TableRow> datasetToMerge) {
        ArrayList<TableRow> bodyTables = new ArrayList<TableRow>(examples.getTableBody());
        datasetToMerge.stream().filter(row2 -> bodyTables.stream().noneMatch(row1 -> GherkinScriptedStep.areCellsEqual(row1.getCells(), row2.getCells()))).forEach(bodyTables::add);
        return bodyTables;
    }

    private static boolean areCellsEqual(List<TableCell> cells1, List<TableCell> cells2) {
        if (cells1.size() != cells2.size()) {
            return false;
        }
        return cells1.stream().map(TableCell::getValue).toList().equals(cells2.stream().map(TableCell::getValue).toList());
    }

    private record GherkinKeywords(GherkinDialect gherkinDialect) {
        private static final String LANGUAGE_TAG = "# language";

        public String getLanguage() {
            return LANGUAGE_TAG;
        }

        public String getFeature() {
            return (String)this.gherkinDialect.getFeatureKeywords().get(0);
        }

        public String getBackground() {
            return (String)this.gherkinDialect.getBackgroundKeywords().get(0);
        }

        public String getScenario(boolean isParameter) {
            if (isParameter) {
                return (String)this.gherkinDialect.getScenarioOutlineKeywords().get(0);
            }
            return (String)this.gherkinDialect.getScenarioKeywords().get(0);
        }

        public String getExample() {
            return (String)this.gherkinDialect.getExamplesKeywords().get(0);
        }
    }
}

