/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.testcaseworkspace;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DatasetToPivot {
    @JsonProperty(value="id")
    private String pivotId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="param_values")
    private List<ParamValue> paramValues = new ArrayList<ParamValue>();

    public String getPivotId() {
        return this.pivotId;
    }

    public void setPivotId(String testCasePivotId, Integer id) {
        this.pivotId = String.format("%s_%s%s", testCasePivotId, "DS", id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isParametersPresent(Map<String, String> parameters) {
        if (parameters.size() != this.paramValues.size()) {
            return false;
        }
        return this.paramValues.stream().allMatch(paramValue -> parameters.containsKey(paramValue.getName()) && ((String)parameters.get(paramValue.getName())).equals(paramValue.getValue()));
    }

    public List<ParamValue> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List<ParamValue> paramValues) {
        this.paramValues = paramValues;
    }

    public static class ParamValue {
        @JsonProperty(value="param_id")
        private String id;
        @JsonProperty(value="value")
        private String value;
        @JsonIgnore
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

