/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetParamValueToImport;
import org.squashtest.tm.service.testcase.ParameterFinder;

public class DatasetToImport {
    private String internalId;
    private String name;
    private List<DatasetParamValueToImport> paramValues = new ArrayList<DatasetParamValueToImport>();

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DatasetParamValueToImport> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List<DatasetParamValueToImport> paramValues) {
        this.paramValues = paramValues;
    }

    public Dataset toDataset(ParameterFinder parameterFinder, Map<String, Long> datasetParamIdsMap) {
        Dataset dataset = new Dataset();
        dataset.setName(this.name);
        List<Long> squashParamIds = this.paramValues.stream().map(value -> (Long)datasetParamIdsMap.get(value.getInternalParamId())).toList();
        List<Parameter> parameters = parameterFinder.findByIds(squashParamIds);
        for (DatasetParamValueToImport value2 : this.paramValues) {
            Long squashParamId = datasetParamIdsMap.get(value2.getInternalParamId());
            Parameter parameter = parameters.stream().filter(p -> p.getId().equals(squashParamId)).findFirst().orElseThrow();
            new DatasetParamValue(parameter, dataset, value2.getValue());
        }
        return dataset;
    }
}

