/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueOption;
import org.squashtest.tm.domain.customfield.CustomFieldValueVisitor;
import org.squashtest.tm.domain.customfield.NumericCustomFieldValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.customfield.TagsValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedMultiSelectField;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedNumericValue;
import org.squashtest.tm.service.internal.dto.BindableEntityModel;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.internal.dto.InputTypeModel;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.dto.RenderingLocationModel;

@Component
public class CustomFieldJsonConverter {
    @Inject
    private MessageSource messageSource;
    @Inject
    private CustomFieldModelFactory customFieldFactory;

    public CustomFieldJsonConverter() {
    }

    public CustomFieldJsonConverter(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public RenderingLocationModel toJson(RenderingLocation location) {
        RenderingLocationModel model = new RenderingLocationModel();
        model.setEnumName(location.toString());
        model.setFriendlyName(this.getMessage(location.getI18nKey()));
        return model;
    }

    public RenderingLocationModel[] toJson(Collection<RenderingLocation> values) {
        RenderingLocationModel[] modelArray = new RenderingLocationModel[values.size()];
        int i = 0;
        for (RenderingLocation location : values) {
            modelArray[i++] = this.toJson(location);
        }
        return modelArray;
    }

    public CustomFieldBindingModel toJson(CustomFieldBinding binding) {
        CustomFieldBindingModel bindingModel = new CustomFieldBindingModel();
        BindableEntityModel entityModel = this.toJson(binding.getBoundEntity());
        RenderingLocationModel[] locationArrayModel = this.toJson(binding.getRenderingLocations());
        CustomFieldModel<?> fieldModel = this.toJson(binding.getCustomField());
        bindingModel.setId(binding.getId());
        bindingModel.setProjectId(binding.getBoundProject().getId());
        bindingModel.setBoundEntity(entityModel);
        bindingModel.setCustomField(fieldModel);
        bindingModel.setRenderingLocations(locationArrayModel);
        bindingModel.setPosition(binding.getPosition());
        return bindingModel;
    }

    public BindableEntityModel toJson(BindableEntity entity) {
        BindableEntityModel model = new BindableEntityModel();
        model.setEnumName(entity.toString());
        model.setFriendlyName(this.getMessage(entity.getI18nKey()));
        return model;
    }

    public CustomFieldModel<?> toJson(CustomField field) {
        return this.customFieldFactory.createCustomFieldModel(field);
    }

    public CustomFieldValueModel toJson(CustomFieldValue value) {
        final CustomFieldValueModel model = this.createStdCustomFieldValues(value);
        CustomFieldValueVisitor visitor = new CustomFieldValueVisitor(){

            public void visit(CustomFieldValue customFieldValue) {
                model.setValue(customFieldValue.getValue());
            }

            public void visit(NumericCustomFieldValue customFieldValue) {
                String formatedValue = NumericCufHelper.formatOutputNumericCufValue(customFieldValue.getValue());
                model.setValue(formatedValue);
            }

            public void visit(RichTextValue customFieldValue) {
                model.setValue(customFieldValue.getValue());
            }

            public void visit(TagsValue customFieldValue) {
                CustomFieldJsonConverter.this.toJson(customFieldValue, model);
            }
        };
        value.accept(visitor);
        return model;
    }

    private void toJson(TagsValue value, CustomFieldValueModel model) {
        ArrayList<String> options = new ArrayList<String>(value.getSelectedOptions().size());
        for (CustomFieldValueOption option : value.getSelectedOptions()) {
            options.add(option.getLabel());
        }
        model.setOptionValues(options);
    }

    private <CF extends CustomFieldValue> CustomFieldValueModel createStdCustomFieldValues(CF value) {
        CustomFieldValueModel model = new CustomFieldValueModel();
        BindableEntityModel entityTypeModel = this.toJson(value.getBoundEntityType());
        CustomFieldBindingModel bindingModel = this.toJson(value.getBinding());
        model.setId(value.getId());
        model.setBoundEntityId(value.getBoundEntityId());
        model.setBoundEntityType(entityTypeModel);
        model.setBinding(bindingModel);
        return model;
    }

    public CustomFieldModel<?> toCustomFieldJsonModel(DenormalizedFieldValue field) {
        return this.customFieldFactory.createCustomFieldModel(field);
    }

    public CustomFieldValueModel toJson(DenormalizedFieldValue value) {
        CustomFieldValueModel model = new CustomFieldValueModel();
        CustomFieldBindingModel bindingModel = new CustomFieldBindingModel();
        bindingModel.setPosition(value.getPosition());
        bindingModel.setRenderingLocations(this.toJson(value.getRenderingLocations()));
        InputTypeModel inputTypeModel = new InputTypeModel();
        inputTypeModel.setEnumName(value.getInputType().name());
        inputTypeModel.setFriendlyName(value.getInputType().name());
        CustomFieldModel<?> customFieldModel = this.toCustomFieldJsonModel(value);
        BindableEntityModel bindableEntityModel = new BindableEntityModel();
        bindableEntityModel.setEnumName(value.getDenormalizedFieldHolderType().name());
        bindableEntityModel.setFriendlyName(value.getDenormalizedFieldHolderType().name());
        bindingModel.setBoundEntity(bindableEntityModel);
        model.setId(value.getId());
        model.setBoundEntityId(value.getDenormalizedFieldHolderId());
        model.setBinding(bindingModel);
        if (value instanceof DenormalizedMultiSelectField) {
            model.setOptionValues(((DenormalizedMultiSelectField)value).getValues());
        } else if (DenormalizedNumericValue.class.isAssignableFrom(value.getClass())) {
            model.setValue(NumericCufHelper.formatOutputNumericCufValue(value.getValue()));
        } else {
            model.setValue(value.getValue());
        }
        bindingModel.setCustomField(customFieldModel);
        return model;
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }
}

