/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testplan;

import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.service.display.testplan.SprintTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.campaign.AvailableDatasetAppender;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.campaign.SprintReqTestPlanItemSuccessRateCalculator;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintOverallExecPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintReqVersionTestPlanGrid;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;

@Service
@Transactional(readOnly=true)
public class SprintTestPlanDisplayServiceImpl
implements SprintTestPlanDisplayService {
    private final DSLContext dslContext;
    private final AvailableDatasetAppender availableDatasetAppender;
    private final ExecutionDao executionDao;
    private final SprintReqTestPlanItemSuccessRateCalculator successRateCalculator;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;

    public SprintTestPlanDisplayServiceImpl(DSLContext dslContext, AvailableDatasetAppender availableDatasetAppender, ExecutionDao executionDao, SprintReqTestPlanItemSuccessRateCalculator successRateCalculator, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper) {
        this.dslContext = dslContext;
        this.availableDatasetAppender = availableDatasetAppender;
        this.executionDao = executionDao;
        this.successRateCalculator = successRateCalculator;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
    }

    @Override
    public GridResponse findSprintReqVersionTestPlan(Long testPlanId, GridRequest gridRequest) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(testPlanId, TestPlan.class.getName());
        SprintReqVersionTestPlanGrid sprintReqVersionTestPlanGrid = new SprintReqVersionTestPlanGrid(testPlanId, userToRestrictTo);
        GridResponse gridResponse = sprintReqVersionTestPlanGrid.getRows(gridRequest, this.dslContext);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        gridResponse.getDataRows().forEach(this::addLastExecutionStatuses);
        this.successRateCalculator.appendSuccessRate(gridResponse);
        return gridResponse;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public GridResponse findSprintOverallExecPlan(long sprintId, GridRequest gridRequest) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        SprintOverallExecPlanGrid sprintOverallExecPlanGrid = new SprintOverallExecPlanGrid(sprintId, userToRestrictTo);
        GridResponse gridResponse = sprintOverallExecPlanGrid.getRows(gridRequest, this.dslContext);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        gridResponse.getDataRows().forEach(this::addLastExecutionStatuses);
        this.successRateCalculator.appendSuccessRate(gridResponse);
        return gridResponse;
    }

    private void addLastExecutionStatuses(DataRow row) {
        Long testPlanItemId = (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_PLAN_ITEM_ID"));
        row.addData(RequestAliasesConstants.toCamelCase("LAST_EXECUTION_STATUSES"), this.executionDao.findSprintTestPlanItemLastExecStatuses(testPlanItemId));
    }
}

