/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.QIterationTestPlanItem;
import org.squashtest.tm.domain.execution.QExecution;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class ExecutionModeFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"EXECUTION_EXECUTION_MODE"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        QIterationTestPlanItem outerItpi = QIterationTestPlanItem.iterationTestPlanItem;
        QIterationTestPlanItem initItpi = new QIterationTestPlanItem("initItpi");
        QExecution execution = new QExecution("execution");
        List<String> values = filter.getValues();
        ArrayList<BooleanExpression> expressions = new ArrayList<BooleanExpression>();
        for (String value : values) {
            if ("UNDEFINED".equals(value)) {
                expressions.add(execution.executionMode.isNull());
                continue;
            }
            expressions.add(execution.executionMode.eq((Object)TestCaseExecutionMode.valueOf((String)value)));
        }
        HibernateQuery subQuery = (HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initItpi)).leftJoin((CollectionExpression)initItpi.executions, (Path)execution)).where((Predicate)initItpi.id.eq((Expression)outerItpi.id).and((Predicate)Expressions.anyOf((BooleanExpression[])expressions.toArray(new BooleanExpression[expressions.size()]))));
        query.where((Predicate)subQuery.exists());
    }
}

