/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.search;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.GridSort;

public class FieldTestCaseSearchSort<T> {
    private static final Pattern CUF_GRID_PROPERTY = Pattern.compile("cuf|(\\d+)");
    private final Field<T> aliasField;
    private final GridSort.SortDirection sortDirection;

    public FieldTestCaseSearchSort(Field<T> aliasField, GridSort.SortDirection sortDirection) {
        this.aliasField = aliasField;
        this.sortDirection = sortDirection;
    }

    public Field<T> getAliasField() {
        return this.aliasField;
    }

    public SortField<T> getSortField() {
        return this.getSortField(this.aliasField);
    }

    private static String getNormalizeFieldName(String camelCase) {
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        return (String)converter.convert((Object)camelCase);
    }

    public static FieldTestCaseSearchSort<?> getTestCaseSelectSearch(GridSort gridSort) {
        FieldTestCaseSearchSort fieldTestCaseSearchSort;
        String name = FieldTestCaseSearchSort.getNormalizeFieldName(gridSort.getProperty());
        Matcher cufMatcher = CUF_GRID_PROPERTY.matcher(name);
        if (cufMatcher.find()) {
            Field<?> fieldCuf = FieldTestCaseSearchSort.getFieldCuf(Long.parseLong(cufMatcher.group(1)), name);
            fieldTestCaseSearchSort = new FieldTestCaseSearchSort(fieldCuf, gridSort.getDirection());
        } else {
            TestCaseSortField testCaseSortField = Stream.of(TestCaseSortField.values()).filter(testCaseSelectSearch -> testCaseSelectSearch.name().equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException("No such field with the property: " + name));
            fieldTestCaseSearchSort = new FieldTestCaseSearchSort(testCaseSortField.getField(), gridSort.getDirection());
        }
        return fieldTestCaseSearchSort;
    }

    private SortField<T> getSortField(Field<T> field) {
        return this.sortDirection == GridSort.SortDirection.ASC ? field.asc() : field.desc();
    }

    private static Field<?> getFieldCuf(Long cufId, String alias) {
        return DSL.select((SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)String.valueOf(InputType.TAG)), (Field)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(", ")).otherwise((Field)Tables.CUSTOM_FIELD_VALUE.VALUE)).from((TableLike)Tables.CUSTOM_FIELD_VALUE).leftOuterJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Object)cufId)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)BindableEntity.TEST_CASE.name())).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, Tables.CUSTOM_FIELD_VALUE.VALUE}).asField(alias);
    }

    private static enum TestCaseSortField {
        PROJECT_NAME((Field<?>)Tables.PROJECT.NAME),
        ID((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID),
        NAME((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME),
        REFERENCE((Field<?>)Tables.TEST_CASE.REFERENCE),
        STATUS(TestCaseSortField.getFieldStatus()),
        IMPORTANCE(TestCaseSortField.getFieldImportance()),
        NATURE(TestCaseSortField.getFieldNature()),
        TYPE(TestCaseSortField.getFieldType()),
        KIND(TestCaseSortField.getFieldKind()),
        DESCRIPTION((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION),
        AUTOMATABLE(TestCaseSortField.getFieldAutomatable()),
        AUTOMATION_PRIORITY((Field<?>)Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY),
        TRANSMITTED_ON((Field<?>)Tables.AUTOMATION_REQUEST.TRANSMITTED_ON),
        REQUEST_STATUS(TestCaseSortField.getFieldRequestStatus()),
        HAS_AUTO_SCRIPT(TestCaseSortField.getFieldHasAutoScript()),
        AUTOMATED_TEST_TECHNOLOGY(TestCaseSortField.getFieldAutomatedTestTechnology()),
        HAS_BOUND_SCM_REPOSITORY(TestCaseSortField.getFieldHasBoundScmRepository()),
        HAS_BOUND_AUTOMATED_TEST_REFERENCE(TestCaseSortField.getFieldHasBoundAutomatedTestReference()),
        CREATED_ON((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON),
        CREATED_BY((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY),
        LAST_MODIFIED_ON((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON),
        LAST_MODIFIED_BY((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY),
        DRAFTED_BY_AI((Field<?>)Tables.TEST_CASE.DRAFTED_BY_AI),
        MILESTONE_LABELS(TestCaseSortField.getFieldMilestoneLabel()),
        MILESTONE_STATUS(TestCaseSortField.getFieldMilestoneStatus()),
        MILESTONE_END_DATE(TestCaseSortField.getFieldMilestoneEndDate()),
        REQ_MILESTONE_LOCKED(TestCaseSortField.getFieldMilestoneReqLocked()),
        ITERATION_LIST(TestCaseSortField.getFieldIterationList()),
        TEST_SUITE_LIST(TestCaseSortField.getFieldTestSuiteList()),
        CAMPAIGN_LIST(TestCaseSortField.getFieldCampaignList()),
        TC_MILESTONE_LOCKED(TestCaseSortField.getFieldTcMilestoneLocked()),
        ATTACHMENTS(TestCaseSortField.getFieldCountAttachement()),
        COVERAGES(TestCaseSortField.getFieldCountCoverage()),
        STEPS(TestCaseSortField.getFieldCountStep()),
        PARAM_COUNT(TestCaseSortField.getFieldCountParameter()),
        DATASETS(TestCaseSortField.getFieldCountDataset()),
        ITERATIONS(TestCaseSortField.getFieldCountIteration()),
        EXECUTION_COUNT(TestCaseSortField.getFieldCountExecution()),
        ISSUE_COUNT(TestCaseSortField.getFieldCountIssue()),
        MILESTONES(TestCaseSortField.getFieldCountMilestone());

        private final Field<?> selectField;

        private TestCaseSortField(Field<?> selectField) {
            this.selectField = selectField.as(this.name());
        }

        public Field<?> getField() {
            return this.selectField;
        }

        private static Field<String> getFieldNature() {
            return DSL.select((SelectField)Tables.INFO_LIST_ITEM.CODE).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).asField();
        }

        private static Field<String> getFieldType() {
            return DSL.select((SelectField)Tables.INFO_LIST_ITEM.CODE).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).asField();
        }

        private static Field<Integer> getFieldKind() {
            return DSL.case_().when(Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)2).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)3).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)4).when(Tables.TEST_CASE.TCLN_ID.isNotNull(), (Object)1);
        }

        private static Field<Integer> getFieldHasAutoScript() {
            return DSL.case_().when(Tables.AUTOMATED_TEST.TEST_ID.isNotNull(), (Object)2).otherwise((Object)1);
        }

        private static Field<Integer> getFieldHasBoundScmRepository() {
            return DSL.case_().when(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull(), (Object)2).otherwise((Object)1);
        }

        private static Field<Integer> getFieldHasBoundAutomatedTestReference() {
            return DSL.case_().when(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull(), (Object)2).otherwise((Object)1);
        }

        private static Field<Integer> getFieldAutomatedTestTechnology() {
            return DSL.select((SelectField)Tables.AUTOMATED_TEST_TECHNOLOGY.NAME).from((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).where(Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID.eq((Field)Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY)).asField();
        }

        private static Field<?> getFieldMilestoneLabel() {
            Field milestoneLabel = DSL.select((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE_TEST_CASE).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
            return DSL.groupConcat((Field)milestoneLabel).separator(", ").as("MILESTONE_LABELS");
        }

        private static Field<?> getFieldMilestoneStatus() {
            Field milestoneStatus = DSL.select((SelectField)Tables.MILESTONE.STATUS).from((TableLike)Tables.MILESTONE_TEST_CASE).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
            return DSL.groupConcat((Field)milestoneStatus).separator(", ").as("MILESTONE_STATUS");
        }

        private static Field<?> getFieldMilestoneEndDate() {
            Field milestoneEndDate = DSL.select((SelectField)Tables.MILESTONE.END_DATE).from((TableLike)Tables.MILESTONE_TEST_CASE).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
            return DSL.groupConcat((Field)milestoneEndDate).separator(", ").as("MILESTONE_END_DATE");
        }

        private static Field<?> getFieldMilestoneReqLocked() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.MILESTONE.STATUS.eq((Object)"LOCKED")).asField();
        }

        private static Field<?> getFieldIterationList() {
            return DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID)).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).join((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
        }

        private static Field<?> getFieldTestSuiteList() {
            return DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
        }

        private static Field<?> getFieldCampaignList() {
            return DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
        }

        private static Field<?> getFieldTcMilestoneLocked() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_TEST_CASE).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(Tables.MILESTONE.STATUS.eq((Object)"LOCKED")).asField();
        }

        private static Field<Integer> getFieldCountAttachement() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ATTACHMENT.ATTACHMENT_ID)).from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID)).asField();
        }

        private static Field<Integer> getFieldCountCoverage() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountStep() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.TEST_CASE_STEPS.STEP_ID)).from((TableLike)Tables.TEST_CASE_STEPS).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountParameter() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.PARAMETER.PARAM_ID)).from((TableLike)Tables.PARAMETER).where(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountDataset() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.DATASET.DATASET_ID)).from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountIteration() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID)).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).join((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountExecution() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.EXECUTION.EXECUTION_ID)).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldCountIssue() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID)).from((TableLike)Tables.ISSUE).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
        }

        private static Field<?> getFieldCountMilestone() {
            return DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
        }

        private static Field<Integer> getFieldStatus() {
            Map tcStatusMap = Arrays.stream(TestCaseStatus.values()).collect(Collectors.toMap(Enum::name, Level::getLevel, (a, b) -> a, LinkedHashMap::new));
            return DSL.case_((Field)Tables.TEST_CASE.TC_STATUS).mapValues(tcStatusMap);
        }

        private static Field<Integer> getFieldImportance() {
            Map tcImportanceMap = Arrays.stream(TestCaseImportance.values()).collect(Collectors.toMap(Enum::name, Level::getLevel, (a, b) -> a, LinkedHashMap::new));
            return DSL.case_((Field)Tables.TEST_CASE.IMPORTANCE).mapValues(tcImportanceMap);
        }

        private static Field<Integer> getFieldAutomatable() {
            Map tcAutomatableMap = Arrays.stream(TestCaseAutomatable.values()).collect(Collectors.toMap(Enum::name, Level::getLevel, (a, b) -> a, LinkedHashMap::new));
            return DSL.case_((Field)Tables.TEST_CASE.AUTOMATABLE).mapValues(tcAutomatableMap);
        }

        private static Field<Integer> getFieldRequestStatus() {
            Map automationRequestStatusMap = Arrays.stream(AutomationRequestStatus.values()).collect(Collectors.toMap(Enum::name, Level::getLevel, (a, b) -> a, LinkedHashMap::new));
            return DSL.case_((Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS).mapValues(automationRequestStatusMap);
        }
    }
}

