/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractAutomatedSuiteGrid;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

public class TestSuiteAutomatedSuiteGrid
extends AbstractAutomatedSuiteGrid {
    private final Long testSuiteId;
    private final AutomatedSuiteDisplayDao automatedSuiteDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;

    public TestSuiteAutomatedSuiteGrid(Long testSuiteId, MessageSource messageSource, AutomatedSuiteDisplayDao automatedSuiteDisplayDao, PermissionEvaluationService permissionEvaluationService) {
        super(messageSource);
        this.testSuiteId = testSuiteId;
        this.automatedSuiteDisplayDao = automatedSuiteDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        if (request.getFilterValues().isEmpty() && this.currentUserCanReadUnassigned(this.testSuiteId)) {
            return this.automatedSuiteDisplayDao.countAutomatedSuiteByTestSuiteId(this.testSuiteId);
        }
        return super.countRows(dslContext, request);
    }

    @Override
    protected Table<?> getTable() {
        return this.getSelectFields().from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)Tables.TEST_SUITE).on(AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.TEST_SUITE.ID.eq((Object)this.testSuiteId)).union((Select)this.getSelectFields().from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).join((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).join((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)this.testSuiteId))).asTable();
    }

    private boolean currentUserCanReadUnassigned(Long testSuiteId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), testSuiteId, "org.squashtest.tm.domain.campaign.TestSuite");
    }
}

