/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record10;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public abstract class AbstractAutomatedSuiteGrid
extends AbstractGrid {
    private static final String AUTOMATED_EXECUTION_EXTENDER_TYPE = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER.name();
    protected final MessageSource messageSource;

    protected AbstractAutomatedSuiteGrid(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"SUITE_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"CREATED_ON").coerce(Timestamp.class)), new GridColumn(DSL.field((String)"CREATED_BY")), new GridColumn(DSL.field((String)"EXECUTION_STATUS")), new GridColumn(DSL.field((String)"LAST_MODIFIED_ON").coerce(Timestamp.class)), new GridColumn(DSL.field((String)"SUITE_ID")), new GridColumn(DSL.field((String)"ENVIRONMENT_VARIABLES")), new GridColumn(DSL.field((String)"ENVIRONMENT_TAGS")), new GridColumn(DSL.field((String)"LAUNCHED_FROM")), new GridColumn(DSL.field((String)"PROJECT_ID")));
    }

    protected SelectSelectStep<Record10<Timestamp, String, String, Timestamp, String, String, String, Long, String, Long>> getSelectFields() {
        return DSL.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON.as("CREATED_ON"), (SelectField)AutomatedSuite.AUTOMATED_SUITE.CREATED_BY.as("CREATED_BY"), (SelectField)AutomatedSuite.AUTOMATED_SUITE.EXECUTION_STATUS.as("EXECUTION_STATUS"), (SelectField)AutomatedSuite.AUTOMATED_SUITE.LAST_MODIFIED_ON.as("LAST_MODIFIED_ON"), (SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.as("SUITE_ID"), (SelectField)DSL.field(this.getDenormalizedEnvironmentVariables()).coerce(String.class).as("ENVIRONMENT_VARIABLES"), (SelectField)DSL.field(this.getDenormalizedEnvironmentTags()).coerce(String.class).as("ENVIRONMENT_TAGS"), (SelectField)AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.as("ITERATION_ID"), (SelectField)DSL.when((Condition)AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.isNotNull(), (Object)this.messageSource.getMessage("iteration.header.title", null, LocaleContextHolder.getLocale())).otherwise((Object)this.messageSource.getMessage("test-suite.launcher.title", null, LocaleContextHolder.getLocale())).as("LAUNCHED_FROM"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID"));
    }

    public SelectHavingStep<Record1<String>> getDenormalizedEnvironmentVariables() {
        return DSL.select((SelectField)DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.NAME, DSL.val((String)" : "), Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.VALUE})).separator(", ").as("ENVIRONMENT_VARIABLES")).from((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).join((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).where(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE).and(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)));
    }

    public SelectHavingStep<Record1<String>> getDenormalizedEnvironmentTags() {
        return DSL.select((SelectField)DSL.substring((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)DSL.concat((Field[])new Field[]{DSL.inline((String)", "), DSL.groupConcatDistinct((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE).separator(", ")}), (Object)""), DSL.coalesce((Field)DSL.concat((Field[])new Field[]{DSL.inline((String)", "), DSL.groupConcatDistinct((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY).separator(", ")}), (Object)"")}), (int)3).as("ENVIRONMENT_TAGS")).from((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).leftJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID)).and(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE)).where(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID));
    }
}

