/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.execution;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.logging.log4j.util.Strings;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record3;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.LatestExploratoryExecutionEvent;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.execution.ExecutionStepHasNoModifiableStepException;
import org.squashtest.tm.exception.execution.ModifDuringExecMissingReadPermissionException;
import org.squashtest.tm.exception.execution.ModifDuringExecMissingWritePermissionException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.display.execution.ExecutionDisplayService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.RequirementVersionCoverageDto;
import org.squashtest.tm.service.internal.display.dto.execution.ActionStepExecView;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionView;
import org.squashtest.tm.service.internal.display.dto.execution.ModificationDuringExecutionView;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.display.execution.ExecutionDisplayServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.testcase.TestCaseExecutionGrid;
import org.squashtest.tm.service.internal.dto.DenormalizedEnvironmentTagDto;
import org.squashtest.tm.service.internal.dto.DenormalizedEnvironmentVariableDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.CustomDenormalizedEnvironmentTagDao;
import org.squashtest.tm.service.internal.repository.CustomDenormalizedEnvironmentVariableDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.DenormalizedCustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ExecutionDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ExecutionStepDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionCoverageDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestStepDisplayDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectFinderService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional(readOnly=true)
public class ExecutionDisplayServiceImpl
implements ExecutionDisplayService {
    private final ExecutionDisplayDao executionDisplayDao;
    private final ExecutionStepDisplayDao executionStepDisplayDao;
    private final DenormalizedCustomFieldValueDisplayDao denormalizedCustomFieldValueDisplayDao;
    private final CustomFieldValueDisplayDao customFieldValueDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final RequirementVersionCoverageDisplayDao requirementVersionCoverageDisplayDao;
    private final TestCaseCallTreeFinder testCaseCallTreeFinder;
    private final DSLContext dslContext;
    private final ExecutionModificationService executionModificationService;
    private final TestAutomationProjectFinderService testAutomationProjectFinderService;
    private final ExecutionKnownIssueFinder executionKnownIssueFinder;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final TestStepDisplayDao testStepDisplayDao;
    private final CustomDenormalizedEnvironmentVariableDao denormalizedEnvironmentVariableDao;
    private final CustomDenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final EntityManager entityManager;
    private final MessageSource messageSource;
    private final EntityPathHeaderService entityPathHeaderService;
    private final ProjectsPermissionFinder projectsPermissionFinder;
    private final UserAccountService userAccountService;
    private final SessionNoteDisplayDao sessionNoteDisplayDao;
    private final ExploratoryExecutionService exploratoryExecutionService;
    private final SprintManagerService sprintManagerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ExecutionDisplayServiceImpl(ExecutionDisplayDao executionDisplayDao, ExecutionStepDisplayDao executionStepDisplayDao, DenormalizedCustomFieldValueDisplayDao denormalizedCustomFieldValueDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao, AttachmentDisplayDao attachmentDisplayDao, RequirementVersionCoverageDisplayDao requirementVersionCoverageDisplayDao, TestCaseCallTreeFinder testCaseCallTreeFinder, DSLContext dslContext, ExecutionModificationService executionModificationService, TestAutomationProjectFinderService testAutomationProjectFinderService, ExecutionKnownIssueFinder executionKnownIssueFinder, MilestoneDisplayDao milestoneDisplayDao, TestStepDisplayDao testStepDisplayDao, CustomDenormalizedEnvironmentVariableDao denormalizedEnvironmentVariableDao, CustomDenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao, PermissionEvaluationService permissionEvaluationService, EntityManager entityManager, MessageSource messageSource, EntityPathHeaderService entityPathHeaderService, ProjectsPermissionFinder projectsPermissionFinder, UserAccountService userAccountService, SessionNoteDisplayDao sessionNoteDisplayDao, ExploratoryExecutionService exploratoryExecutionService, SprintManagerService sprintManagerService) {
        this.executionDisplayDao = executionDisplayDao;
        this.executionStepDisplayDao = executionStepDisplayDao;
        this.denormalizedCustomFieldValueDisplayDao = denormalizedCustomFieldValueDisplayDao;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.requirementVersionCoverageDisplayDao = requirementVersionCoverageDisplayDao;
        this.testCaseCallTreeFinder = testCaseCallTreeFinder;
        this.dslContext = dslContext;
        this.executionModificationService = executionModificationService;
        this.testAutomationProjectFinderService = testAutomationProjectFinderService;
        this.executionKnownIssueFinder = executionKnownIssueFinder;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.testStepDisplayDao = testStepDisplayDao;
        this.denormalizedEnvironmentVariableDao = denormalizedEnvironmentVariableDao;
        this.denormalizedEnvironmentTagDao = denormalizedEnvironmentTagDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.entityManager = entityManager;
        this.messageSource = messageSource;
        this.entityPathHeaderService = entityPathHeaderService;
        this.projectsPermissionFinder = projectsPermissionFinder;
        this.userAccountService = userAccountService;
        this.sessionNoteDisplayDao = sessionNoteDisplayDao;
        this.exploratoryExecutionService = exploratoryExecutionService;
        this.sprintManagerService = sprintManagerService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse findByTestCaseId(Long testCaseId, GridRequest request) {
        TestCaseExecutionGrid grid = new TestCaseExecutionGrid(testCaseId);
        return grid.getRows(request, this.dslContext);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    public ExecutionView findOne(Long executionId) {
        ExecutionView executionView = this.executionDisplayDao.findExecutionView(executionId);
        this.checkIfCurrentUserCanConsultExecution(executionView);
        this.fetchDenormalizedCustomFieldValues(executionView);
        this.fetchCustomFieldValues(executionView);
        this.fetchExecutionSteps(executionView);
        this.fetchAttachmentList(executionView);
        this.fetchCoverages(executionView);
        this.fetchAutomatedJobUrl(executionView);
        this.fetchDenormalizedEnvironments(executionView);
        this.fetchSessionNotes(executionView);
        executionView.setNbIssues(this.executionKnownIssueFinder.countKnownIssues(executionId));
        executionView.setMilestones(this.milestoneDisplayDao.getMilestonesByExecutionId(executionId));
        executionView.setPath(this.entityPathHeaderService.buildExecutionPathHeader(executionId));
        executionView.setExploratorySessionOverviewInfo(this.executionDisplayDao.findSessionByExecutionId(executionId));
        executionView.setExploratoryExecutionRunningState(this.exploratoryExecutionService.findExploratoryExecutionRunningState(executionId));
        LatestExploratoryExecutionEvent latestExploratoryExecutionEvent = this.exploratoryExecutionService.fetchLatestExploratoryExecutionEvent(executionId);
        executionView.setLatestExploratoryExecutionEvent(latestExploratoryExecutionEvent);
        return executionView;
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Execution.class)
    public ExecutionView findOneWithoutBlockingMilestoneOrSprint(@Id Long executionId) {
        if (SprintStatus.CLOSED.equals((Object)this.sprintManagerService.getSprintStatusByExecutionId(executionId))) {
            throw new SprintClosedException();
        }
        return this.findOne(executionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    public AttachmentListDto findAttachmentList(Long executionId) {
        Long attachmentListId = this.executionDisplayDao.findAttachmentList(executionId);
        return this.attachmentDisplayDao.findAttachmentListById(attachmentListId);
    }

    private void checkIfCurrentUserCanConsultExecution(ExecutionView executionView) {
        boolean isNotAssigned;
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        boolean isAdmin = currentUser.isAdmin();
        if (isAdmin) {
            return;
        }
        boolean isExploratory = TestCaseExecutionMode.EXPLORATORY.name().equals(executionView.getExecutionMode());
        if (isExploratory) {
            return;
        }
        Long userId = currentUser.getUserId();
        List<ProjectPermission> projectPermissions = this.projectsPermissionFinder.findProjectPermissionByParty(userId);
        boolean isTesterOnProject = projectPermissions.stream().anyMatch(projectPermission -> projectPermission.getProject().getId().longValue() == executionView.getProjectId() && "squashtest.acl.group.tm.TestRunner".equals(projectPermission.getPermissionGroup().getQualifiedName()));
        boolean bl = isNotAssigned = executionView.getAssigneeId() == null || !executionView.getAssigneeId().equals(userId);
        if (isTesterOnProject && isNotAssigned) {
            throw new AccessDeniedException("User cannot consult the execution because not assigned on it.");
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    public ModificationDuringExecutionView findOneForModificationDuringExec(Long executionId) {
        ModificationDuringExecutionView view = new ModificationDuringExecutionView();
        view.setExecutionStepActionTestStepPairs(this.executionDisplayDao.findExecutionStepActionStepPairs(executionId));
        return view;
    }

    @Override
    public ActionStepExecView findOneActionStepForModificationDuringExec(long executionId, long actionStepId) {
        ActionStepExecView actionStepExecView = this.testStepDisplayDao.findOneActionStepExecView(executionId, actionStepId);
        boolean permission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ.name(), actionStepExecView.getActionStepTestCaseId(), "org.squashtest.tm.domain.testcase.TestCase");
        if (!permission) {
            throw new AccessDeniedException("Access denied");
        }
        this.appendExecutionData(actionStepExecView, executionId);
        this.appendCoverages(actionStepExecView);
        return actionStepExecView;
    }

    @Override
    public void checkPermissionsForModificationDuringExecution(long executionId, long stepId) {
        ExecutionStep executionStep = (ExecutionStep)this.entityManager.find(ExecutionStep.class, (Object)stepId);
        this.checkReferencedTestStepExist(executionStep);
        this.checkPermissionsOnReferencedTestCases(executionStep.getExecution().getId());
    }

    @Override
    public void checkPermissionsForModificationDuringExecutionPrologue(long executionId) {
        this.checkPermissionsOnReferencedTestCases(executionId);
    }

    private void checkReferencedTestStepExist(ExecutionStep executionStep) {
        if (Objects.isNull(executionStep.getReferencedTestStep())) {
            throw new ExecutionStepHasNoModifiableStepException();
        }
    }

    private void checkPermissionsOnReferencedTestCases(Long executionId) {
        Set<Long> ids = this.executionDisplayDao.findAllTestCaseInExecution(executionId);
        boolean cantReadAtLeastOne = false;
        boolean canWriteAtLeastOne = false;
        for (Long id : ids) {
            Collection<String> permissions = this.permissionEvaluationService.permissionsOn("org.squashtest.tm.domain.testcase.TestCase", id);
            if (!permissions.contains(Permissions.READ.name())) {
                cantReadAtLeastOne = true;
            }
            if (!permissions.contains(Permissions.WRITE.name())) continue;
            canWriteAtLeastOne = true;
        }
        if (cantReadAtLeastOne) {
            throw new ModifDuringExecMissingReadPermissionException();
        }
        if (!canWriteAtLeastOne) {
            throw new ModifDuringExecMissingWritePermissionException();
        }
    }

    private void appendCoverages(ActionStepExecView actionStepExecView) {
        List<RequirementVersionCoverageDto> coverages = this.requirementVersionCoverageDisplayDao.findDirectCoverageByTestCaseId(actionStepExecView.getActionStepTestCaseId());
        actionStepExecView.setCoverages(coverages);
    }

    private void appendExecutionData(ActionStepExecView actionStepExecView, long executionId) {
        Record3 record3 = (Record3)this.dslContext.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.REFERENCE).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).using(new Field[]{Tables.EXECUTION.TCLN_ID}).innerJoin((TableLike)Tables.TEST_CASE).using(new Field[]{Tables.EXECUTION.TCLN_ID}).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOne();
        actionStepExecView.setExecutionTestCaseId((Long)record3.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        actionStepExecView.setExecutionTestCaseName((String)record3.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
        actionStepExecView.setExecutionTestCaseReference((String)record3.get((Field)Tables.TEST_CASE.REFERENCE));
    }

    private void fetchAttachmentList(ExecutionView executionView) {
        Long attachmentListId = executionView.getAttachmentListId();
        executionView.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(attachmentListId));
    }

    private void fetchExecutionSteps(ExecutionView executionView) {
        long id = executionView.getId();
        executionView.setExecutionStepViews(this.executionStepDisplayDao.findByExecutionId(id));
    }

    private void fetchCustomFieldValues(ExecutionView executionView) {
        long id = executionView.getId();
        executionView.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.EXECUTION, id));
    }

    private void fetchDenormalizedCustomFieldValues(ExecutionView executionView) {
        long id = executionView.getId();
        executionView.setDenormalizedCustomFieldValues(this.denormalizedCustomFieldValueDisplayDao.findDenormalizedCustomFieldValues(DenormalizedFieldHolderType.EXECUTION, id));
    }

    private void fetchCoverages(ExecutionView executionView) {
        Long testCaseId = executionView.getTestCaseId();
        if (Objects.nonNull(testCaseId)) {
            Set<Long> calledIds = this.testCaseCallTreeFinder.getTestCaseCallTree(testCaseId);
            List<RequirementVersionCoverageDto> requirementVersionCoverages = this.requirementVersionCoverageDisplayDao.findByTestCaseIds(testCaseId, calledIds);
            executionView.setCoverages(requirementVersionCoverages);
        }
    }

    private void fetchAutomatedJobUrl(ExecutionView executionView) {
        Execution exec = this.executionModificationService.findById(executionView.getId());
        if (exec.isAutomated() && !exec.getAutomatedExecutionExtender().isProjectDisassociated()) {
            URL automatedJobUrl = this.testAutomationProjectFinderService.findProjectURL(exec.getAutomatedExecutionExtender().getAutomatedProject());
            executionView.setAutomatedJobUrl(automatedJobUrl);
        }
    }

    private void fetchDenormalizedEnvironments(ExecutionView executionView) {
        if (this.isAutomServer(executionView)) {
            this.fetchDenormalizedVariables(executionView);
            this.fetchDenormalizedEnvironmentTags(executionView);
        }
    }

    private void fetchSessionNotes(ExecutionView executionView) {
        if (TestCaseExecutionMode.EXPLORATORY.equals((Object)TestCaseExecutionMode.valueOf((String)executionView.getExecutionMode()))) {
            List<SessionNoteDto> sessionNotes = this.sessionNoteDisplayDao.fetchSessionNotesByExecutionId(executionView.getId());
            sessionNotes.forEach(note -> {
                SessionNoteDto sessionNoteDto = note;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)sessionNoteDto);
                Object[] objectArray = new Object[]{sessionNoteDto, joinPoint};
                ExecutionDisplayServiceImpl$AjcClosure1 executionDisplayServiceImpl$AjcClosure1 = new ExecutionDisplayServiceImpl$AjcClosure1(objectArray);
                note.setContent(HTMLCleanupUtils.cleanHtml((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionDisplayServiceImpl$AjcClosure1.linkClosureAndJoinPoint(16))));
            });
            executionView.setSessionNotes(sessionNotes);
        }
    }

    private boolean isAutomServer(ExecutionView executionView) {
        return Objects.nonNull(executionView.getTestAutomationServerKind()) && TestAutomationServerKind.squashOrchestrator.name().equals(executionView.getTestAutomationServerKind());
    }

    private void fetchDenormalizedEnvironmentTags(ExecutionView executionView) {
        DenormalizedEnvironmentTagDto environmentTags = this.denormalizedEnvironmentTagDao.getAllByExecutionId(executionView.getId());
        if (Objects.nonNull(environmentTags)) {
            executionView.setDenormalizedEnvironmentTags(environmentTags);
        }
    }

    private void fetchDenormalizedVariables(ExecutionView executionView) {
        String interpretedLabel = this.getLocaleInterpretedLabel();
        List<DenormalizedEnvironmentVariableDto> denormalizedEnvironmentVariables = this.denormalizedEnvironmentVariableDao.getAllByExecutionId(executionView.getId(), interpretedLabel);
        executionView.setDenormalizedEnvironmentVariables(denormalizedEnvironmentVariables);
    }

    private String getLocaleInterpretedLabel() {
        Locale locale = LocaleContextHolder.getLocale();
        String interpreted = this.messageSource.getMessage("environmentVariable.label.interpreted", null, locale);
        return Strings.concat((String)" ", (String)interpreted);
    }

    static {
        ExecutionDisplayServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getContent_aroundBody0(SessionNoteDto sessionNoteDto, JoinPoint joinPoint) {
        return sessionNoteDto.getContent();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExecutionDisplayServiceImpl.java", ExecutionDisplayServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getContent", "org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto", "", "", "", "java.lang.String"), 422);
    }
}

