/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import com.google.common.base.Strings;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.Oauth2Tokens;

public class CredentialsDto {
    private AuthenticationProtocol implementedProtocol;
    private String username;
    private String token;
    private String tokenType;
    private AuthenticationProtocol type;
    private boolean registered;

    public static CredentialsDto from(ManageableCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        return switch (credentials.getImplementedProtocol()) {
            case AuthenticationProtocol.BASIC_AUTH -> CredentialsDto.fromBasicAuth((BasicAuthenticationCredentials)credentials);
            case AuthenticationProtocol.TOKEN_AUTH -> CredentialsDto.fromTokenAuth((TokenAuthCredentials)credentials);
            case AuthenticationProtocol.OAUTH_2 -> CredentialsDto.getOauth2CredentialsDto(credentials);
            default -> throw new IllegalArgumentException("Invalid authentication protocol " + credentials.getImplementedProtocol());
        };
    }

    private static CredentialsDto fromTokenAuth(TokenAuthCredentials credentials) {
        CredentialsDto dto = new CredentialsDto();
        dto.implementedProtocol = credentials.getImplementedProtocol();
        dto.registered = !Strings.isNullOrEmpty((String)credentials.getToken());
        dto.type = credentials.getImplementedProtocol();
        return dto;
    }

    private static CredentialsDto fromBasicAuth(BasicAuthenticationCredentials credentials) {
        CredentialsDto dto = new CredentialsDto();
        dto.implementedProtocol = credentials.getImplementedProtocol();
        dto.registered = !Strings.isNullOrEmpty((String)credentials.getUsername());
        dto.username = credentials.getUsername();
        dto.type = credentials.getImplementedProtocol();
        return dto;
    }

    private static CredentialsDto getOauth2CredentialsDto(ManageableCredentials credentials) {
        if (credentials instanceof OAuth2Credentials) {
            return CredentialsDto.fromOAuth2((OAuth2Credentials)credentials);
        }
        if (credentials instanceof Oauth2Tokens) {
            return CredentialsDto.fromUserOAuth2Token((Oauth2Tokens)credentials);
        }
        throw new IllegalArgumentException("Invalid type for OAuth2 credentials " + credentials.getClass().getName());
    }

    public static CredentialsDto fromOAuth2(OAuth2Credentials credentials) {
        CredentialsDto dto = new CredentialsDto();
        dto.implementedProtocol = credentials.getImplementedProtocol();
        dto.token = credentials.getAccessToken();
        dto.type = credentials.getImplementedProtocol();
        dto.tokenType = credentials.getTokenType();
        return dto;
    }

    public static CredentialsDto fromUserOAuth2Token(Oauth2Tokens credentials) {
        CredentialsDto dto = new CredentialsDto();
        dto.implementedProtocol = credentials.getImplementedProtocol();
        dto.registered = !Strings.isNullOrEmpty((String)credentials.getAccessToken());
        dto.token = credentials.getAccessToken();
        dto.type = credentials.getImplementedProtocol();
        dto.tokenType = credentials.getTokenType();
        return dto;
    }

    public AuthenticationProtocol getImplementedProtocol() {
        return this.implementedProtocol;
    }

    public void setImplementedProtocol(AuthenticationProtocol implementedProtocol) {
        this.implementedProtocol = implementedProtocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public AuthenticationProtocol getType() {
        return this.type;
    }

    public void setType(AuthenticationProtocol type) {
        this.type = type;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }
}

