/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.customreport;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.customreport.CustomReportDisplayService;
import org.squashtest.tm.service.internal.display.dto.LibraryDto;
import org.squashtest.tm.service.internal.display.dto.customreports.ChartDefinitionDto;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportFolderDto;
import org.squashtest.tm.service.internal.repository.display.CustomReportDisplayDao;

@Service
@Transactional(readOnly=true)
public class CustomReportDisplayServiceImpl
implements CustomReportDisplayService {
    private final CustomReportDisplayDao customReportDisplayDao;

    public CustomReportDisplayServiceImpl(CustomReportDisplayDao customReportDisplayDao) {
        this.customReportDisplayDao = customReportDisplayDao;
    }

    @Override
    public ChartDefinitionDto getChartDefinitionDto(Long customReportLibraryNodeId) {
        return this.customReportDisplayDao.findChartDefinitionByNodeId(customReportLibraryNodeId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#treeNodeId, 'org.squashtest.tm.domain.customreport.CustomReportLibraryNode' ,'READ')  or hasRole('ROLE_ADMIN')")
    public LibraryDto getCustomReportLibraryView(long treeNodeId) {
        return this.customReportDisplayDao.getCustomReportLibraryDtoByNodeId(treeNodeId);
    }

    @Override
    public CustomReportFolderDto getCustomReportFolderView(long customReportFolderId) {
        return this.customReportDisplayDao.getCustomReportFolderDtoById(customReportFolderId);
    }
}

