/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.bugtracker;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.UnknownConnectorKindException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.display.bugtracker.BugTrackerDisplayService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.internal.display.dto.BugTrackerViewDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.BugTrackerGrid;
import org.squashtest.tm.service.internal.repository.display.BugTrackerDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class BugTrackerDisplayServiceImpl
implements BugTrackerDisplayService {
    private final DSLContext dsl;
    private final BugTrackerDisplayDao bugTrackerDisplayDao;
    private final StoredCredentialsManager credentialsManager;
    private final BugTrackerFinderService bugTrackerFinderService;
    private final BugTrackerConnectorFactory connectorFactory;

    @Inject
    BugTrackerDisplayServiceImpl(DSLContext dsl, BugTrackerDisplayDao bugTrackerDisplayDao, StoredCredentialsManager credentialsManager, BugTrackerFinderService bugTrackerFinderService, BugTrackerConnectorFactory connectorFactory) {
        this.dsl = dsl;
        this.bugTrackerDisplayDao = bugTrackerDisplayDao;
        this.credentialsManager = credentialsManager;
        this.bugTrackerFinderService = bugTrackerFinderService;
        this.connectorFactory = connectorFactory;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest gridRequest) {
        return new BugTrackerGrid().getRows(gridRequest, this.dsl);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public BugTrackerViewDto getBugTrackerView(Long bugTrackerId) throws UnknownConnectorKindException {
        BugTrackerViewDto dto = this.bugTrackerDisplayDao.getBugTrackerView(bugTrackerId);
        this.appendBugTrackerKinds(dto);
        this.appendAppLevelCredentials(bugTrackerId, dto);
        this.appendAuthConfiguration(bugTrackerId, dto);
        BugTracker bugTracker = this.bugTrackerFinderService.findById(bugTrackerId);
        InternalBugtrackerConnector connector = this.connectorFactory.createConnector(bugTracker);
        this.appendSupportedAuthProtocols(connector, dto);
        this.appendReportingCacheInfo(bugTracker, dto, connector);
        return dto;
    }

    private void appendBugTrackerKinds(BugTrackerViewDto dto) {
        Set<String> bugTrackerKinds = this.bugTrackerFinderService.findBugTrackerKinds().stream().map(HTMLCleanupUtils::cleanHtml).collect(Collectors.toSet());
        dto.setBugTrackerKinds(bugTrackerKinds);
    }

    private void appendAppLevelCredentials(Long bugTrackerId, BugTrackerViewDto dto) {
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(bugTrackerId);
        dto.setCredentials(CredentialsDto.from(credentials));
    }

    private void appendAuthConfiguration(Long bugTrackerId, BugTrackerViewDto dto) {
        ServerAuthConfiguration configuration = this.credentialsManager.findServerAuthConfiguration(bugTrackerId);
        dto.setAuthConfiguration(configuration);
    }

    private void appendSupportedAuthProtocols(InternalBugtrackerConnector connector, BugTrackerViewDto dto) {
        List<String> supportedProtocols = Arrays.stream(connector.getSupportedAuthProtocols()).map(Enum::name).toList();
        dto.setSupportedAuthenticationProtocols(supportedProtocols);
    }

    private void appendReportingCacheInfo(BugTracker bugTracker, BugTrackerViewDto dto, InternalBugtrackerConnector connector) {
        boolean allowsReportingCache = connector.allowsReportingCache();
        dto.setAllowsReportingCache(connector.allowsReportingCache());
        if (!allowsReportingCache) {
            return;
        }
        ManageableCredentials manageableCredentials = this.credentialsManager.findReportingCacheCredentials(dto.getId());
        if (manageableCredentials != null) {
            CredentialsDto credentialsDto = CredentialsDto.from(manageableCredentials);
            dto.setReportingCacheCredentials(credentialsDto);
            Credentials credentials = manageableCredentials.build(this.credentialsManager, (ThirdPartyServer)bugTracker, null);
            dto.setHasCacheCredentialsError(!connector.areCredentialsValid(credentials));
            dto.setCacheInfo(connector.getCacheInfo());
        }
    }
}

