/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.denormalizedenvironment;

import java.util.List;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentTag;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.internal.repository.DenormalizedEnvironmentTagDao;

@Service(value="squashtest.tm.service.DenormalizedEnvironmentTagManagerService")
@Transactional
public class DenormalizedEnvironmentTagManagerServiceImpl
implements DenormalizedEnvironmentTagManagerService {
    private final DenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao;

    public DenormalizedEnvironmentTagManagerServiceImpl(DenormalizedEnvironmentTagDao denormalizedEnvironmentTagDao) {
        this.denormalizedEnvironmentTagDao = denormalizedEnvironmentTagDao;
    }

    @Override
    public void createAllDenormalizedEnvironmentTagsForAutomatedExecution(List<String> environmentTags, AutomatedExecutionExtender extender) {
        List<DenormalizedEnvironmentTag> denormalizedEnvironmentTags = environmentTags.stream().map(environmentTag -> new DenormalizedEnvironmentTag(extender.getId(), DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER, environmentTag)).toList();
        this.denormalizedEnvironmentTagDao.saveAll(denormalizedEnvironmentTags);
    }

    @Override
    public void removeDenormalizedTagsOnExecutionDelete(AutomatedExecutionExtender automatedExecutionExtender) {
        DenormalizedEnvironmentHolderType holderType = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER;
        List<DenormalizedEnvironmentTag> tags = this.denormalizedEnvironmentTagDao.findAllByHolderIdAndHolderType(automatedExecutionExtender.getId(), holderType);
        if (!tags.isEmpty()) {
            this.denormalizedEnvironmentTagDao.deleteAll(tags);
        }
    }
}

