/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.persistence.EntityManager;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.Table;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class JdbcBatchReorderHelper {
    private final EntityManager entityManager;
    private final DSLContext dslContext;
    private final Set<String> parentColumnNames = new HashSet<String>(Arrays.asList("ANCESTOR_ID", "LIBRARY_ID"));
    private final Set<String> childrenColumnNames = new HashSet<String>(Arrays.asList("DESCENDANT_ID", "CONTENT_ID"));
    private final Set<String> orderColumnNames = new HashSet<String>(Arrays.asList("CONTENT_ORDER"));

    public JdbcBatchReorderHelper(EntityManager entityManager, DSLContext dslContext) {
        this.entityManager = entityManager;
        this.dslContext = dslContext;
    }

    public <R extends Record3<Long, Long, Integer>> void reorder(Collection<Long> parentIds, Table<R> table) {
        this.clearPersistenceContext();
        if (!parentIds.isEmpty()) {
            this.findColumnsAndReorder(parentIds, table);
        }
    }

    public <R extends Record3<Long, Long, Integer>> void reorder(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        this.clearPersistenceContext();
        if (!parentIds.isEmpty()) {
            this.doReorder(parentIds, table, parentColumn, childrenColumn, orderColumn);
        }
    }

    private void clearPersistenceContext() {
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private <R extends Record3<Long, Long, Integer>> void findColumnsAndReorder(Collection<Long> parentIds, Table<R> table) {
        Field<Long> parentColumn = this.findCompatibleColumn(table, this.parentColumnNames, Long.class);
        Field<Long> childrenColumn = this.findCompatibleColumn(table, this.childrenColumnNames, Long.class);
        Field<Integer> orderColumn = this.findCompatibleColumn(table, this.orderColumnNames, Integer.class);
        this.doReorder(parentIds, table, parentColumn, childrenColumn, orderColumn);
    }

    private <R extends Record3<Long, Long, Integer>, T> Field<T> findCompatibleColumn(Table<R> table, Set<String> names, Class<T> clazz) {
        return Arrays.stream(table.fields()).filter(field -> names.contains(field.getName())).filter(field -> field.getDataType().getType().equals(clazz)).map(field -> field).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find required fields " + names + " in table : " + table));
    }

    private <R extends Record3<Long, Long, Integer>> void doReorder(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        Map<Long, Result<R>> groups = this.findGroups(parentIds, table, parentColumn, orderColumn);
        this.deleteAllRecords(parentIds, table, parentColumn);
        this.doBatchReorder(groups, table, parentColumn, childrenColumn, orderColumn);
    }

    private <R extends Record3<Long, Long, Integer>> void deleteAllRecords(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn) {
        this.dslContext.delete(table).where(parentColumn.in(parentIds)).execute();
    }

    private <R extends Record3<Long, Long, Integer>> Map<Long, Result<R>> findGroups(Collection<Long> parentIds, Table<R> table, Field<Long> parentColumn, Field<Integer> orderColumn) {
        return this.dslContext.selectFrom(table).where(parentColumn.in(parentIds)).orderBy(orderColumn).fetchGroups(parentColumn);
    }

    private <R extends Record3<Long, Long, Integer>> void doBatchReorder(Map<Long, Result<R>> groups, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        int numberOfItems = groups.values().stream().mapToInt(List::size).sum();
        if (numberOfItems > 0) {
            BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto(table, parentColumn, childrenColumn, orderColumn).values(null, null, null));
            groups.forEach((parentId, children) -> IntStream.range(0, children.size()).forEach(position -> {
                Record3 record = (Record3)children.get(position);
                batch.bind(new Object[]{record.getValue(parentColumn), record.getValue(childrenColumn), position});
            }));
            batch.execute();
        }
    }
}

