/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Closure;
import org.squashtest.tm.domain.library.structures.LibraryTree;
import org.squashtest.tm.domain.library.structures.TreeNode;

public class SubRequirementRewiringTree
extends LibraryTree<Long, Node> {
    private List<Movement> movements = new ArrayList<Movement>();

    public void build(List<Long[]> pairedIds) {
        HashSet<IdPair> allData = new HashSet<IdPair>();
        for (Long[] pair : pairedIds) {
            allData.add(new IdPair(pair[0], pair[1]));
        }
        ArrayList<LibraryTree.TreeNodePair> nodes = new ArrayList<LibraryTree.TreeNodePair>();
        for (IdPair p : allData) {
            Long parentId = p.getId1();
            Long childId = p.getId2();
            nodes.add(new LibraryTree.TreeNodePair((LibraryTree)this, (Object)parentId, (TreeNode)new Node(childId, false)));
        }
        this.addNodes(nodes);
    }

    public void markDeletableNodes(List<Long> nodeKeys) {
        LinkedList<Node> toUpdate = new LinkedList<Node>();
        for (Long key : nodeKeys) {
            toUpdate.add(new Node(key, true));
        }
        this.merge(toUpdate);
    }

    List<Movement> getNodeMovements() {
        return this.movements;
    }

    void resolveMovements() {
        this.doBottomUp(new MovementResolver(this));
    }

    private Movement findMovement(Node parent, boolean parentFlag) {
        Movement found = null;
        Long parentId = (Long)parent.getKey();
        for (Movement m : this.movements) {
            if (m.isTheParentOf() != parentFlag || !m.getId().equals(parentId)) continue;
            found = m;
            break;
        }
        if (found == null) {
            found = new Movement(parentFlag, parentId);
            this.movements.add(found);
        }
        return found;
    }

    private Movement findMovementToKnownParent(Node parent) {
        return this.findMovement(parent, false);
    }

    private Movement findMovementToUnknownParent(Node parent) {
        return this.findMovement(parent, true);
    }

    private static final class IdPair {
        private Long id1;
        private Long id2;

        IdPair(Long id1, Long id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public Long getId1() {
            return this.id1;
        }

        public Long getId2() {
            return this.id2;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id1 == null ? 0 : this.id1.hashCode());
            result = 31 * result + (this.id2 == null ? 0 : this.id2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdPair other = (IdPair)obj;
            if (this.id1 == null ? other.id1 != null : !this.id1.equals(other.id1)) {
                return false;
            }
            return !(this.id2 == null ? other.id2 != null : !this.id2.equals(other.id2));
        }
    }

    public static class Movement {
        private boolean theParentOf = false;
        private Long id;
        private Set<Long> newChildren = new HashSet<Long>();

        public Movement(boolean theParentOf, Long id) {
            this.theParentOf = theParentOf;
            this.id = id;
        }

        Set<Long> getNewChildren() {
            return this.newChildren;
        }

        void addChild(Long id) {
            this.newChildren.add(id);
        }

        boolean isTheParentOf() {
            return this.theParentOf;
        }

        Long getId() {
            return this.id;
        }
    }

    private static final class MovementResolver
    implements Closure {
        private SubRequirementRewiringTree tree;

        MovementResolver(SubRequirementRewiringTree tree) {
            this.tree = tree;
        }

        public void execute(Object input) {
            Node node = (Node)((Object)input);
            if (node.isDeletable().booleanValue()) {
                return;
            }
            Node parent = (Node)node.getParent();
            if (parent != null && parent.isDeletable().booleanValue()) {
                Node newParent = (Node)parent.getParent();
                while (newParent != null && newParent.isDeletable().booleanValue()) {
                    parent = newParent;
                    newParent = (Node)newParent.getParent();
                }
                Movement mouv = newParent != null ? this.tree.findMovementToKnownParent(newParent) : this.tree.findMovementToUnknownParent(parent);
                mouv.addChild((Long)node.getKey());
            }
        }
    }

    static class Node
    extends TreeNode<Long, Node> {
        private Boolean deletable = null;

        public Node() {
        }

        public Node(Long key) {
            super((Object)key);
        }

        public Node(Long key, Boolean deletable) {
            super((Object)key);
            this.deletable = deletable;
        }

        public Boolean isDeletable() {
            return this.deletable;
        }

        public void setDeletable(Boolean isDeletable) {
            this.deletable = isDeletable;
        }

        protected void updateWith(Node newData) {
            this.deletable = newData.isDeletable();
        }

        public Boolean getDeletable() {
            return this.deletable;
        }
    }
}

