/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.deletion.BoundToLockedMilestonesReport;
import org.squashtest.tm.service.deletion.BoundToMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.BoundToNotSelectedTestSuite;
import org.squashtest.tm.service.deletion.MilestoneModeNoFolderDeletion;
import org.squashtest.tm.service.deletion.NotDeletableCampaignsPreviewReport;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SingleOrMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcCampaignDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcExecutionDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandlerFactory;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.display.CampaignDisplayDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;

@Component(value="squashtest.tm.service.deletion.CampaignNodeDeletionHandler")
public class CampaignDeletionHandlerImpl
extends AbstractNodeDeletionHandler<CampaignLibraryNode, CampaignFolder>
implements CampaignNodeDeletionHandler {
    private static final String CAMPAIGNS_TYPE = "campaigns";
    private static final String EXTENDED_DELETE = "EXTENDED_DELETE";
    public static final int BIND_VARIABLES_LIMIT = 25000;
    @Inject
    private CampaignFolderDao folderDao;
    @Inject
    private CampaignDeletionDao deletionDao;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private CampaignDisplayDao campaignDisplayDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private IterationDisplayDao iterationDisplayDao;
    @Inject
    private TestSuiteDao suiteDao;
    @Inject
    private TestSuiteDisplayDao suiteDisplayDao;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private AutomatedTestDao autoTestDao;
    @Inject
    private AutomatedSuiteManagerService autoSuiteManagerService;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    @Inject
    private DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;
    @Inject
    private DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private JdbcIterationDeletionHandlerFactory jdbcIterationDeletionHandlerFactory;
    @Inject
    private JdbcCampaignDeletionHandlerFactory jdbcCampaignDeletionHandlerFactory;
    @Inject
    private JdbcExecutionDeletionHandlerFactory jdbcExecutionDeletionHandler;
    @Inject
    private SprintDisplayDao sprintDisplayDao;
    @Inject
    private DSLContext dslContext;
    @Inject
    private AutomatedExecutionExtenderDao automatedExecutionExtenderDao;
    @Inject
    private FailureDetailDao failureDetailDao;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    protected FolderDao<CampaignFolder, CampaignLibraryNode> getFolderDao() {
        return this.folderDao;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        this.checkCampaignPrivileges(nodeIds, reportList);
        this.checkSprintExtendedDeletePermission(nodeIds, reportList);
        this.reportLocksByMilestone(new HashSet<Long>(nodeIds), reportList);
        this.checkActiveMilestone(nodeIds, reportList);
        return reportList;
    }

    private void checkActiveMilestone(List<Long> nodeIds, List<SuppressionPreviewReport> reportList) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            List<Long>[] separateIds = this.deletionDao.separateFolderFromCampaignIds(nodeIds);
            this.reportNoFoldersAllowed(separateIds[0], reportList);
            this.reportMultipleMilestoneBinding(separateIds[1], reportList);
        }
    }

    private void checkSprintExtendedDeletePermission(List<Long> nodeIds, List<SuppressionPreviewReport> reportList) {
        List<NamedReference> sprintNamedReferences = this.sprintDisplayDao.findNamedReferences(nodeIds);
        this.addSprintExecutionErrorToReport(reportList, sprintNamedReferences);
    }

    private void checkCampaignPrivileges(List<Long> nodeIds, List<SuppressionPreviewReport> reportList) {
        List<NamedReference> campaigns = this.campaignDisplayDao.findNamedReferences(nodeIds);
        this.reportLocksByInsufficientPrivileges(campaigns, reportList);
    }

    protected void reportMultipleMilestoneBinding(List<Long> campaignIds, List<SuppressionPreviewReport> reportList) {
        List<Long> boundNodes = this.campaignDao.findCampaignIdsHavingMultipleMilestones(campaignIds);
        if (!boundNodes.isEmpty()) {
            if (campaignIds.size() == boundNodes.size()) {
                reportList.add(new BoundToMultipleMilestonesReport(CAMPAIGNS_TYPE));
            } else {
                reportList.add(new SingleOrMultipleMilestonesReport(CAMPAIGNS_TYPE));
            }
        }
    }

    protected void reportNoFoldersAllowed(List<Long> folderIds, List<SuppressionPreviewReport> reportList) {
        if (!folderIds.isEmpty()) {
            reportList.add(new MilestoneModeNoFolderDeletion(CAMPAIGNS_TYPE));
        }
    }

    protected void reportLocksByMilestone(Set<Long> campaignIds, List<SuppressionPreviewReport> reportList) {
        List<Long> lockedNodes = this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(new ArrayList<Long>(campaignIds));
        if (!lockedNodes.isEmpty()) {
            reportList.add(new BoundToLockedMilestonesReport(CAMPAIGNS_TYPE));
        }
    }

    protected void reportLocksByInsufficientPrivileges(List<NamedReference> campaigns, List<SuppressionPreviewReport> reportList) {
        List<Long> campaignIds = campaigns.stream().map(NamedReference::getId).toList();
        Map<Long, List<Long>> executionIdsByCampaignIds = this.campaignDisplayDao.findExecutionIdsByCampaignIds(campaignIds);
        for (NamedReference campaign : campaigns) {
            List executionIds = executionIdsByCampaignIds.getOrDefault(campaign.getId(), Collections.emptyList());
            if (executionIds.isEmpty()) continue;
            boolean canExtendedDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, campaign.getId(), "org.squashtest.tm.domain.campaign.Campaign");
            NotDeletableCampaignsPreviewReport report = new NotDeletableCampaignsPreviewReport();
            report.addName(campaign.getName());
            report.setHasRights(canExtendedDelete);
            reportList.add(report);
        }
    }

    @Override
    public List<SuppressionPreviewReport> simulateIterationDeletion(List<Long> targetIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        Set<Long> campaignIds = this.iterationDisplayDao.findCampaignIdsByIterationIds(new HashSet<Long>(targetIds));
        this.reportLocksByMilestone(campaignIds, reportList);
        List<NamedReference> iterations = this.iterationDisplayDao.findNamedReferences(targetIds);
        Map<Long, List<Long>> executionIdsByIterationId = this.iterationDisplayDao.findExecutionIdsByIterationIds(targetIds);
        for (NamedReference iteration : iterations) {
            List executionIds = executionIdsByIterationId.getOrDefault(iteration.getId(), Collections.emptyList());
            if (executionIds.isEmpty()) continue;
            boolean canExtendedDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, iteration.getId(), "org.squashtest.tm.domain.campaign.Iteration");
            NotDeletableCampaignsPreviewReport report = new NotDeletableCampaignsPreviewReport();
            report.addName(iteration.getName());
            report.setHasRights(canExtendedDelete);
            reportList.add(report);
        }
        return reportList;
    }

    @Override
    public List<SuppressionPreviewReport> simulateExecutionDeletion(Long execId) {
        return Collections.emptyList();
    }

    @Override
    public List<SuppressionPreviewReport> simulateSuiteDeletion(List<Long> testSuiteIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        HashSet<Long> testSuiteIdSet = new HashSet<Long>(testSuiteIds);
        Set<Long> campaignIds = this.suiteDisplayDao.findCampaignIdsBySuiteIds(testSuiteIdSet);
        this.reportLocksByMilestone(campaignIds, reportList);
        if (this.containTestPlanItemThatBelongToOtherTestSuite(testSuiteIdSet)) {
            reportList.add(new BoundToNotSelectedTestSuite());
        }
        List<NamedReference> suites = this.suiteDisplayDao.findNamedReferences(testSuiteIds);
        Map<Long, List<Long>> executionIdsBySuiteIds = this.suiteDisplayDao.findExecutionIdsBySuiteIds(testSuiteIds);
        for (NamedReference suite : suites) {
            List executionIds = executionIdsBySuiteIds.getOrDefault(suite.getId(), Collections.emptyList());
            if (executionIds.isEmpty()) continue;
            boolean canExtendedDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, suite.getId(), "org.squashtest.tm.domain.campaign.TestSuite");
            NotDeletableCampaignsPreviewReport report = new NotDeletableCampaignsPreviewReport();
            report.addName(suite.getName());
            report.setHasRights(canExtendedDelete);
            reportList.add(report);
        }
        return reportList;
    }

    private boolean containTestPlanItemThatBelongToOtherTestSuite(Set<Long> testSuiteIds) {
        Map<Long, Set<Long>> otherSuites = this.suiteDisplayDao.findLinkedSuites(testSuiteIds);
        for (Map.Entry<Long, Set<Long>> entry : otherSuites.entrySet()) {
            if (testSuiteIds.containsAll((Collection)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private void addSprintExecutionErrorToReport(List<SuppressionPreviewReport> reportList, List<NamedReference> sprints) {
        List<Long> sprintIds = sprints.stream().map(NamedReference::getId).toList();
        Map<Long, List<Long>> executionIdsBySprintIds = this.sprintDisplayDao.findExecutionIdsBySprintIds(sprintIds);
        for (NamedReference sprint : sprints) {
            List executionIds = executionIdsBySprintIds.getOrDefault(sprint.getId(), Collections.emptyList());
            if (executionIds.isEmpty()) continue;
            boolean canDelete = this.canExtendedDeleteSprint(sprint.getId());
            NotDeletableCampaignsPreviewReport report = new NotDeletableCampaignsPreviewReport();
            report.addName(sprint.getName());
            report.setHasRights(canDelete);
            reportList.add(report);
        }
    }

    private boolean canExtendedDeleteSprint(Long sprintId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, sprintId, "org.squashtest.tm.domain.campaign.Sprint");
    }

    @Override
    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        ArrayList<Long> lockedNodes = new ArrayList<Long>(nodeIds.size());
        this.detectLockedCampaigns(nodeIds, lockedNodes);
        this.detectLockedSprints(nodeIds, lockedNodes);
        List<Long> lockedByMilestones = this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(nodeIds);
        lockedNodes.addAll(lockedByMilestones);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            List<Long> folderIds = this.deletionDao.separateFolderFromCampaignIds(nodeIds)[0];
            List<Long> notBoundToMilestone = this.campaignDao.findNonBoundCampaign(nodeIds, activeMilestone.get().getId());
            List<Long> boundToMoreMilestones = this.campaignDao.findCampaignIdsHavingMultipleMilestones(nodeIds);
            lockedNodes.addAll(folderIds);
            lockedNodes.addAll(boundToMoreMilestones);
            lockedNodes.addAll(notBoundToMilestone);
        }
        return lockedNodes;
    }

    private void detectLockedCampaigns(List<Long> nodeIds, List<Long> lockedNodes) {
        List<NamedReference> campaigns = this.campaignDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsByCampaignIds = this.campaignDisplayDao.findExecutionIdsByCampaignIds(nodeIds);
        for (NamedReference campaign : campaigns) {
            boolean canExtendedDelete;
            List executionIds = executionIdsByCampaignIds.getOrDefault(campaign.getId(), Collections.emptyList());
            if (executionIds.isEmpty() || (canExtendedDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, campaign.getId(), "org.squashtest.tm.domain.campaign.Campaign"))) continue;
            lockedNodes.add(campaign.getId());
        }
    }

    private void detectLockedSprints(List<Long> nodeIds, List<Long> lockedNodes) {
        List<NamedReference> sprintNamedReferences = this.sprintDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsBySprintId = this.sprintDisplayDao.findExecutionIdsBySprintIds(nodeIds);
        for (NamedReference sprint : sprintNamedReferences) {
            boolean canDelete;
            List executionIds = executionIdsBySprintId.getOrDefault(sprint.getId(), Collections.emptyList());
            if (executionIds.isEmpty() || (canDelete = this.canExtendedDeleteSprint(sprint.getId()))) continue;
            lockedNodes.add(sprint.getId());
        }
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        return this.jdbcCampaignDeletionHandlerFactory.build(ids).delete();
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingCampaignIds(ids);
        List<Long> lockedIds = this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> this.deletionDao.unbindFromMilestone(remainingIds, milestone.getId()));
        report.addRemoved(remainingIds, "campaign");
        return report;
    }

    @Override
    public OperationReport deleteIterations(List<Long> targetIds) {
        List iterations = this.iterationDao.findAllByIds(targetIds);
        ArrayList<Long> iterationsToDelete = new ArrayList<Long>(targetIds.size());
        Map<Long, List<Long>> executionIdsByIterationIds = this.iterationDisplayDao.findExecutionIdsByIterationIds(targetIds);
        for (Iteration iteration : iterations) {
            if (!this.canDeleteIteration(iteration, executionIdsByIterationIds)) continue;
            iterationsToDelete.add(iteration.getId());
        }
        this.doDeleteIterations(iterationsToDelete);
        OperationReport report = new OperationReport();
        report.addRemoved(iterationsToDelete, "iteration");
        return report;
    }

    private boolean canDeleteIteration(Iteration iteration, Map<Long, List<Long>> executionIdsByIterationIds) {
        boolean hasExecutions;
        boolean hasLockedMilestone = iteration.getMilestones().stream().anyMatch(Milestone::isLocked);
        if (hasLockedMilestone) {
            return false;
        }
        boolean bl = hasExecutions = !executionIdsByIterationIds.getOrDefault(iteration.getId(), Collections.emptyList()).isEmpty();
        if (hasExecutions) {
            return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, iteration);
        }
        return true;
    }

    private void doDeleteSuites(Collection<TestSuite> testSuites) {
        List<ExternalContentCoordinates> pairContentIDListIDS = testSuites.stream().flatMap(testSuite -> {
            testSuite.getTestPlan().forEach(testPlanItem -> testPlanItem.getTestSuites().clear());
            testSuite.getIteration().removeTestSuite(testSuite);
            return this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)testSuite).stream();
        }).toList();
        List<Long> testSuiteIds = testSuites.stream().map(TestSuite::getId).toList();
        this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_SUITE, testSuiteIds);
        List attachmentListIds = this.suiteDao.findTestSuiteAttachmentListIds(testSuiteIds);
        List automatedSuitesIds = this.suiteDao.findTestSuitesAutomatedSuiteIds(testSuiteIds);
        this.autoSuiteManagerService.deleteAutomatedSuites(automatedSuitesIds);
        this.suiteDao.removeTestSuites(testSuiteIds);
        this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManager.deleteContents(pairContentIDListIDS);
    }

    @Override
    public void deleteExecution(Execution execution) {
        List<ExternalContentCoordinates> pairContentIDListIDSteps = this.deleteExecSteps(execution);
        List<ExternalContentCoordinates> pairContentIDListIDExec = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)execution);
        if (!pairContentIDListIDExec.isEmpty()) {
            pairContentIDListIDSteps.addAll(pairContentIDListIDExec);
        }
        IterationTestPlanItem iterationTestPlanItem = execution.getTestPlan();
        Long projectId = execution.getProject().getId();
        this.deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(execution, projectId);
        if (iterationTestPlanItem != null) {
            iterationTestPlanItem.removeExecution(execution);
        }
        this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)execution);
        this.customValueService.deleteAllCustomFieldValues((BoundEntity)execution);
        if (iterationTestPlanItem != null) {
            this.customTestSuiteModificationService.updateExecutionStatus(iterationTestPlanItem.getTestSuites());
        }
        this.deletionDao.removeEntity(execution);
        this.attachmentManager.deleteContents(pairContentIDListIDSteps);
    }

    private void deleteDenormalizedEnvironments(Execution execution, Long projectId) {
        if (this.isExecutedByAutomServer(projectId)) {
            this.denormalizedEnvironmentVariableManagerService.removeDenormalizedEnvironmentVariablesOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.denormalizedEnvironmentTagManagerService.removeDenormalizedTagsOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.entityManager.flush();
        }
    }

    private boolean isExecutedByAutomServer(Long projectId) {
        TestAutomationServerKind serverKind = this.executionDao.getTestAutomationServerKindByProjectId(projectId);
        return Objects.nonNull(serverKind) && TestAutomationServerKind.squashOrchestrator.equals((Object)serverKind);
    }

    @Override
    public void bulkDeleteExecutions(List<Long> executionIds) {
        List executionIdPartitions = Lists.partition(executionIds, (int)25000);
        HashSet testSuiteIds = new HashSet();
        executionIdPartitions.forEach(executionIdPartition -> {
            testSuiteIds.addAll(this.suiteDao.findAllIdsByExecutionIds((List)executionIdPartition));
            List itpiIds = this.executionDao.findItpiIdsByExecutionIds(executionIds);
            this.jdbcExecutionDeletionHandler.build(executionIds).deleteExecutions();
            this.batchUpdateItpiExecutionStatusAfterExecutionsDeletion(itpiIds);
            this.entityManager.flush();
        });
        List testSuites = this.suiteDao.findAllByIds(testSuiteIds);
        this.customTestSuiteModificationService.updateExecutionStatus(testSuites);
        this.entityManager.clear();
    }

    private void doDeleteIterations(List<Long> iterations) {
        if (!iterations.isEmpty()) {
            this.jdbcIterationDeletionHandlerFactory.build(iterations).deleteIterations();
        }
    }

    @Override
    public void deleteIterationTestPlanItem(IterationTestPlanItem item) {
        ArrayList<Execution> execs = new ArrayList<Execution>(item.getExecutions());
        ArrayList<FailureDetail> failureDetails = new ArrayList<FailureDetail>(item.getFailureDetailList());
        this.deleteFailureDetails(failureDetails);
        item.getFailureDetailList().clear();
        this.deleteExecutions(execs);
        this.deletionDao.removeEntity(item);
    }

    @Override
    public void deleteSprintReqVersionTestPlanItem(TestPlanItem item) {
        ArrayList<Execution> execs = new ArrayList<Execution>(item.getExecutions());
        this.deleteExecutions(execs);
        this.deletionDao.removeEntity(item);
    }

    @Override
    public void deleteExecutions(List<Execution> executions) {
        ArrayList<Execution> executionsCopy = new ArrayList<Execution>(executions);
        for (Execution execution : executionsCopy) {
            this.deleteExecution(execution);
        }
    }

    @Override
    public void deleteFailureDetail(FailureDetail failureDetail) {
        List extenders = failureDetail.getAutomatedExecutions();
        for (AutomatedExecutionExtender extender : extenders) {
            extender.getFailureDetailList().remove(failureDetail);
            this.automatedExecutionExtenderDao.save(extender);
        }
        failureDetail.getAutomatedExecutions().clear();
        this.failureDetailDao.save(failureDetail);
        this.deletionDao.removeEntity(failureDetail);
    }

    @Override
    public void deleteFailureDetails(List<FailureDetail> failureDetails) {
        ArrayList<FailureDetail> failureDetailsCopy = new ArrayList<FailureDetail>(failureDetails);
        for (FailureDetail failureDetail : failureDetailsCopy) {
            this.deleteFailureDetail(failureDetail);
        }
    }

    private List<ExternalContentCoordinates> deleteExecSteps(Execution execution) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>(execution.getSteps());
        execution.getSteps().clear();
        List<Object> pairContentIDListID = !steps.isEmpty() ? this.attachmentManager.getListPairContentIDListIDForExecutionSteps(steps) : new ArrayList();
        for (ExecutionStep step : steps) {
            this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)step);
            this.customValueService.deleteAllCustomFieldValues((BoundEntity)step);
            this.deletionDao.removeEntity(step);
        }
        return pairContentIDListID;
    }

    private void deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(Execution execution, Long projectId) {
        if (execution.getAutomatedExecutionExtender() == null) {
            return;
        }
        AutomatedExecutionExtender extender = execution.getAutomatedExecutionExtender();
        this.removeExtenderAssociationFromFailureDetails(extender);
        this.deleteDenormalizedEnvironments(execution, projectId);
        this.autoTestDao.removeIfUnused(extender.getAutomatedTest());
        this.deletionDao.removeEntity(extender);
        execution.setAutomatedExecutionExtender(null);
    }

    private void removeExtenderAssociationFromFailureDetails(AutomatedExecutionExtender extender) {
        List failureDetails = extender.getFailureDetailList();
        for (FailureDetail failureDetail : failureDetails) {
            failureDetail.getAutomatedExecutions().remove(extender);
            this.failureDetailDao.save(failureDetail);
        }
    }

    @Override
    public OperationReport deleteSuites(List<Long> suiteIds, boolean removeFromIter) {
        List<TestSuite> suitesToDelete = this.suiteDao.findTestSuitesWhereMilestoneIsNotLocked(suiteIds);
        Map<Long, List<Long>> executionIdsBySuiteIds = this.suiteDisplayDao.findExecutionIdsBySuiteIds(suiteIds);
        suitesToDelete = this.filterSuitesToDelete(suitesToDelete, executionIdsBySuiteIds);
        if (removeFromIter) {
            this.removeItpiFromIteration(suitesToDelete, suiteIds);
        }
        this.doDeleteSuites(suitesToDelete);
        OperationReport report = new OperationReport();
        if (!suitesToDelete.isEmpty()) {
            report.addRemoved(suiteIds, "test-suite");
        }
        return report;
    }

    private List<TestSuite> filterSuitesToDelete(List<TestSuite> suitesToDelete, Map<Long, List<Long>> executionIdsBySuiteIds) {
        return suitesToDelete.stream().filter(suite -> {
            List executions = (List)executionIdsBySuiteIds.get(suite.getId());
            boolean hasExecutions = Optional.ofNullable(executions).filter(list -> !list.isEmpty()).map(list -> (Long)list.get(0)).isPresent();
            boolean canDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, suite);
            return !hasExecutions || canDelete;
        }).toList();
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    private void removeItpiFromIteration(List<TestSuite> suites, List<Long> targetIds) {
        List listItpiToRemove = this.iterationTestPlanDao.findIterationTestPlanItemsToRemoveInDeleteTestSuite(suites, targetIds);
        if (listItpiToRemove != null) {
            HashSet itpiToRemove = new HashSet(listItpiToRemove);
            for (IterationTestPlanItem testPlanItem : itpiToRemove) {
                this.iterationTestPlanManagerService.removeTestPlanFromIteration(testPlanItem);
            }
        }
    }

    private void batchUpdateItpiExecutionStatusAfterExecutionsDeletion(List<Long> iterationTestPlanItemIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("ITEM_TEST_PLAN_ID", "EXECUTION_STATUS", "POSITION").as((ResultQuery)DSL.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS, (SelectField)DSL.rowNumber().over().partitionBy(new Field[]{Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID}).orderBy(new OrderField[]{Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.desc()})).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).innerJoin((TableLike)Tables.EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemIds)));
        Map itemTestPlanIdsByExecutionStatus = this.dslContext.with(new CommonTableExpression[]{cte}).select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, (SelectField)DSL.when((Condition)cte.field("EXECUTION_STATUS").isNull(), (Object)ExecutionStatus.READY.name()).otherwise(cte.field("EXECUTION_STATUS", String.class)).as("EXECUTION_STATUS")).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)cte).on(cte.field("ITEM_TEST_PLAN_ID", Long.class).eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemIds).and(cte.field("POSITION", Integer.class).eq((Object)1).or(cte.field("ITEM_TEST_PLAN_ID", Integer.class).isNull().and(Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS.notEqual((Object)ExecutionStatus.READY.name()))))).fetchGroups(DSL.field((String)"EXECUTION_STATUS", String.class), (Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID);
        for (Map.Entry entry : itemTestPlanIdsByExecutionStatus.entrySet()) {
            this.dslContext.update((Table)Tables.ITERATION_TEST_PLAN_ITEM).set((Field)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS, (Object)((String)entry.getKey())).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in((Collection)entry.getValue())).execute();
        }
    }
}

