/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.CreateExecutionFromTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestSuiteTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.SprintExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.scripted.ScriptedTestCaseExecutionHelper;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestPlanExploratorySessionOverviewDisplayDao;
import org.squashtest.tm.service.testcase.TestCaseCyclicCallChecker;

@Service
@Transactional
public class SprintExecutionCreationServiceImpl
implements SprintExecutionCreationService {
    private final MessageSource messageSource;
    private final AttachmentManagerService attachmentManagerService;
    private final TestCaseCyclicCallChecker testCaseCyclicCallChecker;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final ScriptedTestCaseExecutionHelper scriptedTestCaseExecutionHelper;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final TestPlanItemDao testPlanItemDao;
    private final ProjectDisplayDao projectDisplayDao;
    private final TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao;
    private final SprintDisplayDao sprintDisplayDao;

    public SprintExecutionCreationServiceImpl(MessageSource messageSource, AttachmentManagerService attachmentManagerService, TestCaseCyclicCallChecker testCaseCyclicCallChecker, PrivateCustomFieldValueService customFieldValueService, ScriptedTestCaseExecutionHelper scriptedTestCaseExecutionHelper, PrivateDenormalizedFieldValueService denormalizedFieldValueService, TestPlanItemDao testPlanItemDao, ProjectDisplayDao projectDisplayDao, TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao, SprintDisplayDao sprintDisplayDao) {
        this.messageSource = messageSource;
        this.attachmentManagerService = attachmentManagerService;
        this.testCaseCyclicCallChecker = testCaseCyclicCallChecker;
        this.customFieldValueService = customFieldValueService;
        this.scriptedTestCaseExecutionHelper = scriptedTestCaseExecutionHelper;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.testPlanItemDao = testPlanItemDao;
        this.projectDisplayDao = projectDisplayDao;
        this.testPlanExploratorySessionOverviewDisplayDao = testPlanExploratorySessionOverviewDisplayDao;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public Execution createExecution(long testPlanItemId) {
        this.checkParentSprintStatus(testPlanItemId);
        TestPlanItem item = this.testPlanItemDao.findByIdWithReferencedTestCaseAndDataset(testPlanItemId);
        if (item.isTestCaseDeleted()) {
            throw new TestSuiteTestPlanHasDeletedTestCaseException();
        }
        Locale locale = this.projectDisplayDao.findBddScriptLanguageByProjectId(item.getProject().getId()).getLocale();
        Execution execution = this.createAndAddExecution(item, this.messageSource, locale);
        boolean isExploratory = TestCaseExecutionMode.EXPLORATORY.equals((Object)execution.getExecutionMode());
        if (!isExploratory && execution.getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        return execution;
    }

    private void checkParentSprintStatus(long testPlanItemId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByTestPlanItemId(testPlanItemId);
        if (sprintStatus == SprintStatus.CLOSED) {
            throw new SprintClosedException();
        }
    }

    private Execution createAndAddExecution(TestPlanItem item, MessageSource messageSource, Locale locale) throws TestPlanItemNotExecutableException {
        Execution execution = this.createExec(item, messageSource, locale);
        item.addExecution(execution);
        this.operationsAfterAddingExec(execution);
        return execution;
    }

    private Execution createExec(TestPlanItem item, MessageSource messageSource, Locale locale) {
        TestCase testCase = item.getReferencedTestCase();
        this.testCaseCyclicCallChecker.checkNoCyclicCall(testCase);
        return this.createExecution(item, messageSource, locale);
    }

    private Execution createExecution(TestPlanItem item, MessageSource messageSource, Locale locale) {
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(item.getReferencedDataset(), messageSource, locale);
        item.getReferencedTestCase().accept((TestCaseVisitor)createExecutionVisitor);
        Execution createdExecution = createExecutionVisitor.getCreatedExecution();
        createdExecution.setSprintTestPlanItem(item);
        this.copyAttachments(createdExecution);
        return createdExecution;
    }

    private void copyAttachments(Execution execution) {
        this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)execution);
        for (ExecutionStep executionStep : execution.getSteps()) {
            this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)executionStep);
        }
    }

    private void operationsAfterAddingExec(Execution execution) {
        execution.accept((ExecutionVisitor)new ExecutionPostCreationVisitor());
    }

    private final class ExecutionPostCreationVisitor
    implements ExecutionVisitor {
        private ExecutionPostCreationVisitor() {
        }

        public void visit(Execution execution) {
            this.createCustomFieldsForExecutionAndExecutionSteps(execution);
            this.createDenormalizedFieldsForExecutionAndExecutionSteps(execution);
            this.createExecutionAttachments(execution);
        }

        public void visit(ScriptedExecution scriptedExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)scriptedExecution);
            this.createExecutionStepsForScriptedTestCase(scriptedExecution);
        }

        public void visit(KeywordExecution keywordExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)keywordExecution);
        }

        public void visit(ExploratoryExecution exploratoryExecution) {
            this.createCustomAndDenormalizedFieldsForExecution((Execution)exploratoryExecution);
            TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef = SprintExecutionCreationServiceImpl.this.testPlanExploratorySessionOverviewDisplayDao.findNameAndReferenceByExecutionId(exploratoryExecution.getId());
            this.updateExploratoryExecutionInfoFromSessionOverview((Execution)exploratoryExecution, overviewNameAndRef);
        }

        private void updateExploratoryExecutionInfoFromSessionOverview(Execution execution, TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef) {
            execution.setName(this.buildExecutionName(overviewNameAndRef));
            execution.setReference(overviewNameAndRef.reference());
        }

        private String buildExecutionName(TestPlanExploratorySessionOverviewDisplayDao.NameAndReference overviewNameAndRef) {
            if (overviewNameAndRef.reference().isEmpty()) {
                return overviewNameAndRef.name();
            }
            return String.valueOf(overviewNameAndRef.reference()) + " - " + overviewNameAndRef.name();
        }

        private void createExecutionStepsForScriptedTestCase(ScriptedExecution scriptedExecution) {
            scriptedExecution.getReferencedTestCase().accept((TestCaseVisitor)new ConsumerForScriptedTestCaseVisitor(scriptedTestCase -> SprintExecutionCreationServiceImpl.this.scriptedTestCaseExecutionHelper.createExecutionStepsForScriptedTestCase(scriptedExecution)));
        }

        private void createCustomFieldsForExecutionAndExecutionSteps(Execution execution) {
            SprintExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
            SprintExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues(execution.getSteps(), execution.getProject());
        }

        private void createCustomAndDenormalizedFieldsForExecution(Execution execution) {
            SprintExecutionCreationServiceImpl.this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
            this.createDenormalizedFieldsForExecution(execution);
        }

        private void createDenormalizedFieldsForExecutionAndExecutionSteps(Execution execution) {
            this.createDenormalizedFieldsForExecution(execution);
            SprintExecutionCreationServiceImpl.this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(execution);
        }

        private void createDenormalizedFieldsForExecution(Execution execution) {
            TestCase referencedTestCase = execution.getReferencedTestCase();
            SprintExecutionCreationServiceImpl.this.denormalizedFieldValueService.createAllDenormalizedFieldValues((BoundEntity)referencedTestCase, (DenormalizedFieldHolder)execution);
        }

        private void createExecutionAttachments(Execution execution) {
            String newDescription;
            Long attachmentListId = execution.getAttachmentList().getId();
            EntityReference entityReference = execution.toEntityReference();
            String description = execution.getDescription();
            this.createAttachmentsFromCuf((BoundEntity)execution, attachmentListId, entityReference);
            if (description != null && !description.isEmpty() && !(newDescription = SprintExecutionCreationServiceImpl.this.attachmentManagerService.addAttachmentsFromRichText(description, attachmentListId, entityReference)).equals(description)) {
                execution.setDescription(newDescription);
            }
        }

        private void createAttachmentsFromCuf(BoundEntity iteration, Long attachmentListId, EntityReference entityReference) {
            List<CustomFieldValue> persistentValues = SprintExecutionCreationServiceImpl.this.customFieldValueService.findAllCustomFieldValues(iteration);
            persistentValues.forEach(customFieldValue -> {
                String html;
                String value;
                if (customFieldValue instanceof RichTextValue && !(value = customFieldValue.getValue()).equals(html = SprintExecutionCreationServiceImpl.this.attachmentManagerService.addAttachmentsFromRichText(value, attachmentListId, entityReference))) {
                    customFieldValue.setValue(html);
                }
            });
        }
    }
}

