/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.IdentifiersOrderComparator;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignTestPlanManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignTestPlanItemDao;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeWalker;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.tm.service.CampaignTestPlanManagerService")
@Transactional
public class CampaignTestPlanManagerServiceImpl
implements CampaignTestPlanManagerService {
    private static final String CAN_READ_RETURNED_OBJECT = "hasPermission(returnObject, 'READ') or hasRole('ROLE_ADMIN')";
    private static final String CAN_LINK_CAMPAIGN_BY_ID = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')";
    @Inject
    private CampaignDao campaignDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private CampaignTestPlanItemDao campaignTestPlanItemDao;
    @Inject
    private UserDao userDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy")
    private ObjectIdentityRetrievalStrategy objIdRetrievalStrategy;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Campaign.class)
    @CheckBlockingMilestone(entityType=Campaign.class)
    public Map<String, Object> addTestCasesToCampaignTestPlan(List<Long> testCasesIds, @Id long campaignId) {
        return this.addTestCasesToCampaignTestPlanUnsecured(testCasesIds, campaignId);
    }

    @Override
    public Map<String, Object> addTestCasesToCampaignTestPlanUnsecured(List<Long> testCasesIds, @Id long campaignId) {
        boolean hasDataset = false;
        List<TestCaseLibraryNode> nodes = this.testCaseLibraryNodeDao.findAllByIds(testCasesIds);
        IdentifiersOrderComparator comparator = new IdentifiersOrderComparator(testCasesIds);
        nodes.sort((Comparator<TestCaseLibraryNode>)comparator);
        List<TestCase> testCases = new TestCaseNodeWalker().walk(nodes);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> CollectionUtils.filter((Collection)testCases, (Predicate)new Predicate((Milestone)milestone){
            private final /* synthetic */ Milestone val$milestone;
            {
                this.val$milestone = milestone;
            }

            public boolean evaluate(Object tc) {
                return ((TestCase)tc).getAllMilestones().contains(this.val$milestone);
            }
        }));
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        long totalNewTestPlanItemsNumber = 0L;
        for (TestCase testCase : testCases) {
            Set datasets = testCase.getDatasets();
            if (datasets.isEmpty()) {
                CampaignTestPlanItem itp = new CampaignTestPlanItem(testCase);
                campaign.addToTestPlan(itp);
                this.campaignTestPlanItemDao.persist(itp);
                ++totalNewTestPlanItemsNumber;
                continue;
            }
            hasDataset = true;
            for (Dataset ds : datasets) {
                CampaignTestPlanItem itp = new CampaignTestPlanItem(testCase, ds);
                campaign.addToTestPlan(itp);
                this.campaignTestPlanItemDao.persist(itp);
                ++totalNewTestPlanItemsNumber;
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("hasDataSet", hasDataset);
        response.put("totalNewTestPlanItemsNumber", totalNewTestPlanItemsNumber);
        return response;
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findAssignableUserForTestPlan(long campaignId) {
        List<String> loginList;
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        ArrayList<ObjectIdentity> entityRefs = new ArrayList<ObjectIdentity>();
        ObjectIdentity oid = this.objIdRetrievalStrategy.getObjectIdentity((Object)campaign);
        entityRefs.add(oid);
        List<String> list = loginList = this.aclService.findUsersWithExecutePermission(entityRefs);
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        CampaignTestPlanManagerServiceImpl$AjcClosure1 campaignTestPlanManagerServiceImpl$AjcClosure1 = new CampaignTestPlanManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(campaignTestPlanManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void assignUserToTestPlanItems(@NotNull List<Long> itemsIds, @Id long campaignId, long userId) {
        List<Long> list = itemsIds;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        User assignee = null;
        if (userId != 0L) {
            assignee = (User)this.userDao.getReferenceById(userId);
        }
        List items = this.campaignTestPlanItemDao.findAllByIds(itemsIds);
        for (CampaignTestPlanItem item : items) {
            item.setUser(assignee);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Campaign.class)
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void moveTestPlanItems(@Id long campaignId, int targetIndex, List<Long> itemIds) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        campaign.moveTestPlanItems(targetIndex, itemIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Campaign.class)
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void removeTestPlanItem(@Id long campaignId, long itemId) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        campaign.removeTestPlanItem(itemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Campaign.class)
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void removeTestPlanItems(@Id long campaignId, List<Long> itemIds) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        campaign.removeTestPlanItems(itemIds);
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject, 'READ') or hasRole('ROLE_ADMIN')")
    public CampaignTestPlanItem findById(long itemId) {
        return (CampaignTestPlanItem)this.campaignTestPlanItemDao.findById(itemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#itemId, 'org.squashtest.tm.domain.campaign.CampaignTestPlanItem', 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=CampaignTestPlanItem.class)
    public void changeDataset(@Id long itemId, Long datasetId) {
        CampaignTestPlanItem item = (CampaignTestPlanItem)this.campaignTestPlanItemDao.findById(itemId);
        if (datasetId == null) {
            item.setReferencedDataset(null);
        } else {
            TestCase tc = item.getReferencedTestCase();
            Dataset ds = (Dataset)this.datasetDao.getReferenceById(datasetId);
            if (!ds.getTestCase().equals((Object)tc)) {
                throw new IllegalArgumentException("dataset [id:'" + ds.getId() + "', name:'" + ds.getName() + "'] doesn't belong to test case [id:'" + tc.getId() + "', name:'" + tc.getName() + "']");
            }
            item.setReferencedDataset(ds);
        }
    }

    @Override
    public void removeTestPlanItemsAssignments(List<Long> itemIds) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, itemIds, "WRITE", CampaignTestPlanItem.class.getName());
        List items = this.campaignTestPlanItemDao.findAllByIds(itemIds);
        for (CampaignTestPlanItem item : items) {
            if (item.isTestCaseDeleted()) continue;
            item.setUser(null);
        }
    }

    @Override
    public void assignUserToTestPlanItems(List<Long> itemIds, Long userId) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, itemIds, "WRITE", CampaignTestPlanItem.class.getName());
        List items = this.campaignTestPlanItemDao.findAllByIds(itemIds);
        User user = userId == 0L ? null : (User)this.userDao.getReferenceById(userId);
        for (CampaignTestPlanItem item : items) {
            if (item.isTestCaseDeleted()) continue;
            item.setUser(user);
        }
    }

    static {
        CampaignTestPlanManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody0(CampaignTestPlanManagerServiceImpl campaignTestPlanManagerServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CampaignTestPlanManagerServiceImpl.java", CampaignTestPlanManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 179);
    }
}

