/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.batchimport.excel.WorksheetFormatStatus;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorksheetDef;

public class WorkbookMetaData {
    private Map<TemplateWorksheet, WorksheetDef<? extends TemplateColumn>> worksheetDefByType = new HashMap<TemplateWorksheet, WorksheetDef<? extends TemplateColumn>>();

    void addWorksheetDef(WorksheetDef<? extends TemplateColumn> worksheetDef) {
        this.worksheetDefByType.put(worksheetDef.getWorksheetType(), worksheetDef);
    }

    public void validate() throws TemplateMismatchException {
        ArrayList<WorksheetFormatStatus> worksheetKOStatuses = new ArrayList<WorksheetFormatStatus>();
        for (WorksheetDef<? extends TemplateColumn> wd : this.worksheetDefByType.values()) {
            WorksheetFormatStatus worksheetStatus = wd.validate();
            if (worksheetStatus.isFormatOk()) continue;
            worksheetKOStatuses.add(worksheetStatus);
        }
        if (!worksheetKOStatuses.isEmpty()) {
            throw new TemplateMismatchException(worksheetKOStatuses);
        }
    }

    public <COL extends TemplateColumn> WorksheetDef<COL> getWorksheetDef(TemplateWorksheet ws) {
        return this.worksheetDefByType.get((Object)ws);
    }

    public Collection<WorksheetDef<? extends TemplateColumn>> getWorksheetDefs() {
        return this.worksheetDefByType.values();
    }
}

