/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.map.MultiValueMap;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinksSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetParamValuesSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumnUtils;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateCustomFieldPattern;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;

public enum TemplateWorksheet {
    REQUIREMENT_SHEET("REQUIREMENT", RequirementSheetColumn.class, TemplateCustomFieldPattern.REQUIREMENT_VERSION_CUSTOM_FIELD),
    TEST_CASES_SHEET("TEST_CASES", TestCaseSheetColumn.class, TemplateCustomFieldPattern.TEST_CASE_CUSTOM_FIELD),
    STEPS_SHEET("STEPS", StepSheetColumn.class, TemplateCustomFieldPattern.STEP_CUSTOM_FIELD),
    PARAMETERS_SHEET("PARAMETERS", ParameterSheetColumn.class),
    DATASETS_SHEET("DATASETS", DatasetSheetColumn.class),
    DATASET_PARAM_VALUES_SHEET("DATASETS", DatasetParamValuesSheetColumn.class),
    COVERAGE_SHEET("LINK_REQ_TC", CoverageSheetColumn.class),
    REQUIREMENT_LINKS_SHEET("LINK_REQ_REQ", RequirementLinksSheetColumn.class),
    LINKED_LOW_LEVEL_REQS_SHEET("LINK_HIGH_LEVEL_STANDARD_REQ", LinkedLowLevelRequirementsSheetColumn.class);

    private static final MultiValueMap ENUM_BY_SHEET_NAME;
    public final String sheetName;
    public final Class<? extends Enum<?>> columnTypesClass;
    public final TemplateCustomFieldPattern customFieldPattern;

    static {
        ENUM_BY_SHEET_NAME = new MultiValueMap();
    }

    private <E extends Enum<?>> TemplateWorksheet(String name, Class<E> columnEnumType) {
        this.sheetName = name;
        this.columnTypesClass = columnEnumType;
        this.customFieldPattern = TemplateCustomFieldPattern.NO_CUSTOM_FIELD;
    }

    private <E extends Enum<?>> TemplateWorksheet(String name, Class<E> columnEnumType, TemplateCustomFieldPattern customFieldPattern) {
        this.sheetName = name;
        this.columnTypesClass = columnEnumType;
        this.customFieldPattern = customFieldPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TemplateWorksheet> coerceFromSheetName(String name) {
        List<TemplateWorksheet> templates;
        if (ENUM_BY_SHEET_NAME.isEmpty()) {
            MultiValueMap multiValueMap = ENUM_BY_SHEET_NAME;
            synchronized (multiValueMap) {
                TemplateWorksheet[] templateWorksheetArray = TemplateWorksheet.values();
                int n = templateWorksheetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateWorksheet e = templateWorksheetArray[n2];
                    ENUM_BY_SHEET_NAME.put((Object)e.sheetName, (Object)e);
                    ++n2;
                }
            }
        }
        if ((templates = ENUM_BY_SHEET_NAME.getCollection((Object)name)) == null) {
            templates = Collections.emptyList();
        }
        return templates;
    }

    public <E extends TemplateColumn> E[] getColumnTypes() {
        return (TemplateColumn[])TemplateColumnUtils.values(this.columnTypesClass);
    }
}

