/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instructioncontainer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.service.internal.batchimport.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.StepInstruction;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.InstructionContainer;

public class StepInstructionContainer
extends InstructionContainer<StepInstruction> {
    public StepInstructionContainer(List<StepInstruction> instructions) {
        super(instructions);
    }

    List<ActionStepInstruction> filterActionStepInstruction(List<StepInstruction> instructions) {
        return instructions.stream().filter(ActionStepInstruction.class::isInstance).map(i -> (ActionStepInstruction)i).toList();
    }

    List<CallStepInstruction> filterCallStepInstruction(List<StepInstruction> instructions) {
        return instructions.stream().filter(CallStepInstruction.class::isInstance).map(i -> (CallStepInstruction)i).toList();
    }

    @Override
    protected Map<StepInstruction, LogTrain> executeCreate(Facility facility) {
        List<CallStepInstruction> callStepInstructions;
        HashMap<StepInstruction, LogTrain> result = new HashMap<StepInstruction, LogTrain>();
        List<StepInstruction> createInstructions = this.getCreateInstructions();
        List<ActionStepInstruction> actionStepInstructions = this.filterActionStepInstruction(createInstructions);
        if (!actionStepInstructions.isEmpty()) {
            result.putAll(facility.addActionSteps(actionStepInstructions));
        }
        if (!(callStepInstructions = this.filterCallStepInstruction(createInstructions)).isEmpty()) {
            result.putAll(facility.addCallSteps(callStepInstructions));
        }
        return result;
    }
}

