/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.internal.batchimport.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityUtils;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageInstruction;

@Component
@Scope(value="prototype")
public class SimulationFacility
implements Facility {
    @Inject
    private ValidationFacility validator;

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogTrain logs = this.validator.deleteTestCase(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().setToBeDeleted(target);
        }
        return logs;
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        return this.validator.updateActionStep(target, testStep, cufValues);
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo, ActionTestStep actionStepBackup) {
        LogTrain logs = this.validator.updateCallStep(target, testStep, calledTestCase, paramInfo, actionStepBackup);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().updateCallStepTarget(target, calledTestCase, paramInfo);
        }
        return logs;
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        LogTrain logs = this.validator.deleteTestStep(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().remove(target);
        }
        return logs;
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogTrain logs = this.validator.updateParameter(target, param);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().addParameter(target);
        }
        return logs;
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        LogTrain logs = this.validator.deleteParameter(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().removeParameter(target);
        }
        return logs;
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain logs = this.validator.failsafeUpdateParameterValue(dataset, param, value, isUpdate);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().addDataset(dataset);
        }
        return logs;
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogTrain logs = this.validator.deleteDataset(dataset);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().removeDataset(dataset);
        }
        return logs;
    }

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        return this.validator.updateTestCase(instr);
    }

    @Override
    public LogTrain createRequirementVersion(RequirementVersionInstruction instr) {
        return this.validator.createRequirementVersion(instr);
    }

    @Override
    public LogTrain updateRequirementVersion(RequirementVersionInstruction instr) {
        return this.validator.updateRequirementVersion(instr);
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("implement me - must return a Failure : Not implemented in the log train instead of throwing this exception");
    }

    @Override
    public LogTrain createCoverage(CoverageInstruction instr) {
        return this.validator.createCoverage(instr);
    }

    @Override
    public LogTrain createLinkedLowLevelRequirement(LinkedLowLevelRequirementInstruction instr) {
        return this.validator.createLinkedLowLevelRequirement(instr);
    }

    @Override
    public LogTrain createRequirementLink(RequirementLinkInstruction instr) {
        return this.validator.createRequirementLink(instr);
    }

    @Override
    public LogTrain updateRequirementLink(RequirementLinkInstruction instr) {
        return this.validator.updateRequirementLink(instr);
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.validator.deleteRequirementLink(instr);
    }

    @Override
    public Map<TestCaseInstruction, LogTrain> createTestCases(List<TestCaseInstruction> createInstructions) {
        Map<String, List<TestCaseInstruction>> instructionsByProjectName = createInstructions.stream().collect(Collectors.groupingBy(instruction -> ((TestCaseTarget)instruction.getTarget()).getProject()));
        Map<TestCaseInstruction, LogTrain> result = instructionsByProjectName.values().stream().map(testCaseInstructions -> this.validator.createTestCases((List<TestCaseInstruction>)testCaseInstructions)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<TestCaseInstruction, LogTrain> entry : result.entrySet()) {
            LogTrain logs = entry.getValue();
            TestCaseTarget target = (TestCaseTarget)entry.getKey().getTarget();
            if (!logs.hasCriticalErrors()) {
                this.validator.getModel().setToBeCreated(target);
                continue;
            }
            this.validator.getModel().setNotExists(target);
        }
        return result;
    }

    @Override
    public Map<ParameterInstruction, LogTrain> createParameters(List<ParameterInstruction> createParameters) {
        Map<ParameterInstruction, LogTrain> logByInstruction = this.validator.createParameters(createParameters);
        logByInstruction.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).map(entry -> (ParameterTarget)((ParameterInstruction)entry.getKey()).getTarget()).forEach(target -> this.validator.getModel().addParameter((ParameterTarget)target));
        return logByInstruction;
    }

    @Override
    public Map<DatasetInstruction, LogTrain> createDatasets(List<DatasetInstruction> instructions) {
        Map<DatasetInstruction, LogTrain> logByInstruction = this.validator.createDatasets(instructions);
        logByInstruction.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).map(entry -> (DatasetTarget)((DatasetInstruction)entry.getKey()).getTarget()).forEach(target -> this.validator.getModel().addDataset((DatasetTarget)target));
        return logByInstruction;
    }

    @Override
    public Map<ActionStepInstruction, LogTrain> addActionSteps(List<ActionStepInstruction> instructions) {
        Map<ActionStepInstruction, LogTrain> logByInstruction = this.validator.addActionSteps(instructions);
        logByInstruction.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).map(entry -> (TestStepTarget)((ActionStepInstruction)entry.getKey()).getTarget()).forEach(target -> {
            Integer n = this.validator.getModel().addActionStep((TestStepTarget)target);
        });
        return logByInstruction;
    }

    @Override
    public Map<CallStepInstruction, LogTrain> addCallSteps(List<CallStepInstruction> instructions) {
        Map<CallStepInstruction, LogTrain> logByInstruction = this.validator.addCallSteps(instructions);
        logByInstruction.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).forEach(entry -> {
            CallStepInstruction instruction = (CallStepInstruction)entry.getKey();
            LogTrain logs = (LogTrain)entry.getValue();
            if (FacilityUtils.mustImportCallAsActionStep(logs) == null) {
                this.validator.getModel().addCallStep((TestStepTarget)instruction.getTarget(), instruction.getCalledTC(), instruction.getDatasetInfo().getParamMode());
            } else {
                this.validator.getModel().addActionStep((TestStepTarget)instruction.getTarget());
            }
        });
        return logByInstruction;
    }

    @Override
    public Map<DatasetParamValueInstruction, LogTrain> addDatasetParametersValues(List<DatasetParamValueInstruction> instructions) {
        Map<DatasetParamValueInstruction, LogTrain> logByInstruction = this.validator.addDatasetParametersValues(instructions);
        logByInstruction.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).map(entry -> (DatasetTarget)((DatasetParamValueInstruction)entry.getKey()).getTarget()).forEach(target -> this.validator.getModel().addDataset((DatasetTarget)target));
        return logByInstruction;
    }
}

