/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;

public abstract class Instruction<T extends Target> {
    private final T target;
    protected final LogTrain logTrain;
    private int line;
    private ImportMode mode = ImportMode.getDefault();

    protected Instruction(T target) {
        this.logTrain = new LogTrain();
        this.target = target;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public void setMode(ImportMode mode) {
        if (mode != null) {
            this.mode = mode;
        }
    }

    public void addLogEntry(ImportStatus status, String messageKey, String impactKey, Object ... messageArgs) {
        LogEntry entry = LogEntry.status(status).forTarget((Target)this.target).atLine(this.line).withMessage(messageKey, messageArgs).withImpact(impactKey, new Object[0]).build();
        this.logTrain.addEntry(entry);
    }

    public T getTarget() {
        return this.target;
    }

    public final LogTrain execute(Facility facility) {
        if (this.logTrain.hasCriticalErrors()) {
            return this.logTrain;
        }
        this.logTrain.append(switch (this.mode) {
            case ImportMode.CREATE -> this.executeCreate(facility);
            case ImportMode.DELETE -> this.executeDelete(facility);
            case ImportMode.UPDATE -> this.executeUpdate(facility);
            default -> throw new IllegalStateException("Unrecognized ImportMode " + (Object)((Object)this.mode) + ". One must have forgotten to handle new modes");
        });
        return this.logTrain;
    }

    public LogTrain getLogTrain() {
        return this.logTrain;
    }

    protected abstract LogTrain executeUpdate(Facility var1);

    protected abstract LogTrain executeDelete(Facility var1);

    protected abstract LogTrain executeCreate(Facility var1);
}

