/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.library.structures.GraphNode;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.ModelSubservicesProvider;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionModel;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;

class ImportedRequirementTree
extends LibraryGraph<RequirementTarget, Node> {
    private final ModelSubservicesProvider subservicesProvider;

    public ImportedRequirementTree(ModelSubservicesProvider subservicesProvider) {
        this.subservicesProvider = subservicesProvider;
    }

    RequirementLibraryFinderService getRequirementLibraryFinderService() {
        return this.subservicesProvider.getRequirementLibraryFinderService();
    }

    public void addOrUpdateNode(RequirementTarget requirement, TargetStatus status) {
        Node existingRequirement = (Node)this.getNode(requirement);
        if (existingRequirement == null) {
            this.addNode(requirement, status);
        } else {
            this.updateNode(requirement, status);
        }
    }

    public void addOrUpdateNode(RequirementVersionTarget version, TargetStatus status) {
        Node requirement = (Node)this.getNode(version.getRequirement());
        if (requirement == null) {
            this.addOrUpdateNode(version.getRequirement(), new TargetStatus(Existence.TO_BE_CREATED));
            requirement = (Node)this.getNode(version.getRequirement());
        }
        requirement.addVersion(version.getVersion(), status);
    }

    public boolean targetExists(RequirementTarget target) {
        Node req = (Node)this.getNode(target);
        return req != null && req.getStatus().getStatus() != Existence.NOT_EXISTS;
    }

    public boolean targetAlreadyLoaded(RequirementTarget target) {
        Node req = (Node)this.getNode(target);
        return req != null;
    }

    public boolean targetAlreadyLoaded(RequirementVersionTarget target) {
        Node req = (Node)this.getNode(target.getRequirement());
        if (req == null) {
            return false;
        }
        return req.versionAlreadyLoaded(target.getVersion());
    }

    public TargetStatus getStatus(RequirementTarget target) {
        Node requirement = (Node)this.getNode(target);
        if (requirement != null) {
            return requirement.getStatus();
        }
        return TargetStatus.NOT_EXISTS;
    }

    public TargetStatus getStatus(RequirementVersionTarget target) {
        Node requirement = (Node)this.getNode(target.getRequirement());
        return requirement.getVersionStatus(target.getVersion());
    }

    private void addNode(RequirementTarget target, TargetStatus status) {
        Node reqNode = new Node(target, status);
        this.addNode(reqNode);
        Node lastCreated = reqNode;
        ArrayList<Node> createdNodes = new ArrayList<Node>();
        List allPaths = PathUtils.scanPath((String)target.getPath());
        allPaths.remove(allPaths.size() - 1);
        Collections.reverse(allPaths);
        for (String middlePath : allPaths) {
            Node parent;
            RequirementTarget middleTarget = new RequirementTarget(middlePath);
            if (this.targetExists(middleTarget)) {
                parent = (Node)this.getNode(middleTarget);
                this.addEdge(parent, lastCreated);
                if (!parent.isRequirement()) break;
                this.completingNodes(createdNodes);
                break;
            }
            parent = this.createNodeForParent(middleTarget, middlePath);
            this.addNode(parent);
            this.addEdge(parent, lastCreated);
            createdNodes.add(parent);
            lastCreated = parent;
        }
    }

    public void completingNodes(List<Node> createdNodes) {
        for (Node n : createdNodes) {
            n.setRequirement(true);
        }
    }

    private Node createNodeForParent(RequirementTarget middleTarget, String middlePath) {
        Requirement req;
        boolean isRequirement = false;
        TargetStatus targetStatus = new TargetStatus(Existence.TO_BE_CREATED);
        Long reqId = this.getRequirementLibraryFinderService().findNodeIdByPath(middlePath);
        if (reqId != null && (req = this.getRequirementLibraryFinderService().findRequirement(reqId)) != null) {
            isRequirement = true;
            targetStatus = new TargetStatus(Existence.EXISTS, reqId);
        }
        return new Node(middleTarget, targetStatus, isRequirement, true);
    }

    private void updateNode(RequirementTarget target, TargetStatus status) {
        Node foundNode = (Node)this.getNode(target);
        if (foundNode.isFolderAndReal()) {
            throw new IllegalStateException("cannot insert requirement '" + target.getPath() + "' because there is a folder there already");
        }
        foundNode.updateAsRequirement(target, status);
    }

    public void setNotExists(RequirementVersionTarget target) {
        Node req = (Node)this.getNode(target.getRequirement());
        if (req != null) {
            req.setNotExists(target.getVersion());
        }
    }

    public Long getNodeId(RequirementTarget requirement) {
        Node reqNode = (Node)this.getNode(requirement);
        if (reqNode != null && reqNode.getStatus().getStatus() == Existence.EXISTS) {
            return reqNode.getStatus().getId();
        }
        return null;
    }

    public void bindMilestone(RequirementVersionTarget target, String milestone) {
        Node req = (Node)this.getNode(target.getRequirement());
        req.bindMilestoneToVersion(target.getVersion(), milestone);
    }

    public void bindMilestone(RequirementVersionTarget target, List<String> milestones) {
        for (String milestone : milestones) {
            this.bindMilestone(target, milestone);
        }
    }

    public boolean isMilestoneUsedByOneVersion(RequirementVersionTarget target, String milestone) {
        Node req = (Node)this.getNode(target.getRequirement());
        return req.isMilestoneUsedByOneVersion(milestone);
    }

    public boolean isMilestoneLocked(RequirementVersionTarget target) {
        Node req = (Node)this.getNode(target.getRequirement());
        return req.isVersionMilestoneLocked(target.getVersion());
    }

    public void milestoneLock(RequirementVersionTarget target) {
        Node req = (Node)this.getNode(target.getRequirement());
        req.setVersionMilestoneLocked(target.getVersion());
    }

    public boolean isRequirementFolder(RequirementVersionTarget target) {
        return this.isRequirementFolder(target.getRequirement());
    }

    public boolean isRequirementFolder(RequirementTarget target) {
        Node req = (Node)this.getNode(target);
        if (req != null) {
            return req.isRequirementFolder() && req.getStatus().getStatus() != Existence.NOT_EXISTS;
        }
        return false;
    }

    public static class Node
    extends GraphNode<RequirementTarget, Node> {
        private TargetStatus status;
        private boolean isRequirement = true;
        private boolean virtual = false;
        private SortedMap<Integer, RequirementVersionModel> requirementVersions = new TreeMap<Integer, RequirementVersionModel>();
        private Set<String> milestonesInVersion = new HashSet<String>();

        public Node(RequirementTarget target, TargetStatus status) {
            super((Object)target);
            this.status = status;
        }

        public Node(RequirementTarget target, TargetStatus status, boolean isRequirement, boolean virtual) {
            super((Object)target);
            this.status = status;
            this.isRequirement = isRequirement;
            this.virtual = virtual;
        }

        public void setNotExists(Integer version) {
            this.requirementVersions.put(version, new RequirementVersionModel(TargetStatus.NOT_EXISTS));
        }

        boolean isRequirement() {
            return this.isRequirement;
        }

        public boolean isRequirementFolder() {
            return !this.isRequirement;
        }

        void setRequirement(boolean isReq) {
            this.isRequirement = isReq;
        }

        void setVirtual(boolean virtual) {
            this.virtual = virtual;
        }

        boolean isVirtual() {
            return this.virtual;
        }

        TargetStatus getStatus() {
            return this.status;
        }

        boolean isFolderAndReal() {
            return !this.isRequirement && !this.virtual;
        }

        void setStatus(TargetStatus status) {
            this.status = status;
        }

        boolean versionAlreadyLoaded(Integer versionNo) {
            return this.requirementVersions.containsKey(versionNo);
        }

        TargetStatus getVersionStatus(Integer versionNo) {
            if (this.versionAlreadyLoaded(versionNo)) {
                return ((RequirementVersionModel)this.requirementVersions.get(versionNo)).getStatus();
            }
            return null;
        }

        void addVersion(Integer noVersion, TargetStatus status) {
            this.requirementVersions.put(noVersion, new RequirementVersionModel(status));
        }

        boolean isMilestoneUsedByOneVersion(String milestone) {
            return this.milestonesInVersion.contains(milestone);
        }

        boolean isVersionMilestoneLocked(Integer noVersion) {
            return ((RequirementVersionModel)this.requirementVersions.get(noVersion)).isMilestoneLocked();
        }

        void bindMilestoneToVersion(Integer noVersion, String milestone) {
            if (!this.isMilestoneUsedByOneVersion(milestone)) {
                RequirementVersionModel rvModel = (RequirementVersionModel)this.requirementVersions.get(noVersion);
                rvModel.addMilestone(milestone);
                this.milestonesInVersion.add(milestone);
            }
        }

        public void setVersionMilestoneLocked(Integer noVersion) {
            RequirementVersionModel rvModel = (RequirementVersionModel)this.requirementVersions.get(noVersion);
            rvModel.setMilestoneLocked(true);
        }

        void updateAsRequirement(RequirementTarget target, TargetStatus status) {
            this.key = target;
            this.status = status;
            this.virtual = false;
            this.isRequirement = true;
            for (Node n : this.outbounds) {
                n.updateAsRequirement((RequirementTarget)n.getKey(), n.getStatus());
            }
        }
    }
}

