/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.ActionStepImportData;
import org.squashtest.tm.service.internal.batchimport.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.Batches;
import org.squashtest.tm.service.internal.batchimport.CallStepImportData;
import org.squashtest.tm.service.internal.batchimport.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.CustomFieldTransator;
import org.squashtest.tm.service.internal.batchimport.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetParametersValueImportData;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImplHelper;
import org.squashtest.tm.service.internal.batchimport.FacilityUtils;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementFacility;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseFacility;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageTarget;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.DatasetParamValueDao;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.requirement.CustomRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Component
@Scope(value="prototype")
public class FacilityImpl
extends AbstractEntityFacilitySupport
implements Facility {
    private static final String UNEXPECTED_ERROR_DURING_CREATION = "unexpected error occurred when creating {} in project : {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    private final FacilityImplHelper helper = new FacilityImplHelper(this);
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseModificationService testcaseModificationService;
    @Inject
    private CallStepManagerService callstepService;
    @Inject
    private ParameterModificationService parameterService;
    @Inject
    private DatasetModificationService datasetService;
    @Inject
    private RequirementLibraryNavigationService reqLibNavigationService;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private DatasetParamValueDao paramvalueDao;
    @Inject
    private ParameterDao paramDao;
    @Inject
    private RequirementVersionCoverageDao requirementVersionCoverageDao;
    @Inject
    private RequirementLibraryFinderService reqFinderService;
    @Inject
    private RequirementVersionCoverageDao coverageDao;
    @Inject
    private RequirementFacility requirementFacility;
    @Inject
    private TestCaseFacility testCaseFacility;
    @Inject
    private CustomFieldTransator customFieldTransator;
    @Inject
    protected ValidationFacility injectedValidator;
    @Inject
    private HighLevelRequirementService highLevelRequirementService;
    @Inject
    private RequirementVersionManagerService reqVersionManagerService;
    @Inject
    private CustomRequirementVersionManagerService requirementVersionManagerService;
    @Inject
    private ProjectDao projectDao;
    @PersistenceContext
    EntityManager em;

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        return this.testCaseFacility.updateTestCase(instr);
    }

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        return this.testCaseFacility.deleteTestCase(target);
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        LogTrain train = this.validator.updateActionStep(target, testStep, cufValues);
        if (!train.hasCriticalErrors()) {
            try {
                this.helper.truncate(cufValues);
                this.doUpdateActionStep(target, testStep, cufValues);
                LOGGER.debug("Excel import : Updated Action Step \t'" + target + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while updating step " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo, ActionTestStep actionStepBackup) {
        LogTrain train = this.validator.updateCallStep(target, testStep, calledTestCase, paramInfo, actionStepBackup);
        if (!train.hasCriticalErrors()) {
            try {
                this.doUpdateCallStep(target, calledTestCase, paramInfo);
                this.validator.getModel().updateCallStepTarget(target, calledTestCase, paramInfo);
                LOGGER.debug("Excel import : Created Call Step \t'" + target + "' -> '" + calledTestCase + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while updating step " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        LogTrain train = this.validator.deleteTestStep(target);
        if (!train.hasCriticalErrors()) {
            try {
                this.doDeleteTestStep(target);
                this.validator.getModel().remove(target);
                LOGGER.debug("Excel import : Deleted Step \t'" + target + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while deleting step " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogTrain train = this.validator.updateParameter(target, param);
        if (!train.hasCriticalErrors()) {
            try {
                this.doUpdateParameter(target, param);
                this.validator.getModel().addParameter(target);
                LOGGER.debug("Excel import : Updated Parameter \t'" + target + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while updating parameter " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        LogTrain train = this.validator.deleteParameter(target);
        if (!train.hasCriticalErrors()) {
            try {
                this.doDeleteParameter(target);
                this.validator.getModel().removeParameter(target);
                LOGGER.debug("Excel import : Deleted Parameter \t'" + target + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while deleting parameter " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain train = this.validator.failsafeUpdateParameterValue(dataset, param, value, isUpdate);
        if (!train.hasCriticalErrors()) {
            try {
                this.doFailsafeUpdateParameterValue(dataset, param, value);
                this.validator.getModel().addDataset(dataset);
                LOGGER.debug("Excel import : Updated Param Value for param \t'" + param + "' in dataset '" + dataset + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(dataset, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while setting parameter " + param + " in dataset " + dataset + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogTrain train = this.validator.deleteDataset(dataset);
        if (!train.hasCriticalErrors()) {
            try {
                this.doDeleteDataset(dataset);
                this.validator.getModel().removeDataset(dataset);
                LOGGER.debug("Excel import : Deleted Dataset '" + dataset + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(dataset, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while deleting dataset " + dataset + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    @Override
    public LogTrain createRequirementVersion(RequirementVersionInstruction instr) {
        return this.requirementFacility.createRequirementVersion(instr);
    }

    @Override
    public LogTrain updateRequirementVersion(RequirementVersionInstruction instr) {
        return this.requirementFacility.updateRequirementVersion(instr);
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        return this.requirementFacility.deleteRequirementVersion(instr);
    }

    @Override
    public LogTrain createRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementFacility.createRequirementLink(instr);
    }

    @Override
    public LogTrain updateRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementFacility.updateRequirementLink(instr);
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementFacility.deleteRequirementLink(instr);
    }

    public void postprocess(List<Instruction<?>> instructions) {
        this.requirementFacility.postprocess(instructions);
    }

    private void doUpdateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        String newResult;
        ActionTestStep orig = (ActionTestStep)this.validator.getModel().getStep(target);
        String newAction = testStep.getAction();
        if (!StringUtils.isBlank((CharSequence)newAction) && !newAction.equals(orig.getAction())) {
            orig.setAction(ExcelRowReaderUtils.escapeHTMLInsideTags(newAction));
        }
        if (!StringUtils.isBlank((CharSequence)(newResult = testStep.getExpectedResult())) && !newResult.equals(orig.getExpectedResult())) {
            orig.setExpectedResult(ExcelRowReaderUtils.escapeHTMLInsideTags(newResult));
        }
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
    }

    private void doUpdateCallStep(TestStepTarget target, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo) {
        TestStep actualStep = this.validator.getModel().getStep(target);
        TestCase newCalled = this.validator.getModel().get(calledTestCase);
        this.callstepService.checkForCyclicStepCallBeforePaste(actualStep.getTestCase().getId(), newCalled.getId());
        ((CallTestStep)actualStep).setCalledTestCase(newCalled);
        this.changeParameterAssignation(actualStep.getId(), calledTestCase, paramInfo);
    }

    private void doDeleteTestStep(TestStepTarget target) {
        TestCase tc = this.validator.getModel().get(target.getTestCase());
        this.testcaseModificationService.removeStepFromTestCaseByIndex(tc.getId(), target.getIndex());
    }

    private void doUpdateParameter(ParameterTarget target, Parameter param) {
        if (!this.validator.getModel().doesParameterExists(target)) {
            Long testcaseId = this.validator.getModel().getId(target.getOwner());
            this.helper.fillNullWithDefaults(param);
            this.helper.truncate(param);
            this.parameterService.addNewParameterToTestCase(param, testcaseId);
        } else {
            String description = param.getDescription();
            if (description != null) {
                this.findParameter(target).setDescription(description);
            }
        }
    }

    private void doDeleteParameter(ParameterTarget target) {
        Long testcaseId = this.validator.getModel().getId(target.getOwner());
        List<Parameter> allparams = this.parameterService.findAllParameters(testcaseId);
        Parameter param = null;
        for (Parameter p : allparams) {
            if (!p.getName().equals(target.getName())) continue;
            param = p;
            break;
        }
        this.parameterService.remove(param);
    }

    private void doFailsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value) {
        DatasetParamValue dpv = this.findParamValue(dataset, param);
        String trValue = this.helper.truncate(value);
        dpv.setParamValue(trValue);
    }

    private void doDeleteDataset(DatasetTarget dataset) {
        Dataset ds = this.findOrCreateDataset(dataset);
        TestCase tc = ds.getTestCase();
        tc.removeDataset(ds);
        this.datasetService.remove(ds);
    }

    private Parameter findParameter(ParameterTarget param) {
        Long testcaseId = this.validator.getModel().getId(param.getOwner());
        Parameter found = this.paramDao.findOwnParameterByNameAndTestCase(param.getName(), testcaseId);
        if (found != null) {
            return found;
        }
        throw new NoSuchElementException("parameter " + param + " could not be found");
    }

    private Dataset findOrCreateDataset(DatasetTarget dataset) {
        String truncated;
        Long tcid = this.validator.getModel().getId(dataset.getTestCase());
        Dataset found = this.datasetDao.findByTestCaseIdAndName(tcid, truncated = this.helper.truncate(dataset.getName()));
        if (found != null) {
            return found;
        }
        Dataset newds = new Dataset();
        newds.setName(dataset.getName());
        this.helper.fillNullWithDefaults(newds);
        this.helper.truncate(newds);
        this.datasetService.persist(newds, tcid);
        LOGGER.debug("Excel import : Created Dataset \t'" + dataset + "'", new Object[0]);
        return newds;
    }

    private void changeParameterAssignation(Long stepId, TestCaseTarget tc, CallStepParamsInfo paramInfo) {
        Long dsId = null;
        ParameterAssignationMode mode = paramInfo.getParamMode();
        if (paramInfo.getParamMode() == ParameterAssignationMode.CALLED_DATASET) {
            String dsname;
            Long tcid = this.validator.getModel().getId(tc);
            Dataset ds = this.datasetDao.findByTestCaseIdAndName(tcid, dsname = this.helper.truncate(paramInfo.getCalledDatasetName()));
            if (ds != null) {
                dsId = ds.getId();
            } else {
                mode = ParameterAssignationMode.NOTHING;
            }
        }
        this.callstepService.setParameterAssignationMode(stepId, mode, dsId);
    }

    private DatasetParamValue findParamValue(DatasetTarget dataset, ParameterTarget param) {
        DatasetParamValue dpv2;
        Dataset dbDs = this.findOrCreateDataset(dataset);
        Parameter dsParam = this.findParameter(param);
        for (DatasetParamValue dpv2 : dbDs.getParameterValues()) {
            if (!dpv2.getParameter().equals(dsParam)) continue;
            return dpv2;
        }
        dpv2 = new DatasetParamValue(dsParam, dbDs);
        this.paramvalueDao.save(dpv2);
        dbDs.addParameterValue(dpv2);
        return dpv2;
    }

    @Override
    public LogTrain createLinkedLowLevelRequirement(LinkedLowLevelRequirementInstruction instr) {
        LogTrain train = this.validator.createLinkedLowLevelRequirement(instr);
        if (!train.hasCriticalErrors()) {
            LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instr.getTarget();
            Long highLevelReqId = this.reqFinderService.findNodeIdByPath(target.getHighLevelReqPath());
            Long standardReqId = this.reqFinderService.findNodeIdByPath(target.getStandardReqPath());
            this.highLevelRequirementService.linkToHighLevelRequirement(highLevelReqId, standardReqId);
        }
        return train;
    }

    @Override
    public LogTrain createCoverage(CoverageInstruction instr) {
        LogTrain train = this.validator.createCoverage(instr);
        if (!train.hasCriticalErrors()) {
            CoverageTarget target = (CoverageTarget)instr.getTarget();
            Long reqId = this.reqFinderService.findNodeIdByPath(target.getReqPath());
            Requirement req = this.reqLibNavigationService.findRequirement(reqId);
            RequirementVersion reqVersion = req.findRequirementVersion(target.getReqVersion());
            Long tcId = this.navigationService.findNodeIdByPath(target.getTcPath());
            TestCase tc = this.testcaseModificationService.findById(tcId);
            Long alreadyVerifiedReqVersionId = this.requirementVersionManagerService.findLatestRequirementVersionByRequirementIdAndVerifyingTestCaseId(reqId, tcId);
            RequirementVersionCoverage coverage = instr.getCoverage();
            if (alreadyVerifiedReqVersionId != null) {
                coverage = this.requirementVersionCoverageDao.byRequirementVersionAndTestCase(alreadyVerifiedReqVersionId, tcId);
                coverage.setVerifiedRequirementVersion(reqVersion);
            } else {
                coverage.setVerifiedRequirementVersion(reqVersion);
                coverage.setVerifyingTestCase(tc);
            }
            this.coverageDao.persist(coverage);
        }
        return train;
    }

    @PostConstruct
    public void initializeFactories() {
        this.initializeCustomFieldTransator(this.customFieldTransator);
        this.testCaseFacility.initializeCustomFieldTransator(this.customFieldTransator);
        this.requirementFacility.initializeCustomFieldTransator(this.customFieldTransator);
        this.initializeValidator(this.injectedValidator);
        this.testCaseFacility.initializeValidator(this.injectedValidator);
        this.requirementFacility.initializeValidator(this.injectedValidator);
    }

    @Override
    public Map<TestCaseInstruction, LogTrain> createTestCases(List<TestCaseInstruction> instructions) {
        return this.testCaseFacility.createTestCases(instructions);
    }

    @Override
    public Map<ParameterInstruction, LogTrain> createParameters(List<ParameterInstruction> instructions) {
        Map<String, List<ParameterInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((ParameterTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectTestCaseParameters((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<ParameterInstruction, LogTrain> importProjectTestCaseParameters(String projectName, List<ParameterInstruction> instructions) {
        Map<ParameterInstruction, LogTrain> instructionLogTrain = this.validator.createParameters(instructions);
        List<ParameterInstruction> validParameters = instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).map(Map.Entry::getKey).toList();
        try {
            this.doCreateParameters(validParameters);
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> this.addUnexpectedError((LogTrain)e.getValue(), (Target)((ParameterInstruction)e.getKey()).getTarget(), ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"parameters", projectName, ex});
        }
        return instructionLogTrain;
    }

    private void doCreateParameters(List<ParameterInstruction> parameterInstructions) {
        Batches<Parameter> batchToCreate = new Batches<Parameter>();
        Batches<ParameterInstruction> batchToUpdate = new Batches<ParameterInstruction>();
        parameterInstructions.forEach(instr -> {
            Parameter parameter = instr.getParameter();
            ParameterTarget target = (ParameterTarget)instr.getTarget();
            Long testcaseId = this.validator.getModel().getId(target.getOwner());
            if (this.validator.getModel().doesParameterExists(target)) {
                batchToUpdate.addBatch(testcaseId, (ParameterInstruction)instr);
            } else {
                this.helper.fillNullWithDefaults(parameter);
                this.helper.truncate(parameter);
                batchToCreate.addBatch(testcaseId, parameter);
            }
        });
        this.addMissingParameters(batchToCreate);
        this.updateExistingParameters(batchToUpdate);
        parameterInstructions.forEach(instruction -> {
            this.validator.getModel().addParameter((ParameterTarget)instruction.getTarget());
            LOGGER.debug("Excel import : Created Parameter \t'" + instruction.getTarget() + "'", new Object[0]);
        });
    }

    private void addMissingParameters(Batches<Parameter> batch) {
        if (batch.isEmpty()) {
            return;
        }
        for (List<Batch<Parameter>> batchList : batch.partition(30)) {
            this.parameterService.batchParameterAddition(batchList);
        }
    }

    private void updateExistingParameters(Batches<ParameterInstruction> batch) {
        if (batch.isEmpty()) {
            return;
        }
        for (List<Batch<ParameterInstruction>> batchList : batch.partition(20)) {
            this.parameterService.updateImportParameters(batchList);
        }
    }

    @Override
    public Map<DatasetInstruction, LogTrain> createDatasets(List<DatasetInstruction> instructions) {
        Map<String, List<DatasetInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((DatasetTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectTestCaseDatasets((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<DatasetInstruction, LogTrain> importProjectTestCaseDatasets(String projectName, List<DatasetInstruction> instructions) {
        Map<DatasetInstruction, LogTrain> instructionLogTrain = this.validator.createDatasets(instructions);
        List<DatasetInstruction> validDatasets = instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).map(Map.Entry::getKey).toList();
        try {
            this.doCreateDatasets(validDatasets);
            this.validator.getModel().addDatasets(validDatasets.stream().map(Instruction::getTarget).toList());
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> this.addUnexpectedError((LogTrain)e.getValue(), (Target)((DatasetInstruction)e.getKey()).getTarget(), ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"datasets", projectName, ex});
        }
        return instructionLogTrain;
    }

    protected void addUnexpectedError(LogTrain train, Target target, Throwable ex) {
        train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
    }

    private void doCreateDatasets(List<DatasetInstruction> instructions) {
        Map<Long, List<DatasetTarget>> targetsByTestCaseIds = instructions.stream().map(Instruction::getTarget).collect(Collectors.groupingBy(target -> this.validator.getModel().getId(target.getTestCase()), Collectors.toList()));
        Map datasetsNamesByTestCaseId = this.datasetDao.findOwnDatasetNamesByTestCaseIds(targetsByTestCaseIds.keySet());
        Batches<Dataset> batch = this.collectMissingDatasets(targetsByTestCaseIds, datasetsNamesByTestCaseId);
        for (List<Batch<Dataset>> batchList : batch.partition(20)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.datasetService.persistBatch(testCaseIds, batchList);
        }
    }

    private Batches<Dataset> collectMissingDatasets(Map<Long, List<DatasetTarget>> targetsByTestCaseIds, Map<Long, List<String>> datasetsNamesByTestCaseId) {
        Batches<Dataset> batch = new Batches<Dataset>();
        for (Map.Entry<Long, List<DatasetTarget>> entry : targetsByTestCaseIds.entrySet()) {
            List<DatasetTarget> targets = entry.getValue();
            Long testCaseId = entry.getKey();
            ArrayList<String> collectDatasetNames = new ArrayList<String>();
            List existingDatasets = datasetsNamesByTestCaseId.getOrDefault(testCaseId, Collections.emptyList());
            for (DatasetTarget datasetTarget : targets) {
                String truncatedName = this.helper.truncate(datasetTarget.getName());
                if (existingDatasets.contains(truncatedName) || collectDatasetNames.contains(truncatedName)) continue;
                Dataset dataset = new Dataset();
                dataset.setName(datasetTarget.getName());
                this.helper.fillNullWithDefaults(dataset);
                this.helper.truncate(dataset);
                batch.addBatch(testCaseId, dataset);
                collectDatasetNames.add(truncatedName);
            }
        }
        return batch;
    }

    @Override
    public Map<ActionStepInstruction, LogTrain> addActionSteps(List<ActionStepInstruction> instructions) {
        Map<String, List<ActionStepInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((TestStepTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectActionSteps((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<ActionStepInstruction, LogTrain> importProjectActionSteps(String projectName, List<ActionStepInstruction> instructions) {
        Map<ActionStepInstruction, LogTrain> instructionLogTrain = this.validator.addActionSteps(instructions);
        List<ActionStepInstruction> validTestSteps = instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).map(Map.Entry::getKey).toList();
        try {
            this.doCreateActionTestSteps(validTestSteps, projectName);
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> this.addUnexpectedError((LogTrain)e.getValue(), (Target)((ActionStepInstruction)e.getKey()).getTarget(), ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"action steps", projectName, ex});
        }
        return instructionLogTrain;
    }

    private void doCreateActionTestSteps(List<ActionStepInstruction> instructions, String projectName) {
        Batches<ActionStepImportData> batches = this.batchGroupingActionSteps(instructions);
        this.createBatchActionTestSteps(projectName, batches);
    }

    private void createBatchActionTestSteps(String projectName, Batches<ActionStepImportData> batches) {
        if (batches.isEmpty()) {
            return;
        }
        Project project = this.projectDao.findByName(projectName);
        for (List<Batch<ActionStepImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.testcaseModificationService.addImportActionSteps(project, testCaseIds, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).map(ActionStepImportData::getTarget).forEach(target -> {
                Integer n = this.validator.getModel().addActionStep((TestStepTarget)target);
            });
        }
    }

    private Batches<ActionStepImportData> batchGroupingActionSteps(List<ActionStepInstruction> instructions) {
        Batches<ActionStepImportData> batches = new Batches<ActionStepImportData>();
        for (ActionStepInstruction instruction : instructions) {
            ActionTestStep testStep = instruction.getTestStep();
            this.helper.fillNullWithDefaults(testStep);
            Map<String, String> customFields = instruction.getCustomFields();
            this.helper.truncate(customFields);
            Map<Long, RawValue> acceptableCustomFields = this.toAcceptableCufs(customFields);
            TestStepTarget target = (TestStepTarget)instruction.getTarget();
            Long testCaseId = this.validator.getModel().getId(target.getTestCase());
            ActionStepImportData testStepImportData = new ActionStepImportData(testStep, target, target.getIndex());
            testStepImportData.addCustomFields(acceptableCustomFields);
            batches.addBatch(testCaseId, testStepImportData);
        }
        return batches;
    }

    @Override
    public Map<CallStepInstruction, LogTrain> addCallSteps(List<CallStepInstruction> instructions) {
        Map<String, List<CallStepInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((TestStepTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectCallSteps((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<CallStepInstruction, LogTrain> importProjectCallSteps(String projectName, List<CallStepInstruction> instructions) {
        Map<CallStepInstruction, LogTrain> instructionLogTrain = this.validator.addCallSteps(instructions);
        Batches<ActionStepImportData> batchesActionStep = new Batches<ActionStepImportData>();
        Batches<CallStepImportData> batchesCallStep = new Batches<CallStepImportData>();
        instructionLogTrain.entrySet().stream().filter(entry -> !((LogTrain)entry.getValue()).hasCriticalErrors()).forEach(entry -> this.callStepInstructionDistribution((Map.Entry<CallStepInstruction, LogTrain>)entry, batchesActionStep, batchesCallStep));
        try {
            this.createBatchActionTestSteps(projectName, batchesActionStep);
            this.createBatchCallTestSteps(projectName, batchesCallStep);
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> this.addUnexpectedError((LogTrain)e.getValue(), (Target)((CallStepInstruction)e.getKey()).getTarget(), ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"call steps", projectName, ex});
        }
        return instructionLogTrain;
    }

    private void createBatchCallTestSteps(String projectName, Batches<CallStepImportData> batches) {
        if (batches.isEmpty()) {
            return;
        }
        Project project = this.projectDao.findByName(projectName);
        for (List<Batch<CallStepImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.callstepService.addImportCallSteps(project, testCaseIds, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).forEach(data -> {
                Integer n = this.validator.getModel().addCallStep(data.getTarget(), data.getCalledTestCaseTarget(), data.getParameterMode());
            });
        }
    }

    private void callStepInstructionDistribution(Map.Entry<CallStepInstruction, LogTrain> entry, Batches<ActionStepImportData> actionStepBatches, Batches<CallStepImportData> callBatches) {
        CallStepInstruction instruction = entry.getKey();
        TestStepTarget target = (TestStepTarget)instruction.getTarget();
        Long testCaseId = this.validator.getModel().getId(target.getTestCase());
        String mustImportCallAsActionStepErrorI18n = FacilityUtils.mustImportCallAsActionStep(entry.getValue());
        if (mustImportCallAsActionStepErrorI18n != null) {
            ActionTestStep testStep = instruction.getActionStepBackup();
            this.helper.fillNullWithDefaults(testStep);
            ActionStepImportData testStepImportData = new ActionStepImportData(testStep, target, target.getIndex());
            actionStepBatches.addBatch(testCaseId, testStepImportData);
        } else {
            Long calledTestCaseId = this.validator.getModel().getId(instruction.getCalledTC());
            CallStepParamsInfo paramsInfo = instruction.getDatasetInfo();
            CallStepImportData callStepImportData = new CallStepImportData(calledTestCaseId, instruction.getCalledTC(), paramsInfo.getParamMode(), this.helper.truncate(paramsInfo.getCalledDatasetName()), target);
            callBatches.addBatch(testCaseId, callStepImportData);
        }
    }

    @Override
    public Map<DatasetParamValueInstruction, LogTrain> addDatasetParametersValues(List<DatasetParamValueInstruction> instructions) {
        Map<String, List<DatasetParamValueInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((DatasetTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectDatasetParametersValues((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<DatasetParamValueInstruction, LogTrain> importProjectDatasetParametersValues(String projectName, List<DatasetParamValueInstruction> instructions) {
        Map<DatasetParamValueInstruction, LogTrain> instructionLogTrain = this.validator.addDatasetParametersValues(instructions);
        List<DatasetParamValueInstruction> validParametersValues = instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).map(Map.Entry::getKey).toList();
        try {
            this.doAddDatasetParametersValues(validParametersValues);
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> this.addUnexpectedError((LogTrain)e.getValue(), (Target)((DatasetParamValueInstruction)e.getKey()).getTarget(), ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"parameter values", projectName, ex});
        }
        return instructionLogTrain;
    }

    private void doAddDatasetParametersValues(List<DatasetParamValueInstruction> instructions) {
        Map<DatasetTarget, List<DatasetParamValueInstruction>> instructionsByDataset = instructions.stream().collect(Collectors.groupingBy(Instruction::getTarget, Collectors.toList()));
        Batches<DatasetParametersValueImportData> batches = this.collectBatchDatasetParameterValues(instructionsByDataset);
        for (List<Batch<DatasetParametersValueImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            Batches<Dataset> datasetsToCreate = this.batchDatasetParametersValuesAddition(batchList, testCaseIds);
            for (List<Batch<Dataset>> datasetBatchList : datasetsToCreate.partition(30)) {
                List<Long> testCaseDatasetIds = batchList.stream().map(Batch::getTargetId).toList();
                this.datasetService.persistBatch(testCaseDatasetIds, datasetBatchList);
            }
            this.em.flush();
            this.em.clear();
        }
    }

    private Batches<DatasetParametersValueImportData> collectBatchDatasetParameterValues(Map<DatasetTarget, List<DatasetParamValueInstruction>> instructionsByDataset) {
        Batches<DatasetParametersValueImportData> batches = new Batches<DatasetParametersValueImportData>();
        for (Map.Entry<DatasetTarget, List<DatasetParamValueInstruction>> entry : instructionsByDataset.entrySet()) {
            DatasetTarget target = entry.getKey();
            Long testCaseId = this.validator.getModel().getId(target.getTestCase());
            DatasetParametersValueImportData data = new DatasetParametersValueImportData(target.getName());
            for (DatasetParamValueInstruction instruction : entry.getValue()) {
                data.addParameterTargetValue(instruction.getParameterTarget().getName(), this.helper.truncate(instruction.getDatasetValue().getValue()));
            }
            batches.addBatch(testCaseId, data);
        }
        return batches;
    }

    private Batches<Dataset> batchDatasetParametersValuesAddition(List<Batch<DatasetParametersValueImportData>> batchList, List<Long> testCaseIds) {
        Map parametersByTestCaseId = this.paramDao.findParametersByTestCaseIds(testCaseIds);
        Map datasetsByTestCaseId = this.datasetDao.findOwnDatasetsByTestCaseIds(testCaseIds);
        Batches<Dataset> datasetsToCreate = new Batches<Dataset>();
        for (Batch<DatasetParametersValueImportData> batch : batchList) {
            Map datasetNames = datasetsByTestCaseId.getOrDefault(batch.getTargetId(), Collections.emptyList()).stream().collect(Collectors.toMap(Dataset::getName, Function.identity()));
            Map<String, Parameter> parameterByName = parametersByTestCaseId.getOrDefault(batch.getTargetId(), Collections.emptyList()).stream().collect(Collectors.toMap(Parameter::getName, Function.identity()));
            for (DatasetParametersValueImportData parameterData : batch.getEntities()) {
                String datasetName = parameterData.getDataset();
                Dataset dataset = (Dataset)datasetNames.get(parameterData.getDataset());
                if (dataset == null) {
                    dataset = this.createNewDataset(datasetName, parameterData, parameterByName);
                    datasetsToCreate.addBatch(batch.getTargetId(), dataset);
                    continue;
                }
                this.updateExistingDataset(dataset, parameterData, parameterByName);
            }
        }
        return datasetsToCreate;
    }

    private void updateExistingDataset(Dataset dataset, DatasetParametersValueImportData parameterData, Map<String, Parameter> parameterByName) {
        parameterData.getValuesParameters().forEach((parameterName, value) -> {
            Parameter parameter = (Parameter)parameterByName.get(parameterName);
            FacilityImpl.checkNotNullParameter(parameterName, parameter);
            DatasetParamValue dpv = this.retrieveParameter(dataset, parameter);
            if (dpv == null) {
                dpv = new DatasetParamValue(parameter, dataset);
                this.paramvalueDao.save(dpv);
                dataset.addParameterValue(dpv);
            }
            dpv.setParamValue(value);
        });
    }

    private static void checkNotNullParameter(String parameterName, Parameter parameter) {
        if (parameter == null) {
            throw new NoSuchElementException("Parameter " + parameterName + " could not be found");
        }
    }

    private Dataset createNewDataset(String datasetName, DatasetParametersValueImportData parameterData, Map<String, Parameter> parameterByName) {
        Dataset dataset = new Dataset();
        dataset.setName(datasetName);
        this.helper.fillNullWithDefaults(dataset);
        this.helper.truncate(dataset);
        parameterData.getValuesParameters().forEach((parameterName, value) -> {
            Parameter parameter = (Parameter)parameterByName.get(parameterName);
            FacilityImpl.checkNotNullParameter(parameterName, parameter);
            DatasetParamValue dpv = new DatasetParamValue(parameter, dataset);
            dataset.addParameterValue(dpv);
            dpv.setParamValue(value);
        });
        return dataset;
    }

    private DatasetParamValue retrieveParameter(Dataset dataset, Parameter parameter) {
        for (DatasetParamValue dpv : dataset.getParameterValues()) {
            if (!dpv.getParameter().equals(parameter)) continue;
            return dpv;
        }
        return null;
    }
}

