/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import javax.inject.Inject;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.batchexport.RequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModel;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;

@Component
@Scope(value="prototype")
public class SearchRequirementExcelExporter
extends RequirementExcelExporter {
    private static final RequirementSheetColumn[] SEARCH_REQ_COLUMNS = new RequirementSheetColumn[]{RequirementSheetColumn.REQ_VERSIONS};
    private static final RequirementSheetColumn[] MILESTONE_SEARCH_REQ_COLUMNS = new RequirementSheetColumn[]{RequirementSheetColumn.REQ_VERSION_NB_MILESTONE};

    @Inject
    public SearchRequirementExcelExporter(FeatureManager featureManager, MessageSource messageSource) {
        super(featureManager, messageSource);
    }

    @Override
    protected int doOptionalCreateSheetHeader(Row h, int cIdx) {
        RequirementSheetColumn t;
        int n;
        int n2;
        RequirementSheetColumn[] requirementSheetColumnArray;
        int columnIndexOptional = cIdx;
        if (this.milestonesEnabled) {
            requirementSheetColumnArray = MILESTONE_SEARCH_REQ_COLUMNS;
            n2 = MILESTONE_SEARCH_REQ_COLUMNS.length;
            n = 0;
            while (n < n2) {
                t = requirementSheetColumnArray[n];
                h.createCell(columnIndexOptional++).setCellValue(t.getHeader());
                ++n;
            }
        }
        requirementSheetColumnArray = SEARCH_REQ_COLUMNS;
        n2 = SEARCH_REQ_COLUMNS.length;
        n = 0;
        while (n < n2) {
            t = requirementSheetColumnArray[n];
            h.createCell(columnIndexOptional++).setCellValue(t.getHeader());
            ++n;
        }
        return columnIndexOptional;
    }

    @Override
    protected int doOptionalAppendRequirement(Row row, int colIndex, RequirementModel reqModel) {
        int columnIndexOptional = colIndex;
        if (this.milestonesEnabled) {
            row.createCell(columnIndexOptional++).setCellValue((double)reqModel.getMilestoneCount());
        }
        row.createCell(columnIndexOptional++).setCellValue((double)reqModel.getVersionCount().longValue());
        return columnIndexOptional;
    }
}

