/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.internal.batchexport.ExportDaoUtils;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.LinkedLowLevelRequirementModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementLinkModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModelFromJooq;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.hibernate.EasyConstructorResultTransformer;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;

@Repository
public class RequirementExportDao {
    private static final String VERSION_IDS = "versionIds";
    private static final String IS_HIGH_LEVEL = "isHighLevel";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dsl;
    @Inject
    private PathService pathService;
    @Inject
    private HighLevelRequirementService highLevelRequirementService;

    public RequirementExportModel findAllRequirementModel(List<Long> versionIds) {
        RequirementExportModel model = this.populateRequirementExportModel(versionIds);
        List<CoverageModel> coverageModels = this.findRequirementVersionCoverageModels(versionIds);
        List<RequirementLinkModel> linkModels = this.findRequirementLinkModels(versionIds);
        List<LinkedLowLevelRequirementModel> linkedLowLevelReqModels = this.findLinkedLowLevelReqModels(versionIds);
        ExportDaoUtils.setPathForCoverage(this.em, this.pathService, coverageModels);
        model.setCoverages(coverageModels);
        model.setReqLinks(linkModels);
        model.setLinkedLowLevelReqs(linkedLowLevelReqModels);
        return model;
    }

    public RequirementExportModel populateRequirementExportModel(List<Long> versionIds) {
        RequirementExportModel model = new RequirementExportModel();
        List<RequirementModel> requirementsModel = this.findRequirementModel(versionIds);
        model.setRequirementsModels(requirementsModel);
        return model;
    }

    public RequirementExportModel populateRequirementExportModelFromJooq(List<Long> versionIds) {
        RequirementExportModel model = new RequirementExportModel();
        List<RequirementModelFromJooq> requirementsModelFromJooqs = this.findRequirementModelFromJooq(versionIds);
        model.setRequirementsModelsFromJooq(requirementsModelFromJooqs);
        for (RequirementModelFromJooq requirementsModelFromJooq : requirementsModelFromJooqs) {
            Session session = ExportDaoUtils.getStatelessSession(this.em);
            Query q = session.getNamedQuery("requirement.excelRequirementExportCUF");
            q.setLong("requirementVersionId", requirementsModelFromJooq.getId().longValue());
            q.setResultTransformer((ResultTransformer)new EasyConstructorResultTransformer(ExportModel.CustomField.class));
            requirementsModelFromJooq.setCufs(q.list());
        }
        return model;
    }

    private List<CoverageModel> findRequirementVersionCoverageModels(List<Long> versionIds) {
        return ExportDaoUtils.loadModels(this.em, "requirementVersion.excelExportCoverage", versionIds, VERSION_IDS, CoverageModel.class);
    }

    private List<RequirementLinkModel> findRequirementLinkModels(List<Long> versionIds) {
        List<RequirementLinkModel> models = ExportDaoUtils.loadModels(this.em, "requirementVersion.excelExportRequirementLinks", versionIds, VERSION_IDS, RequirementLinkModel.class);
        List<Long> reqIds = this.gatherRequirementIdsFromLinkModels(models);
        Map<Long, String> pathById = this.gatherRequirementPaths(reqIds);
        this.assignPaths(models, pathById);
        return models;
    }

    private List<LinkedLowLevelRequirementModel> findLinkedLowLevelReqModels(List<Long> versionIds) {
        ArrayList<LinkedLowLevelRequirementModel> models = new ArrayList<LinkedLowLevelRequirementModel>();
        Map<Long, List<Long>> map = this.highLevelRequirementService.findLinkedLowLevelReqIdsMappedByHighLevelReqIdFromVersionIds(versionIds);
        for (Map.Entry<Long, List<Long>> mapped : map.entrySet()) {
            mapped.getValue().forEach(it -> {
                LinkedLowLevelRequirementModel model = new LinkedLowLevelRequirementModel((Long)mapped.getKey(), (Long)it, null, null);
                models.add(model);
            });
        }
        List<Long> reqIds = this.gatherRequirementIdsFromLinkedLowLevelReqModels(models);
        Map<Long, String> pathById = this.gatherRequirementPaths(reqIds);
        this.assignLinkedLowReqPaths(models, pathById);
        return models;
    }

    private List<RequirementModel> findRequirementModel(List<Long> versionIds) {
        List<RequirementModel> requirementModels = ExportDaoUtils.loadModels(this.em, "requirement.findVersionsModels", versionIds, VERSION_IDS, RequirementModel.class);
        this.getOtherProperties(requirementModels);
        return requirementModels;
    }

    private void getOtherProperties(List<RequirementModel> requirementModels) {
        for (RequirementModel requirementModel : requirementModels) {
            requirementModel.setPath(this.getPathAsString(requirementModel));
            this.getModelRequirementPosition(requirementModel);
            this.getModelRequirementCUF(requirementModel);
        }
    }

    public String getPathAsString(RequirementModel exportedRequirement) {
        return ExportDaoUtils.getRequirementPath(this.em, exportedRequirement.getRequirementId(), exportedRequirement.getProjectName());
    }

    private void getModelRequirementCUF(RequirementModel requirementModel) {
        Session session = ExportDaoUtils.getStatelessSession(this.em);
        Query q = session.getNamedQuery("requirement.excelRequirementExportCUF");
        q.setLong("requirementVersionId", requirementModel.getId().longValue());
        q.setResultTransformer((ResultTransformer)new EasyConstructorResultTransformer(ExportModel.CustomField.class));
        requirementModel.setCufs(q.list());
    }

    private void getModelRequirementPosition(RequirementModel requirementModel) {
        Long reqId = requirementModel.getRequirementId();
        int index = this.getRequirementPositionInLibrary(reqId);
        if (index == 0) {
            index = this.getRequirementPositionInFolder(reqId);
        }
        if (index == 0) {
            index = this.getPositionChildrenRequirement(reqId);
        }
        requirementModel.setRequirementIndex(index);
    }

    private int getPositionChildrenRequirement(Long reqId) {
        return ExportDaoUtils.requirementVersionQuery(this.em, "requirement.findVersionsModelsIndexChildrenRequirement", reqId, 0);
    }

    private int getRequirementPositionInFolder(Long reqId) {
        return ExportDaoUtils.requirementVersionQuery(this.em, "requirement.findVersionsModelsIndexInFolder", reqId, 0);
    }

    private int getRequirementPositionInLibrary(Long reqId) {
        return ExportDaoUtils.requirementVersionQuery(this.em, "requirement.findVersionsModelsIndexInLibrary", reqId, 0);
    }

    private List<Long> gatherRequirementIdsFromLinkModels(List<RequirementLinkModel> models) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        for (RequirementLinkModel model : models) {
            ids.add(model.getReqId());
            ids.add(model.getRelReqId());
        }
        return new ArrayList<Long>(ids);
    }

    private List<Long> gatherRequirementIdsFromLinkedLowLevelReqModels(List<LinkedLowLevelRequirementModel> models) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        for (LinkedLowLevelRequirementModel model : models) {
            ids.add(model.getHighLevelReqId());
            ids.add(model.getLinkedLowLevelReqId());
        }
        return new ArrayList<Long>(ids);
    }

    private Map<Long, String> gatherRequirementPaths(List<Long> requirementIds) {
        int nbReqs = requirementIds.size();
        List<String> pathes = this.pathService.buildRequirementsPaths(requirementIds);
        HashMap<Long, String> pathById = new HashMap<Long, String>(nbReqs);
        int i = 0;
        while (i < nbReqs) {
            pathById.put(requirementIds.get(i), pathes.get(i));
            ++i;
        }
        return pathById;
    }

    private void assignPaths(List<RequirementLinkModel> models, Map<Long, String> pathById) {
        for (RequirementLinkModel model : models) {
            String reqPath = pathById.get(model.getReqId());
            String relPath = pathById.get(model.getRelReqId());
            model.setReqPath(reqPath);
            model.setRelReqPath(relPath);
        }
    }

    private void assignLinkedLowReqPaths(List<LinkedLowLevelRequirementModel> models, Map<Long, String> pathById) {
        for (LinkedLowLevelRequirementModel model : models) {
            String highLevelReqPath = pathById.get(model.getHighLevelReqId());
            String linkedLowLevelReqPath = pathById.get(model.getLinkedLowLevelReqId());
            model.setHighLevelReqPath(highLevelReqPath);
            model.setLinkedLowLevelReqPath(linkedLowLevelReqPath);
        }
    }

    private List<RequirementModelFromJooq> findRequirementModelFromJooq(List<Long> versionIds) {
        RequirementVersion innerVersions = Tables.REQUIREMENT_VERSION.as("INNER_VERSIONS");
        String versionCountAlias = "VERSIONS_COUNT";
        return this.dsl.select(new SelectFieldOrAsterisk[]{Tables.REQUIREMENT_VERSION.RES_ID.as("ID"), Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.INFO_LIST_ITEM.LABEL.as(ColumnIds.REQUIREMENT_CATEGORY.getColumnId()), Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as("REQUIREMENT_VERSION_NUMBER"), Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, Tables.RESOURCE.NAME, Tables.RESOURCE.CREATED_BY, Tables.RESOURCE.LAST_MODIFIED_BY, Tables.RESOURCE.LAST_MODIFIED_ON, Tables.RESOURCE.DESCRIPTION, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.RESOURCE.CREATED_ON, Tables.PROJECT.NAME.as(ColumnIds.PROJECT_NAME.getColumnId()), DSL.countDistinct((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).as("MILESTONES"), DSL.selectCount().from((TableLike)innerVersions).where(innerVersions.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).asField(versionCountAlias), DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Object)true).otherwise((Object)false).as(IS_HIGH_LEVEL), DSL.selectCount().from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.RESOURCE.ATTACHMENT_LIST_ID)).asField(ColumnIds.ATTACHMENTS.getColumnId()), DSL.when((Condition)DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.RLN_RELATIONSHIP).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID))), (Object)true).otherwise((Object)false).as(ColumnIds.REQUIREMENT_VERSION_HAS_PARENT.getColumnId()), DSL.selectCount().from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).asField("CHILD_OF_REQUIREMENT"), DSL.selectCount().from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).asField("LINKED_STANDARD_REQUIREMENT"), DSL.when((Condition)DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION_LINK).where(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID))), (Object)true).otherwise((Object)false).as("HAS_LINK_TYPE"), DSL.when((Condition)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.isNotNull(), (Object)true).otherwise((Object)false).as("REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT"), DSL.countDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).as(ColumnIds.COVERAGE_OF_ASSOCIATED_TEST_CASE.getColumnId()), DSL.select((SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField("MILESTONE_LABELS"), DSL.select((SelectField)DSL.groupConcat((Field)Tables.MILESTONE.STATUS).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator("|")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField("MILESTONE_STATUS"), DSL.select((SelectField)DSL.groupConcat((Field)Tables.MILESTONE.END_DATE).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator("|")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField("MILESTONE_END_DATE"), DSL.countDistinct((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).as("MILESTONES")}).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).leftJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.REQUIREMENT_VERSION.CATEGORY.eq((Field)Tables.INFO_LIST_ITEM.ITEM_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(versionIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.INFO_LIST_ITEM.LABEL, Tables.REQUIREMENT_VERSION.VERSION_NUMBER, Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, Tables.RESOURCE.NAME, Tables.RESOURCE.CREATED_BY, Tables.RESOURCE.LAST_MODIFIED_BY, Tables.RESOURCE.LAST_MODIFIED_ON, Tables.RESOURCE.DESCRIPTION, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.RESOURCE.CREATED_ON, Tables.PROJECT.NAME, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID, Tables.RESOURCE.ATTACHMENT_LIST_ID}).fetchInto(RequirementModelFromJooq.class);
    }
}

