/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.api.repository;

import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class JooqSessionGuard
implements ExecuteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JooqSessionGuard.class);
    private final EntityManagerFactory entityManagerFactory;

    public JooqSessionGuard(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void executeStart(ExecuteContext ctx) {
        Session currentSession;
        LOGGER.trace("Checking Hibernate Session before executing a request through jooq execution pipeline", new Object[0]);
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        if (Objects.nonNull(entityManager) && (currentSession = (Session)entityManager.unwrap(Session.class)).isOpen() && currentSession.isDirty()) {
            LOGGER.debug("Hibernate Session is open and dirty. Will force a flush to prevent stale results of jooq request", new Object[0]);
            currentSession.flush();
        }
    }
}

