/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.spi;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.testautomation.model.IterationTestPlanItemWithCustomFields;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public interface TestAutomationConnector {
    public TestAutomationServerKind getConnectorKind();

    public boolean checkCredentials(TestAutomationServer var1, String var2, String var3) throws TestAutomationException;

    public boolean checkCredentials(TestAutomationServer var1, Credentials var2) throws TestAutomationException;

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer var1, Credentials var2) throws TestAutomationException;

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject var1, String var2) throws TestAutomationException;

    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> var1, String var2);

    public List<AutomatedSuiteWorkflow> executeParameterizedTestsBasedOnITPICollection(Collection<IterationTestPlanItemWithCustomFields> var1, String var2, Collection<SquashAutomExecutionConfiguration> var3);

    public URL findTestAutomationProjectURL(TestAutomationProject var1);

    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> var1);

    default public boolean supports(AuthenticationProtocol mode) {
        return Arrays.asList(this.getSupportedProtocols()).contains(mode);
    }

    public AuthenticationProtocol[] getSupportedProtocols();

    default public boolean supportsAutomatedExecutionEnvironments() {
        return false;
    }

    default public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer server) {
        throw new UnsupportedOperationException();
    }

    default public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer testAutomationServer, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    default public OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfVersions(TestAutomationServer server) {
        throw new UnsupportedOperationException();
    }

    default public OrchestratorResponse<List<WorkflowDto>> getProjectWorkflows(TestAutomationServer server, Long projectId, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    default public OrchestratorResponse<Void> killWorkflow(TestAutomationServer server, Long projectId, TokenAuthCredentials credentials, String workflowId) {
        throw new UnsupportedOperationException();
    }

    default public OrchestratorResponse<String> getWorkflowLogs(TestAutomationServer server, TokenAuthCredentials credentials, String workflowId) {
        throw new UnsupportedOperationException();
    }
}

