/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.spi;

import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.service.spi.GenericServerOAuth2Conf;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;

public class DefaultOAuth2ConfigurationHandler
implements OAuth2ConfigurationHandler {
    private static final String CLIENT_ID_PARAM = "client_id=";
    private static final String REDIRECT_URI_PARAM = "&redirect_uri=";
    private static final String CLIENT_SECRET_PARAM = "&client_secret=";

    @Override
    public String getOauth2AuthenticationUrl(BugTracker bugTracker, GenericServerOAuth2Conf conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(conf.getAuthorizationUrl());
        sb.append("?");
        sb.append(CLIENT_ID_PARAM);
        sb.append(conf.getClientId());
        sb.append(REDIRECT_URI_PARAM);
        sb.append(conf.getCallbackUrl());
        sb.append("&response_type=");
        sb.append(conf.getGrantType());
        this.appendScope(bugTracker.getUrl(), sb, conf);
        return sb.toString();
    }

    @Override
    public void appendScope(String bugTrackerUrl, StringBuilder sb, GenericServerOAuth2Conf conf) {
        sb.append("&scope=");
        sb.append(conf.getScope());
    }

    @Override
    public String getOauth2RequestTokenUrl(Long serverId, String code, GenericServerOAuth2Conf conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(conf.getRequestTokenUrl());
        sb.append("?");
        sb.append(CLIENT_ID_PARAM);
        sb.append(conf.getClientId());
        sb.append(CLIENT_SECRET_PARAM);
        sb.append(conf.getClientSecret());
        sb.append("&code=");
        sb.append(code);
        sb.append("&grant_type=authorization_code");
        sb.append(REDIRECT_URI_PARAM);
        sb.append(conf.getCallbackUrl());
        return sb.toString();
    }

    @Override
    public String getRefreshTokenUrl(GenericServerOAuth2Conf conf, OAuth2Credentials creds) {
        StringBuilder sb = new StringBuilder();
        sb.append(conf.getRequestTokenUrl());
        sb.append("?");
        sb.append(CLIENT_ID_PARAM);
        sb.append(conf.getClientId());
        sb.append(CLIENT_SECRET_PARAM);
        sb.append(conf.getClientSecret());
        sb.append("&refresh_token=");
        sb.append(creds.getRefreshToken());
        sb.append("&grant_type=refresh_token");
        return sb.toString();
    }

    @Override
    public DefaultOAuth2FormValues getDefaultValueForOauth2Form(String bugTrackerUrl) {
        return new DefaultOAuth2FormValues(String.valueOf(bugTrackerUrl) + "/rest/oauth2/latest/authorize", String.valueOf(bugTrackerUrl) + "/rest/oauth2/latest/token", "");
    }
}

