/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security;

import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

public final class PermissionsUtils {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static final String ACCESS_IS_DENIED = "Access is denied";

    private PermissionsUtils() {
    }

    public static void checkPermission(PermissionEvaluationService permissionService, SecurityCheckableObject ... checkableObjects) {
        SecurityCheckableObject[] securityCheckableObjectArray = checkableObjects;
        int n = checkableObjects.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityCheckableObject object = securityCheckableObjectArray[n2];
            if (!permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, object.getPermission(), object.getObject())) {
                throw new AccessDeniedException(ACCESS_IS_DENIED);
            }
            ++n2;
        }
    }

    public static void checkPermission(PermissionEvaluationService permissionService, List<Long> ids, String permission, String entityClassName) {
        if (permissionService.hasRole(ROLE_ADMIN)) {
            return;
        }
        for (Long entityId : ids) {
            if (permissionService.hasPermissionOnObject(permission, entityId, entityClassName)) continue;
            throw new AccessDeniedException(ACCESS_IS_DENIED);
        }
    }

    public static void checkPermission(PermissionEvaluationService permissionService, Collection<?> toCheck, String permission) {
        for (Object o : toCheck) {
            if (permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, o)) continue;
            throw new AccessDeniedException(ACCESS_IS_DENIED);
        }
    }
}

