/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.requirement;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.context.MessageSource;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;

public interface RequirementLibraryNavigationService
extends LibraryNavigationService<RequirementLibrary, RequirementFolder, RequirementLibraryNode>,
RequirementLibraryFinderService {
    public static final String REQUIREMENT_ID = "requirementId";
    public static final String NODE_IDS = "nodeIds";
    public static final String SOURCE_NODES_IDS = "sourceNodesIds";
    public static final String DESTINATION_ID = "destinationId";
    public static final String TARGET_ID = "targetId";
    public static final String TARGET_IDS = "targetIds";

    @Deprecated
    public Requirement addRequirementToRequirementLibrary(@Id long var1, @NotNull Requirement var3, List<Long> var4);

    public Requirement addRequirementToRequirementLibrary(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public Requirement addRequirementToRequirementLibraryUnsecured(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    @Deprecated
    public Requirement addRequirementToRequirementFolder(@Id long var1, @NotNull Requirement var3, List<Long> var4);

    public Requirement addRequirementToRequirementFolder(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public Requirement addRequirementToRequirementFolderUnsecured(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public Requirement addRequirementToRequirement(@Id long var1, @NotNull Requirement var3, List<Long> var4);

    public Requirement addRequirementToHighLevelRequirement(@Id long var1, @NotNull Requirement var3, List<Long> var4);

    public Requirement addRequirementToRequirement(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public Requirement addRequirementToRequirementUnsecured(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public Requirement addRequirementToHighLevelRequirement(@Id long var1, @NotNull NewRequirementVersionDto var3, List<Long> var4);

    public List<Requirement> copyNodesToRequirement(@Id(value="requirementId") long var1, @Ids(value="sourceNodesIds") Long[] var3, ClipboardPayload var4);

    public void moveNodesToRequirement(@Id(value="requirementId") long var1, @Ids(value="nodeIds") Long[] var3, ClipboardPayload var4);

    public void moveNodesToRequirement(@Id(value="requirementId") long var1, @Ids(value="nodeIds") Long[] var3);

    public void moveNodesToRequirement(@Id(value="requirementId") long var1, @Ids(value="nodeIds") Long[] var3, int var4, ClipboardPayload var5);

    public Requirement findRequirement(long var1);

    public List<ExportRequirementData> findRequirementsToExportFromLibrary(@NotNull List<Long> var1);

    public List<ExportRequirementData> findRequirementsToExportFromNodes(@NotNull List<Long> var1);

    public List<Requirement> findChildrenRequirements(long var1);

    public File exportRequirementAsExcel(List<Long> var1, List<Long> var2, boolean var3, MessageSource var4);

    public File exportRequirementAsExcel(List<Long> var1, List<Long> var2, boolean var3, boolean var4, MessageSource var5);

    public File searchExportRequirementAsExcel(List<Long> var1, boolean var2, boolean var3, MessageSource var4, String var5, Boolean var6);

    public ImportLog simulateImportExcelRequirement(File var1);

    public ImportLog importExcelRequirement(File var1);

    public Long mkdirs(String var1);

    public void changeCurrentVersionNumber(Requirement var1, Integer var2);

    public void initCUFvalues(RequirementVersion var1, Map<Long, RawValue> var2);

    public RequirementLibraryNode findRequirementLibraryNodeById(Long var1);

    public List<String> findNamesInNodeStartingWith(long var1, String var3);

    public List<String> findNamesInLibraryStartingWith(long var1, String var3);

    public List<Long> findAllRequirementIdsInMilestone(Milestone var1);

    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void validatePathForSync(String var1, String var2);

    @Override
    public void copyNodesToFolder(@Id(value="destinationId") long var1, @Ids(value="sourceNodesIds") Long[] var3, ClipboardPayload var4);

    @Override
    public void copyNodesToLibrary(@Id(value="destinationId") long var1, @Ids(value="targetId") Long[] var3, ClipboardPayload var4);

    @Override
    public void moveNodesToFolder(@Id(value="destinationId") long var1, @Ids(value="targetId") Long[] var3, ClipboardPayload var4);

    @Override
    public void moveNodesToFolder(@Id(value="destinationId") long var1, @Ids(value="targetId") Long[] var3, int var4, ClipboardPayload var5);

    @Override
    public void moveNodesToLibrary(@Id(value="destinationId") long var1, @Ids(value="targetId") Long[] var3, ClipboardPayload var4);

    @Override
    public void moveNodesToLibrary(@Id(value="destinationId") long var1, @Ids(value="targetId") Long[] var3, int var4, ClipboardPayload var5);

    @Override
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> var1);
}

