/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;

public final class PivotJsonParsingHelper {
    private PivotJsonParsingHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getArrayStringValues(JsonParser jsonParser) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            values.add(jsonParser.getValueAsString());
        }
        return values;
    }

    public static boolean isStartingToParseNewObject(JsonParser jsonParser) {
        return JsonToken.START_OBJECT.equals((Object)jsonParser.getCurrentToken());
    }

    public static boolean isNotTheEndOfParsedObject(JsonParser jsonParser) throws IOException {
        return jsonParser.nextToken() != JsonToken.END_OBJECT;
    }

    public static boolean isStartingToParseNewArray(JsonParser jsonParser) {
        return JsonToken.START_ARRAY.equals((Object)jsonParser.getCurrentToken());
    }

    public static boolean isNotTheEndOfParsedArray(JsonParser jsonParser) throws IOException {
        return jsonParser.nextToken() != JsonToken.END_ARRAY;
    }

    public static Map<Long, RawValue> getCustomFieldValues(JsonParser jsonParser, Map<String, SquashCustomFieldInfo> customFieldIdsMap) throws IOException {
        HashMap<Long, RawValue> customFieldsValues = new HashMap<Long, RawValue>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            PivotJsonParsingHelper.parseCustomFieldValue(jsonParser, customFieldIdsMap, customFieldsValues);
        }
        return customFieldsValues;
    }

    private static void parseCustomFieldValue(JsonParser jsonParser, Map<String, SquashCustomFieldInfo> customFieldIdsMap, Map<Long, RawValue> customFieldsValues) throws IOException {
        String id = null;
        String value = null;
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if ("id".equals(fieldName)) {
                id = jsonParser.getText();
                continue;
            }
            if (!"value".equals(fieldName)) continue;
            value = jsonParser.getValueAsString();
        }
        SquashCustomFieldInfo customFieldInfo = customFieldIdsMap.get(id);
        if (InputType.TAG.equals((Object)customFieldInfo.inputType())) {
            ArrayList tagValues = Objects.nonNull(value) ? Arrays.stream(value.split("\\|")).toList() : new ArrayList();
            customFieldsValues.put(customFieldInfo.id(), new RawValue(tagValues));
        } else {
            customFieldsValues.put(customFieldInfo.id(), new RawValue(value));
        }
    }
}

