/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public final class JSONUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONUtils.class);
    private static final ObjectMapper objMapper = new ObjectMapper();

    private JSONUtils() {
    }

    public static String getValueFromKey(String json, String key) {
        try {
            JsonNode node = objMapper.readTree(json);
            JsonNode valueNode = node.get(key);
            return Objects.isNull(valueNode) ? "" : valueNode.asText();
        }
        catch (JsonProcessingException e) {
            LOGGER.debug("Could not transform {} in JSON", new Object[]{json, e});
            return null;
        }
    }
}

