/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseFinder;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseService;
import org.squashtest.tm.service.testcase.scripted.KeywordTestCaseToFileStrategy;

@Service
@Transactional
public class KeywordTestCaseServiceImpl
implements KeywordTestCaseService {
    @Inject
    private MessageSource messageSource;
    @Inject
    private KeywordTestCaseFinder keywordTestCaseFinder;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public String createFileName(KeywordTestCase keywordTestCase) {
        return this.getKeywordTestCaseToFileStrategy(keywordTestCase).createFilenameFor(keywordTestCase);
    }

    @Override
    public String createBackupFileName(KeywordTestCase keywordTestCase) {
        return this.getKeywordTestCaseToFileStrategy(keywordTestCase).backupFilenameFor(keywordTestCase);
    }

    @Override
    public String buildFilenameMatchPattern(KeywordTestCase keywordTestCase) {
        return this.getKeywordTestCaseToFileStrategy(keywordTestCase).buildFilenameMatchPattern(keywordTestCase);
    }

    @Override
    public String writeScriptFromTestCase(long keywordTestCaseId, boolean escapeArrows) {
        KeywordTestCase keywordTestCase = this.keywordTestCaseFinder.findById(keywordTestCaseId);
        Project project = keywordTestCase.getProject();
        BddImplementationTechnology bddImplementationTechnology = project.getBddImplementationTechnology();
        KeywordTestCaseToFileStrategy strategy = KeywordTestCaseToFileStrategy.strategyFor(bddImplementationTechnology);
        return strategy.getWritableFileContent(keywordTestCase, this.messageSource, escapeArrows);
    }

    private KeywordTestCaseToFileStrategy getKeywordTestCaseToFileStrategy(KeywordTestCase keywordTestCase) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)keywordTestCase.getProject().getId());
        BddImplementationTechnology bddImplementationTechnology = project.getBddImplementationTechnology();
        return KeywordTestCaseToFileStrategy.strategyFor(bddImplementationTechnology);
    }
}

