/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.InconsistentInfoListItemException;
import org.squashtest.tm.exception.library.NameAlreadyExistsAtDestinationException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibrary;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.XlsImportLimitationHandler;
import org.squashtest.tm.service.internal.batchexport.TestCaseExcelExporterService;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.TestCaseExcelBatchImporter;
import org.squashtest.tm.service.internal.batchimport.TestCaseFolderImportData;
import org.squashtest.tm.service.internal.batchimport.TestCaseImportData;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.customreport.NameResolver;
import org.squashtest.tm.service.internal.library.AbstractLibraryNavigationService;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.KeywordTestCaseDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ScriptedTestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.internal.testcase.TestCaseLibraryNavigationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testcase.TestCaseLibraryNavigationServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.testcase.coercers.TCLNAndParentIdsCoercerForArray;
import org.squashtest.tm.service.internal.testcase.coercers.TCLNAndParentIdsCoercerForList;
import org.squashtest.tm.service.internal.testcase.coercers.TestCaseLibraryIdsCoercerForArray;
import org.squashtest.tm.service.internal.testcase.coercers.TestCaseLibraryIdsCoercerForList;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatisticsBundle;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseStatisticsService;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;
import org.squashtest.tm.service.testcase.scripted.KeywordTestCaseToFileStrategy;

@Service(value="squashtest.tm.service.TestCaseLibraryNavigationService")
@Transactional
public class TestCaseLibraryNavigationServiceImpl
extends AbstractLibraryNavigationService<org.squashtest.tm.domain.testcase.TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode>
implements TestCaseLibraryNavigationService {
    private static final Logger LOGGER;
    private static final String EXPORT = "EXPORT";
    private static final String TEST_CASE_CLASS_NAME = "org.squashtest.tm.domain.testcase.TestCase";
    private static final String DESTINATION_ID = "destinationId";
    private static final String SOURCE_NODES_IDS = "sourceNodesIds";
    private static final String TARGET_ID = "targetId";
    private static final String TARGET_IDS = "targetIds";
    private static final String SIMPLE = "simple";
    private static final String EXTENSION_DELIMITER = ".";
    @Inject
    private TestCaseLibraryDao testCaseLibraryDao;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private TestCaseLibraryNodeDao testCaseLibraryNodeDao;
    @Inject
    private ScriptedTestCaseDao scriptedTestCaseDao;
    @Inject
    private KeywordTestCaseDao keywordTestCaseDao;
    @Inject
    private TestCaseNodeDeletionHandler deletionHandler;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToTestCaseFolderStrategy")
    private Provider<PasteStrategy<TestCaseFolder, TestCaseLibraryNode>> pasteToTestCaseFolderStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToTestCaseLibraryStrategy")
    private Provider<PasteStrategy<org.squashtest.tm.domain.testcase.TestCaseLibrary, TestCaseLibraryNode>> pasteToTestCaseLibraryStrategyProvider;
    @Inject
    private TestCaseStatisticsService statisticsService;
    @Inject
    private TestCaseCallTreeFinder calltreeService;
    @Inject
    private TestCaseExcelExporterService excelService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private TestCaseExcelBatchImporter batchImporter;
    @Inject
    private PathService pathService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private DSLContext dsl;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private NameResolver nameResolver;
    @Inject
    private MessageSource messageSource;
    @Inject
    private XlsImportLimitationHandler xlsImportLimitationHandler;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        TestCaseLibraryNavigationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TestCaseLibraryNavigationServiceImpl.class);
    }

    @Override
    protected NodeDeletionHandler<TestCaseLibraryNode, TestCaseFolder> getDeletionHandler() {
        return this.deletionHandler;
    }

    @Override
    protected LibraryDao<org.squashtest.tm.domain.testcase.TestCaseLibrary, TestCaseLibraryNode> getLibraryDao() {
        return this.testCaseLibraryDao;
    }

    @Override
    protected FolderDao<TestCaseFolder, TestCaseLibraryNode> getFolderDao() {
        return this.testCaseFolderDao;
    }

    protected TestCaseLibraryNodeDao getLibraryNodeDao() {
        return this.testCaseLibraryNodeDao;
    }

    @Override
    protected PasteStrategy<TestCaseFolder, TestCaseLibraryNode> getPasteToFolderStrategy() {
        return (PasteStrategy)this.pasteToTestCaseFolderStrategyProvider.get();
    }

    @Override
    protected PasteStrategy<org.squashtest.tm.domain.testcase.TestCaseLibrary, TestCaseLibraryNode> getPasteToLibraryStrategy() {
        return (PasteStrategy)this.pasteToTestCaseLibraryStrategyProvider.get();
    }

    @Override
    @Transactional(readOnly=true)
    public String getPathAsString(long entityId) {
        return this.pathService.buildTestCasePath(entityId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getPathsAsString(List<Long> ids) {
        return this.pathService.buildTestCasesPaths(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TestCaseLibraryNode> findNodesByPath(List<String> paths) {
        return this.getLibraryNodeDao().findNodesByPath(paths);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> findNodeIdsByPath(List<String> paths) {
        return this.getLibraryNodeDao().findNodeIdsByPath(paths);
    }

    @Override
    @Transactional(readOnly=true)
    public Long findNodeIdByPath(String path) {
        return this.getLibraryNodeDao().findNodeIdByPath(path);
    }

    @Override
    @Transactional(readOnly=true)
    public TestCaseLibraryNode findNodeByPath(String path) {
        return this.getLibraryNodeDao().findNodeByPath(path);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public TestCaseFolder addFolderToLibrary(@Id long destinationId, TestCaseFolder newFolder) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary container = this.getLibraryDao().findById(destinationId);
        container.addContent((LibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.generateCustomField(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public TestCaseFolder addFolderToLibrary(@Id long destinationId, NewFolderDto folderDto) {
        TestCaseFolder newFolder = (TestCaseFolder)folderDto.toFolder(EntityType.TEST_CASE_FOLDER);
        return this.addFolderToLibrary(destinationId, newFolder, folderDto.getCustomFields());
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    public TestCaseFolder addFolderToFolder(@Id long destinationId, TestCaseFolder newFolder) {
        TestCaseFolder container = (TestCaseFolder)this.getFolderDao().findById(destinationId);
        container.addContent((TestCaseLibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.generateCustomField(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    public TestCaseFolder addFolderToFolder(@Id long destinationId, NewFolderDto folderDto) {
        TestCaseFolder newFolder = (TestCaseFolder)folderDto.toFolder(EntityType.TEST_CASE_FOLDER);
        return this.addFolderToFolder(destinationId, newFolder, folderDto.getCustomFields());
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public void addTestCaseToLibrary(@Id long libraryId, TestCase testCase, Integer position) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary library = (org.squashtest.tm.domain.testcase.TestCaseLibrary)this.testCaseLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(testCase.getName())) {
            throw new DuplicateNameException(testCase.getName(), testCase.getName(), testCase.getName());
        }
        if (position != null) {
            library.addContent((LibraryNode)testCase, position.intValue());
        } else {
            library.addContent((LibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.createCustomFieldValuesForTestCase(testCase);
    }

    private void replaceInfoListReferences(Collection<TestCase> testCases, GenericProject project) {
        TestCaseLibraryNavigationServiceImpl.replaceNatureInfoListReferences(testCases, project.getTestCaseNatures());
        this.replaceTypeInfoListReferences(testCases, project.getTestCaseTypes());
    }

    private static void replaceNatureInfoListReferences(Collection<TestCase> testCases, InfoList projectNatures) {
        for (TestCase testCase : testCases) {
            TestCaseLibraryNavigationServiceImpl.replaceNatureInfoListReference(projectNatures, testCase);
        }
    }

    private static void replaceNatureInfoListReference(InfoList projectNatures, TestCase testCase) {
        InfoListItem nature = testCase.getNature();
        if (nature == null) {
            testCase.setNature(projectNatures.getDefaultItem());
        } else {
            InfoListItem persistedItem;
            if (nature instanceof ListItemReference && Objects.nonNull(persistedItem = projectNatures.getItem(nature))) {
                testCase.setNature(projectNatures.getItem(nature));
            }
            if (!projectNatures.contains(nature)) {
                throw new InconsistentInfoListItemException("nature", nature.getCode());
            }
        }
    }

    private void replaceTypeInfoListReferences(Collection<TestCase> testCases, InfoList projectType) {
        for (TestCase testCase : testCases) {
            TestCaseLibraryNavigationServiceImpl.replaceTypeInfoListReference(projectType, testCase);
        }
    }

    private static void replaceTypeInfoListReference(InfoList projectType, TestCase testCase) {
        InfoListItem persistedItem;
        InfoListItem type = testCase.getType();
        if (type == null) {
            testCase.setType(projectType.getDefaultItem());
            return;
        }
        if (type instanceof ListItemReference && Objects.nonNull(persistedItem = projectType.getItem(type))) {
            testCase.setType(projectType.getItem(type));
            return;
        }
        if (!projectType.contains(type)) {
            throw new InconsistentInfoListItemException("type", type.getCode());
        }
    }

    @Override
    public void addFromReqTestCaseToLibrary(@Id long libraryId, TestCase testCase, RequirementVersion version, Integer position) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary library = (org.squashtest.tm.domain.testcase.TestCaseLibrary)this.testCaseLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(testCase.getName())) {
            this.resolveNameConflict(library.getContentNames(), (TestCaseLibraryNode)testCase, 1);
        }
        if (position != null) {
            library.addContent((LibraryNode)testCase, position.intValue());
        } else {
            library.addContent((LibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.addCurrentMilestone(testCase);
        this.verifiedRequirementsManagerService.addVerifiedRequirementVersionsToTestCaseFromReq(version, testCase);
        this.copyAttachmentsFromLibraryNode((LibraryNode)testCase, version.getAttachmentList().getId());
    }

    private void addCurrentMilestone(TestCase testCase) {
        this.activeMilestoneHolder.getActiveMilestone().ifPresent(milestone -> this.milestoneService.bindTestCaseToMilestones(testCase.getId(), Collections.singletonList(milestone.getId())));
    }

    @Override
    public void addFromReqFolderToLibrary(@Id long destinationId, TestCaseFolder newFolder, Long copiedAttachmentListId) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary container = this.getLibraryDao().findById(destinationId);
        if (container.getContentNames().contains(newFolder.getName())) {
            this.resolveNameConflict(container.getContentNames(), (TestCaseLibraryNode)newFolder, 1);
        }
        container.addContent((LibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.copyAttachmentsFromLibraryNode((LibraryNode)newFolder, copiedAttachmentListId);
        this.generateCustomField(newFolder);
    }

    void resolveNameConflict(List<String> target, TestCaseLibraryNode node, int i) {
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        String testedName = String.valueOf(node.getName()) + copySuffix + i;
        if (target.contains(testedName)) {
            this.resolveNameConflict(target, node, i + 1);
        } else {
            node.setName(testedName);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public TestCase addTestCaseToLibrary(@Id long libraryId, TestCase testCase, Map<Long, RawValue> customFieldValues, Integer position, List<Long> milestoneIds) {
        return this.addTestCaseToLibraryUnsecured(libraryId, testCase, customFieldValues, position, milestoneIds);
    }

    @Override
    public TestCase addTestCaseToLibraryUnsecured(@Id long libraryId, TestCase testCase, Map<Long, RawValue> customFieldValues, Integer position, List<Long> milestoneIds) {
        this.addTestCaseToLibrary(libraryId, testCase, position);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)testCase, customFieldValues);
        this.createAttachmentsFromLibraryNode((LibraryNode)testCase, (BoundEntity)testCase);
        this.milestoneService.bindTestCaseToMilestones(testCase.getId(), milestoneIds);
        return testCase;
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    public void addTestCaseToFolder(@Id long folderId, TestCase testCase, Integer position) {
        TestCaseFolder folder = (TestCaseFolder)this.testCaseFolderDao.findById(folderId);
        if (!folder.isContentNameAvailable(testCase.getName())) {
            throw new DuplicateNameException(testCase.getName(), testCase.getName());
        }
        if (position != null) {
            folder.addContent((TestCaseLibraryNode)testCase, position.intValue());
        } else {
            folder.addContent((TestCaseLibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.createCustomFieldValuesForTestCase(testCase);
    }

    @Override
    public void addFromReqTestCaseToFolder(@Id long folderId, TestCase testCase, RequirementVersion version, Integer position) {
        TestCaseFolder folder = (TestCaseFolder)this.testCaseFolderDao.findById(folderId);
        if (!folder.isContentNameAvailable(testCase.getName())) {
            this.resolveNameConflict(folder.getContentNames(), (TestCaseLibraryNode)testCase, 1);
        }
        if (position != null) {
            folder.addContent((TestCaseLibraryNode)testCase, position.intValue());
        } else {
            folder.addContent((TestCaseLibraryNode)testCase);
        }
        this.replaceInfoListReferences(testCase);
        this.testCaseDao.safePersist(testCase);
        this.addCurrentMilestone(testCase);
        this.copyAttachmentsFromLibraryNode((LibraryNode)testCase, version.getAttachmentList().getId());
        this.verifiedRequirementsManagerService.addVerifiedRequirementVersionsToTestCaseFromReq(version, testCase);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    public TestCase addTestCaseToFolder(@Id long folderId, TestCase testCase, Map<Long, RawValue> customFieldValues, Integer position, List<Long> milestoneIds) {
        return this.addTestCaseToFolderUnsecured(folderId, testCase, customFieldValues, position, milestoneIds);
    }

    @Override
    public TestCase addTestCaseToFolderUnsecured(@Id long folderId, TestCase testCase, Map<Long, RawValue> customFieldValues, Integer position, List<Long> milestoneIds) {
        this.addTestCaseToFolder(folderId, testCase, position);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)testCase, customFieldValues);
        this.createAttachmentsFromLibraryNode((LibraryNode)testCase, (BoundEntity)testCase);
        this.milestoneService.bindTestCaseToMilestones(testCase.getId(), milestoneIds);
        return testCase;
    }

    @Override
    public void addReqFolderToTcFolder(@Id long destinationId, TestCaseFolder newFolder, Long copiedAttachmentListId) {
        TestCaseFolder container = (TestCaseFolder)this.getFolderDao().findById(destinationId);
        if (container.getContentNames().contains(newFolder.getName())) {
            this.resolveNameConflict(container.getContentNames(), (TestCaseLibraryNode)newFolder, 1);
        }
        container.addContent((TestCaseLibraryNode)newFolder);
        new NatureTypeChainFixer().fix(newFolder);
        this.getFolderDao().persist(newFolder);
        new CustomFieldValuesFixer().fix(newFolder);
        this.copyAttachmentsFromLibraryNode((LibraryNode)newFolder, copiedAttachmentListId);
        this.generateCustomField(newFolder);
    }

    @Override
    public Long mkdirs(String folderpath) {
        TestCaseFolder foldertree;
        String path = folderpath.replaceFirst("^/", "").replaceFirst("/$", "");
        StringBuilder buffer = new StringBuilder();
        String[] split = path.split("(?<!\\\\)/");
        ArrayList<String> paths = new ArrayList<String>(split.length - 1);
        buffer.append("/").append(split[0]);
        int i = 1;
        while (i < split.length) {
            buffer.append("/");
            buffer.append(split[i]);
            paths.add(buffer.toString());
            ++i;
        }
        List<Long> foundIds = this.findNodeIdsByPath(paths);
        int nullIdx = foundIds.indexOf(null);
        switch (nullIdx) {
            case -1: {
                return foundIds.get(foundIds.size() - 1);
            }
            case 0: {
                Long libraryId = this.projectDao.findByName(split[0].replace("\\/", "/")).getTestCaseLibrary().getId();
                foldertree = this.mkTransFolders(1, split);
                this.addFolderToLibrary((long)libraryId, foldertree);
                break;
            }
            default: {
                Long parentFolder = foundIds.get(nullIdx - 1);
                foldertree = this.mkTransFolders(nullIdx + 1, split);
                this.addFolderToFolder((long)parentFolder, foldertree);
            }
        }
        TestCaseFolder lastFolder = foldertree;
        do {
            if (!lastFolder.hasContent()) continue;
            lastFolder = (TestCaseFolder)lastFolder.getContent().get(0);
        } while (lastFolder.hasContent());
        return lastFolder.getId();
    }

    private TestCaseFolder mkTransFolders(int startIndex, String[] names) {
        TestCaseFolder baseFolder = null;
        TestCaseFolder currentParent = null;
        int i = startIndex;
        while (i < names.length) {
            TestCaseFolder currentChild = new TestCaseFolder();
            currentChild.setName(names[i].replace("\\/", "/"));
            currentChild.setDescription("");
            if (baseFolder == null) {
                baseFolder = currentChild;
            } else {
                currentParent.addContent((TestCaseLibraryNode)currentChild);
            }
            currentParent = currentChild;
            ++i;
        }
        return baseFolder;
    }

    @Override
    public ImportLog simulateImportExcelTestCase(File excelFile) {
        this.xlsImportLimitationHandler.checkMaxNumberOfTestCasesInsideXlsFile(excelFile);
        this.xlsImportLimitationHandler.checkMaxNumberOfTestStepsInsideXlsFile(excelFile);
        return this.batchImporter.simulateImport(excelFile);
    }

    @Override
    public ImportLog performImportExcelTestCase(File excelFile) {
        try {
            this.xlsImportLimitationHandler.incrementImportProcessCounter();
            this.xlsImportLimitationHandler.checkMaxNumberOfTestCasesInsideXlsFile(excelFile);
            this.xlsImportLimitationHandler.checkMaxNumberOfTestStepsInsideXlsFile(excelFile);
            this.xlsImportLimitationHandler.checkIfImportSlotIsAvailable();
            ImportLog importLog = this.batchImporter.performImport(excelFile);
            return importLog;
        }
        finally {
            this.xlsImportLimitationHandler.decrementImportProcessCounter();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public File exportTestCaseAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean includeCalledTests, boolean keepRteFormat, MessageSource messageSource) {
        Collection<Long> allIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds, includeCalledTests);
        allIds = this.securityFilterIds(allIds, TEST_CASE_CLASS_NAME, EXPORT);
        return this.excelService.exportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource);
    }

    @Override
    @Transactional(readOnly=true)
    public File exportGherkinTestCaseAsFeatureFiles(List<Long> libraryIds, List<Long> nodeIds, MessageSource messageSource) {
        Collection<Long> ids = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        return this.doGherkinExport(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public File exportKeywordTestCaseAsScriptFiles(List<Long> libraryIds, List<Long> nodeIds, MessageSource messageSource) {
        Collection<Long> ids = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        return this.doKeywordExport(ids, messageSource);
    }

    private File doGherkinExport(Collection<Long> ids) {
        List scriptedTestCases = this.scriptedTestCaseDao.findAllById(ids);
        FileOutputStream fileOutputStream = null;
        try {
            File zipFile = File.createTempFile("export-feature-", ".zip");
            fileOutputStream = new FileOutputStream(zipFile);
            zipFile.deleteOnExit();
            ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fileOutputStream);
            for (ScriptedTestCase scriptedTestCase : scriptedTestCases) {
                String name = "tc_" + scriptedTestCase.getId();
                ZipArchiveEntry entry = new ZipArchiveEntry(String.valueOf(name) + ".feature");
                archive.putArchiveEntry((ArchiveEntry)entry);
                archive.write(scriptedTestCase.getScript().getBytes(Charset.forName("UTF-8")));
                archive.closeArchiveEntry();
            }
            archive.close();
            File file = zipFile;
            return file;
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close FileOutputStream: ", (Throwable)e);
                }
            }
        }
    }

    private File doKeywordExport(Collection<Long> ids, MessageSource messageSource) {
        List keywordTestCases = this.keywordTestCaseDao.findAllById(ids);
        FileOutputStream fileOutputStream = null;
        try {
            File zipFile = File.createTempFile("export-keyword-", ".zip");
            fileOutputStream = new FileOutputStream(zipFile);
            zipFile.deleteOnExit();
            ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fileOutputStream);
            for (KeywordTestCase keywordTestCase : keywordTestCases) {
                String name = "tc_" + keywordTestCase.getId();
                BddImplementationTechnology technology = keywordTestCase.getProject().getBddImplementationTechnology();
                KeywordTestCaseToFileStrategy strategy = KeywordTestCaseToFileStrategy.strategyFor(technology);
                String extension = strategy.getExtension();
                ZipArchiveEntry entry = new ZipArchiveEntry(String.join((CharSequence)EXTENSION_DELIMITER, name, extension));
                archive.putArchiveEntry((ArchiveEntry)entry);
                archive.write(strategy.getWritableFileContent(keywordTestCase, messageSource, false).getBytes(Charset.forName("UTF-8")));
                archive.closeArchiveEntry();
            }
            archive.close();
            File file = zipFile;
            return file;
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close FileOutputStream: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public File searchExportTestCaseAsExcel(List<Long> nodeIds, boolean includeCalledTests, boolean keepRteFormat, MessageSource messageSource, String type, Boolean simplifiedColumnDisplayForTest) {
        Collection<Long> allIds = this.findTestCaseIdsFromSelection(CollectionUtils.EMPTY_COLLECTION, nodeIds, includeCalledTests);
        allIds = this.securityFilterIds(allIds, TEST_CASE_CLASS_NAME, EXPORT);
        File file = type.equals(SIMPLE) ? this.excelService.searchSimpleExportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource, simplifiedColumnDisplayForTest) : this.excelService.searchExportAsExcel(new ArrayList<Long>(allIds), keepRteFormat, messageSource);
        return file;
    }

    @Override
    public TestCaseStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        Collection<Long> tcIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            tcIds = this.filterTcIdsListsByMilestone(tcIds, activeMilestone.get());
        }
        return this.statisticsService.gatherTestCaseStatisticsBundle(tcIds);
    }

    @Override
    public Collection<Long> findTestCaseIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        Set<Long> readLibIds = this.securityFilterIds(libraryIds, org.squashtest.tm.domain.testcase.TestCaseLibrary.class.getName(), "READ");
        Set<Long> readNodeIds = this.securityFilterIds(nodeIds, TestCaseLibraryNode.class.getName(), "READ");
        HashSet<Long> tcIds = new HashSet<Long>();
        if (!readLibIds.isEmpty()) {
            Set<Long> set = readLibIds;
            TestCaseDao testCaseDao = this.testCaseDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseDao, set);
            Object[] objectArray = new Object[]{this, testCaseDao, set, joinPoint};
            TestCaseLibraryNavigationServiceImpl$AjcClosure1 testCaseLibraryNavigationServiceImpl$AjcClosure1 = new TestCaseLibraryNavigationServiceImpl$AjcClosure1(objectArray);
            tcIds.addAll((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseLibraryNavigationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        }
        if (!readNodeIds.isEmpty()) {
            tcIds.addAll(this.testCaseDao.findAllTestCaseIdsByNodeIds(readNodeIds));
        }
        return tcIds;
    }

    @Override
    public Collection<Long> findTestCaseIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean includeCalledTests) {
        Collection<Long> tcIds = this.findTestCaseIdsFromSelection(libraryIds, nodeIds);
        if (includeCalledTests) {
            Set<Long> called = this.calltreeService.getTestCaseCallTree(tcIds);
            called = this.securityFilterIds(called, TEST_CASE_CLASS_NAME, "READ");
            tcIds.addAll(called);
        }
        return tcIds;
    }

    @Override
    public int countSiblingsOfNode(long nodeId) {
        return this.testCaseLibraryNodeDao.countSiblingsOfNode(nodeId);
    }

    private void createCustomFieldValuesForTestCase(TestCase testCase) {
        this.createCustomFieldValues((BoundEntity)testCase);
        if (!testCase.getSteps().isEmpty()) {
            this.createCustomFieldValues(testCase.getActionSteps());
        }
    }

    private void replaceInfoListReferences(TestCase testCase) {
        TestCaseLibraryNavigationServiceImpl.replaceNatureInfoListReferences(testCase);
        TestCaseLibraryNavigationServiceImpl.replaceTypeInfoListReferences(testCase);
    }

    private static void replaceNatureInfoListReferences(TestCase testCase) {
        InfoList projectNatures = testCase.getProject().getTestCaseNatures();
        TestCaseLibraryNavigationServiceImpl.replaceNatureInfoListReference(projectNatures, testCase);
    }

    private static void replaceTypeInfoListReferences(TestCase testCase) {
        InfoList projectTypes = testCase.getProject().getTestCaseTypes();
        TestCaseLibraryNavigationServiceImpl.replaceTypeInfoListReference(projectTypes, testCase);
    }

    @Override
    public List<Long> findAllTestCasesLibraryNodeForMilestone(Milestone activeMilestone) {
        if (activeMilestone != null) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(activeMilestone.getId());
            ArrayList<Long> arrayList = milestoneIds;
            TestCaseDao testCaseDao = this.testCaseDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testCaseDao, arrayList);
            Object[] objectArray = new Object[]{this, testCaseDao, arrayList, joinPoint};
            TestCaseLibraryNavigationServiceImpl$AjcClosure3 testCaseLibraryNavigationServiceImpl$AjcClosure3 = new TestCaseLibraryNavigationServiceImpl$AjcClosure3(objectArray);
            return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseLibraryNavigationServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        }
        return new ArrayList<Long>();
    }

    private Collection<Long> filterTcIdsListsByMilestone(Collection<Long> tcIds, Milestone activeMilestone) {
        List<Long> tcInMilestone = this.findAllTestCasesLibraryNodeForMilestone(activeMilestone);
        return CollectionUtils.retainAll(tcIds, tcInMilestone);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="sourceNodesIds", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="sourceNodesIds", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void copyNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        super.copyNodesToFolder(destinationId, sourceNodesIds, clipboardPayload);
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibraryNode.class)
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void copyReqToTestCasesToFolder(@Id long destinationId, Long[] sourceNodesIds, ReqToTestCaseConfiguration configuration) {
        if (sourceNodesIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<TestCaseFolder, TestCaseLibraryNode> pasteStrategy = this.getPasteToFolderStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteReqToTestCasesNodes(destinationId, Arrays.asList(sourceNodesIds), configuration);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void copyNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.copyNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public void copyReqToTestCasesToLibrary(@Id long destinationId, Long[] targetId, ReqToTestCaseConfiguration configuration) {
        if (targetId.length == 0) {
            return;
        }
        try {
            PasteStrategy<org.squashtest.tm.domain.testcase.TestCaseLibrary, TestCaseLibraryNode> pasteStrategy = this.getPasteToLibraryStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteReqToTestCasesNodes(destinationId, Arrays.asList(targetId), configuration);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void copyReqToTestCasesToTestCases(long destinationId, Long[] targetId, ReqToTestCaseConfiguration configuration) {
        TestCaseFolder folder = (TestCaseFolder)this.findParentIfExists(destinationId);
        if (folder == null) {
            Long tclId = (Long)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY.TCL_ID).from((TableLike)TestCaseLibrary.TEST_CASE_LIBRARY).join((TableLike)Tables.PROJECT).using(new Field[]{Tables.TEST_CASE_LIBRARY.TCL_ID}).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).using(new Field[]{Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID}).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.equal((Object)destinationId)).fetchOne((Field)Tables.TEST_CASE_LIBRARY.TCL_ID);
            this.copyReqToTestCasesToLibrary(tclId, targetId, configuration);
        } else {
            this.copyReqToTestCasesToFolder(folder.getId(), targetId, configuration);
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId, int position) {
        super.moveNodesToLibrary(destinationId, targetId, position, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId) {
        super.moveNodesToLibrary(destinationId, targetId, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetId", coercer=TCLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetId", coercer=TestCaseLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(batchsLocks={@BatchPreventConcurrent(entityType=TestCaseLibraryNode.class, paramName="targetIds", coercer=TCLNAndParentIdsCoercerForList.class), @BatchPreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class, paramName="targetIds", coercer=TestCaseLibraryIdsCoercerForList.class)})
    @CheckBlockingMilestones(entityType=TestCase.class)
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> targetIds) {
        return super.deleteNodes(targetIds);
    }

    private void generateCustomField(TestCaseFolder newFolder) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId(), BindableEntity.TESTCASE_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customFieldValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @Override
    public TreeMap<String, Long> buildTestCasePathsTree(String projectName) {
        return this.getLibraryNodeDao().buildNodePathsTree(projectName);
    }

    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.testCaseLibraryDao.findContentNamesByLibraryId(libraryId);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByFolderIds(Collection<Long> folderIds) {
        return this.testCaseFolderDao.findContentNamesByFolderIds(folderIds);
    }

    @Override
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public void addImportTestCasesToLibrary(@Id Long libraryId, Project project, Batch<TestCaseImportData> batch) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary library = this.testCaseLibraryDao.loadForTestCaseAddition(libraryId);
        this.addBatchTestCasesToLibrary(batch.getEntities(), library, project);
        List<TestCaseImportData> importDataList = batch.getEntities();
        this.initializeCustomFieldValues(importDataList, project);
        this.initializeMilestoneBindings(importDataList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addBatchTestCasesToLibrary(List<TestCaseImportData> importedTestCases, org.squashtest.tm.domain.testcase.TestCaseLibrary library, Project project) {
        for (TestCaseImportData importedTestCase : importedTestCases) {
            Integer position = importedTestCase.getPosition();
            TestCase tc2 = importedTestCase.getTestCase();
            if (position != null) {
                library.addContent((LibraryNode)tc2, position.intValue());
                continue;
            }
            library.addContent((LibraryNode)tc2);
        }
        List<TestCase> testCases = importedTestCases.stream().map(TestCaseImportData::getTestCase).toList();
        this.replaceInfoListReferences(testCases, (GenericProject)project);
        testCases.forEach(tc -> this.testCaseDao.safePersist((TestCase)tc));
    }

    @Override
    @BatchPreventConcurrent(entityType=TestCaseFolder.class)
    public void addImportTestCasesToFolders(@Ids List<Long> folderIds, Project project, List<Batch<TestCaseImportData>> batchList) {
        Map testCaseFolderById = this.testCaseFolderDao.loadForTestCaseAddition(folderIds).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        for (Batch<TestCaseImportData> batch : batchList) {
            TestCaseFolder folder = (TestCaseFolder)testCaseFolderById.get(batch.getTargetId());
            this.addBatchTestCaseToFolder(batch.getEntities(), folder);
        }
        List<TestCaseImportData> importDataList = batchList.stream().flatMap(a -> a.getEntities().stream()).toList();
        this.initializeCustomFieldValues(importDataList, project);
        this.initializeMilestoneBindings(importDataList);
        this.addAutomationRequestOnProject(importDataList, project);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addAutomationRequestOnProject(List<TestCaseImportData> importDataList, Project project) {
        importDataList.stream().map(TestCaseImportData::getAutomationRequest).filter(Objects::nonNull).forEach(automationRequest -> project.getAutomationRequestLibrary().addContent(automationRequest));
    }

    private void initializeCustomFieldValues(List<TestCaseImportData> testCasesData, Project project) {
        List<TestCase> testCases = testCasesData.stream().map(TestCaseImportData::getTestCase).toList();
        this.createBatchCustomFieldValues(testCases, project);
        Map<TestCase, Map> testCaseCustomFields = testCasesData.stream().filter(data -> !data.getCustomFields().isEmpty()).collect(Collectors.toMap(TestCaseImportData::getTestCase, TestCaseImportData::getCustomFields));
        this.customFieldValueService.initBatchCustomFieldValues(testCaseCustomFields);
    }

    private void initializeMilestoneBindings(List<TestCaseImportData> testCasesData) {
        Map<TestCase, List> testCaseMilestones = testCasesData.stream().filter(data -> !data.getMilestoneIds().isEmpty()).collect(Collectors.toMap(TestCaseImportData::getTestCase, TestCaseImportData::getMilestoneIds));
        this.milestoneService.bindHoldersToMilestones(testCaseMilestones);
    }

    private void addBatchTestCaseToFolder(List<TestCaseImportData> importTestCases, TestCaseFolder folder) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        for (TestCaseImportData importedTestCase : importTestCases) {
            TestCase tc2 = importedTestCase.getTestCase();
            Integer position = importedTestCase.getPosition();
            if (position != null) {
                folder.addContent((TestCaseLibraryNode)tc2, position.intValue());
            } else {
                folder.addContent((TestCaseLibraryNode)tc2);
            }
            testCases.add(tc2);
        }
        this.replaceInfoListReferences(testCases, (GenericProject)folder.getProject());
        testCases.forEach(tc -> this.testCaseDao.safePersist((TestCase)tc));
    }

    @Override
    @BatchPreventConcurrent(entityType=TestCaseFolder.class)
    public void addImportFoldersToFolders(@Ids List<Long> folderIds, List<Batch<TestCaseFolderImportData>> batchList) {
        Map testCaseFolderById = this.testCaseFolderDao.loadForTestCaseAddition(folderIds).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        for (Batch<TestCaseFolderImportData> batch2 : batchList) {
            TestCaseFolder target = (TestCaseFolder)testCaseFolderById.get(batch2.getTargetId());
            for (TestCaseFolderImportData folderImportData : batch2.getEntities()) {
                TestCaseFolder folder = folderImportData.mainFolder();
                target.addContent((TestCaseLibraryNode)folder);
                new NatureTypeChainFixer().fix(folder);
                this.testCaseFolderDao.persist(folder);
            }
        }
        List<TestCaseFolder> folders = batchList.stream().flatMap(batch -> batch.getEntities().stream()).map(TestCaseFolderImportData::mainFolder).toList();
        Project project = ((TestCaseFolder)testCaseFolderById.values().iterator().next()).getProject();
        this.batchFolderCustomFieldInitialization(folders, project.getId());
        List<TestCaseImportData> importDataList = batchList.stream().flatMap(batch -> batch.getEntities().stream()).flatMap(data -> data.testCaseDataInNodes().stream()).toList();
        this.initializeCustomFieldValues(importDataList, project);
        this.initializeMilestoneBindings(importDataList);
        this.addAutomationRequestOnProject(importDataList, project);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public void addImportFoldersToLibrary(@Id Long testCaseLibraryId, Batch<TestCaseFolderImportData> libraryFolders) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary library = this.testCaseLibraryDao.loadForTestCaseAddition(testCaseLibraryId);
        List<TestCaseFolder> folders = libraryFolders.getEntities().stream().map(TestCaseFolderImportData::mainFolder).toList();
        for (TestCaseFolder folder : folders) {
            library.addContent((LibraryNode)folder);
            new NatureTypeChainFixer().fix(folder);
            this.testCaseFolderDao.persist(folder);
        }
        this.batchFolderCustomFieldInitialization(folders, library.getProject().getId());
        List<TestCaseImportData> importDataList = libraryFolders.getEntities().stream().flatMap(data -> data.testCaseDataInNodes().stream()).toList();
        Project project = library.getProject().getProject();
        this.initializeCustomFieldValues(importDataList, library.getProject().getProject());
        this.initializeMilestoneBindings(importDataList);
        this.addAutomationRequestOnProject(importDataList, project);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void batchFolderCustomFieldInitialization(List<TestCaseFolder> newFolders, Long projectId) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(projectId, BindableEntity.TESTCASE_FOLDER);
        this.customFieldValueService.batchFolderCustomFieldValuesCreation(projectsBindings, newFolders);
    }

    @Override
    @PreventConcurrent(entityType=org.squashtest.tm.domain.testcase.TestCaseLibrary.class)
    public void addTestCasesToLibrary(@Id Long libraryId, List<TestCase> testCases, List<Long> milestoneIds) {
        org.squashtest.tm.domain.testcase.TestCaseLibrary library = this.testCaseLibraryDao.loadForTestCaseAddition(libraryId);
        for (TestCase testCase : testCases) {
            library.addContent((LibraryNode)testCase);
            this.replaceInfoListReferences(testCase);
            this.testCaseDao.safePersist(testCase);
        }
        this.initCustomFieldsAndMilestones(testCases, milestoneIds, library.getProject().getProject());
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @PreventConcurrent(entityType=TestCaseFolder.class)
    public void addTestCasesToFolder(@Id Long folderId, List<TestCase> testCases, List<Long> milestoneIds) {
        TestCaseFolder folder = this.testCaseFolderDao.loadForTestCaseAddition(folderId);
        for (TestCase testCase : testCases) {
            folder.addContent((TestCaseLibraryNode)testCase);
            this.replaceInfoListReferences(testCase);
            this.testCaseDao.safePersist(testCase);
        }
        this.initCustomFieldsAndMilestones(testCases, milestoneIds, folder.getProject());
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void initCustomFieldsAndMilestones(List<TestCase> testCases, List<Long> milestoneIds, Project project) {
        Map<TestCase, List> testCaseMilestones = testCases.stream().collect(Collectors.toMap(testCase -> testCase, testCase -> milestoneIds));
        this.milestoneService.bindHoldersToMilestones(testCaseMilestones);
        this.customFieldValueService.createAllCustomFieldValues(testCases, project);
    }

    static final /* synthetic */ List findAllTestCaseIdsByLibraries_aroundBody0(TestCaseLibraryNavigationServiceImpl testCaseLibraryNavigationServiceImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findAllTestCaseIdsByLibraries(collection);
    }

    static final /* synthetic */ List findAllTestCasesLibraryNodeForMilestone_aroundBody2(TestCaseLibraryNavigationServiceImpl testCaseLibraryNavigationServiceImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findAllTestCasesLibraryNodeForMilestone(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCaseLibraryNavigationServiceImpl.java", TestCaseLibraryNavigationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllTestCaseIdsByLibraries", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 909);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllTestCasesLibraryNodeForMilestone", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 1025);
    }

    private class CustomFieldValuesFixer
    implements TestCaseLibraryNodeVisitor {
        private CustomFieldValuesFixer() {
        }

        private void fix(TestCaseFolder folder) {
            for (TestCaseLibraryNode node : folder.getContent()) {
                node.accept((TestCaseLibraryNodeVisitor)this);
            }
        }

        public void visit(TestCase visited) {
            TestCaseLibraryNavigationServiceImpl.this.createCustomFieldValuesForTestCase(visited);
        }

        public void visit(TestCaseFolder visited) {
            this.fix(visited);
        }
    }

    private class NatureTypeChainFixer
    implements TestCaseLibraryNodeVisitor {
        private NatureTypeChainFixer() {
        }

        private void fix(TestCaseFolder folder) {
            for (TestCaseLibraryNode node : folder.getContent()) {
                node.accept((TestCaseLibraryNodeVisitor)this);
            }
        }

        public void visit(TestCase visited) {
            TestCaseLibraryNavigationServiceImpl.this.replaceInfoListReferences(visited);
        }

        public void visit(TestCaseFolder visited) {
            this.fix(visited);
        }
    }
}

