/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.DatasetParamValueDao;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.DatasetModificationService;

@Transactional
@Service(value="squashtest.tm.service.DatasetModificationService")
public class DatasetModificationServiceImpl
implements DatasetModificationService {
    private static final String WRITE = "WRITE";
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private ParameterDao parameterDao;
    @Inject
    private DatasetParamValueDao datasetParamValueDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private TestCaseLoader testCaseLoader;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Dataset findById(long datasetId) {
        return (Dataset)this.datasetDao.getReferenceById(datasetId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public Dataset persist(Dataset dataset, @Id long testCaseId) {
        Dataset sameName = this.datasetDao.findByTestCaseIdAndName(testCaseId, dataset.getName());
        if (sameName != null) {
            throw new DuplicateNameException(dataset.getName(), dataset.getName());
        }
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_DATASETS));
        this.doPersistDataset(testCase, dataset);
        return dataset;
    }

    @Override
    public void persistBatch(List<Long> testCaseIds, List<Batch<Dataset>> batchList) {
        Map testCases = this.testCaseLoader.load(testCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_DATASETS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        Map parametersByTestCaseId = this.parameterDao.findAllParametersByTestCaseIds(testCaseIds);
        for (Batch<Dataset> batch : batchList) {
            TestCase testCase = (TestCase)testCases.get(batch.getTargetId());
            List<Dataset> datasets = batch.getEntities();
            List parameters = (List)parametersByTestCaseId.get(batch.getTargetId());
            for (Dataset dataset : datasets) {
                IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
                if (testCaseVisitor.isScripted()) {
                    throw new IllegalArgumentException("Cannot add dataset in a scripted test case.");
                }
                testCase.accept((TestCaseVisitor)testCaseVisitor);
                dataset.setTestCase(testCase);
                testCase.addDataset(dataset);
                if (parameters.isEmpty()) continue;
                this.updateDatasetParameters(dataset, parameters);
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public Dataset persistUnsecured(Dataset dataset, TestCase testCase) {
        Dataset sameName = this.datasetDao.findByTestCaseIdAndName(testCase.getId(), dataset.getName());
        if (sameName != null) {
            throw new DuplicateNameException(dataset.getName(), dataset.getName());
        }
        this.doPersistDataset(testCase, dataset);
        return dataset;
    }

    private void doPersistDataset(TestCase testCase, Dataset dataset) {
        IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
        if (testCaseVisitor.isScripted()) {
            throw new IllegalArgumentException("Cannot add dataset in a scripted test case.");
        }
        testCase.accept((TestCaseVisitor)testCaseVisitor);
        dataset.setTestCase(testCase);
        testCase.addDataset(dataset);
        List parameters = this.parameterDao.findAllParametersByTestCase(testCase.getId());
        this.updateDatasetParameters(dataset, parameters);
    }

    @Override
    public Collection<Dataset> findAllForTestCase(long testCaseId) {
        return this.datasetDao.findAllByTestCaseId(testCaseId);
    }

    @Override
    public void remove(Dataset dataset) {
        TestCase testCase = dataset.getTestCase();
        PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(testCase, WRITE));
        this.datasetDao.removeDatasetFromTestPlanItems(dataset.getId());
        this.datasetDao.delete(dataset);
    }

    @Override
    @CheckBlockingMilestone(entityType=Dataset.class)
    public void removeById(@Id long datasetId) {
        Optional optDataset = this.datasetDao.findById(datasetId);
        if (optDataset.isPresent()) {
            Dataset dataset = (Dataset)optDataset.get();
            TestCase testCase = dataset.getTestCase();
            PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(testCase, WRITE));
            this.remove(dataset);
        }
    }

    @Override
    public void removeAllByTestCaseIds(List<Long> testCaseIds) {
        this.datasetDao.removeDatasetsFromTestPlanItems(testCaseIds);
        this.datasetDao.removeDatasetInBatchByTestCaseIds(testCaseIds);
    }

    @Override
    @CheckBlockingMilestone(entityType=Dataset.class)
    public void changeName(@Id long datasetId, String newName) {
        Dataset dataset = (Dataset)this.datasetDao.getReferenceById(datasetId);
        TestCase testCase = dataset.getTestCase();
        PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(testCase, WRITE));
        Dataset sameName = this.datasetDao.findByTestCaseIdAndName(dataset.getTestCase().getId(), newName);
        if (sameName != null && !sameName.getId().equals(dataset.getId())) {
            throw new DuplicateNameException(dataset.getName(), newName);
        }
        dataset.setName(newName);
    }

    @Override
    @CheckBlockingMilestone(entityType=DatasetParamValue.class)
    public void changeParamValue(@Id long datasetParamValueId, String value) {
        DatasetParamValue paramValue = (DatasetParamValue)this.datasetParamValueDao.getReferenceById(datasetParamValueId);
        TestCase testCase = paramValue.getDataset().getTestCase();
        PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(testCase, WRITE));
        paramValue.setParamValue(value);
    }

    public List<Dataset> getAllDatasetByTestCase(long testCaseId) {
        return this.datasetDao.findOwnDatasetsByTestCase(testCaseId);
    }

    @Override
    public DatasetParamValue findDatasetParamValue(Dataset dataset, Parameter parameter) {
        DatasetParamValue result = null;
        Set datasetParamValues = dataset.getParameterValues();
        for (DatasetParamValue datasetParamValue : datasetParamValues) {
            if (!datasetParamValue.getParameter().equals(parameter)) continue;
            result = datasetParamValue;
        }
        return result;
    }

    private DatasetParamValue findOrAddParameter(Dataset dataset, Parameter parameter) {
        DatasetParamValue datasetParamValue = this.findDatasetParamValue(dataset, parameter);
        if (datasetParamValue == null) {
            datasetParamValue = new DatasetParamValue(parameter, dataset);
        }
        return datasetParamValue;
    }

    private void updateDatasetParameters(Dataset dataset, Collection<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            DatasetParamValue datasetParamValue = this.findOrAddParameter(dataset, parameter);
            dataset.addParameterValue(datasetParamValue);
        }
    }

    @Override
    public void cascadeDatasetsUpdate(long testCaseId) {
        List<Dataset> allDataset = this.datasetDao.findOwnDatasetsByTestCase(testCaseId);
        allDataset.addAll(this.datasetDao.findAllDelegateDatasets(testCaseId));
        List params = this.parameterDao.findAllParametersByTestCase(testCaseId);
        for (Dataset dataset : allDataset) {
            this.updateDatasetParameters(dataset, params);
        }
    }

    @Override
    public void cascadeDatasetsUpdate(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return;
        }
        Map allDatasetsByTestCaseId = this.datasetDao.findAllDatasetsByTestCaseIds(testCaseIds);
        Map allParametersByTestCaseId = this.parameterDao.findAllParametersByTestCaseIds(testCaseIds);
        for (Map.Entry entry : allDatasetsByTestCaseId.entrySet()) {
            Optional.ofNullable((List)allParametersByTestCaseId.get(entry.getKey())).ifPresent(paramList -> ((List)entry.getValue()).forEach(dataset -> this.updateDatasetParameters((Dataset)dataset, (Collection<Parameter>)paramList)));
        }
    }
}

