/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.squashtest.tm.api.plugin.EntityType;

public class TestPlanContext {
    private final EntityType entityType;
    private final String entityName;
    private final String entityPath;
    private final String entityUuid;
    private final String squashTMVersion;

    public TestPlanContext(EntityType entityType, String entityName, String path, String entityUuid, String squashTMVersion) {
        this.entityUuid = entityUuid;
        TestPlanContext.validate(entityType, entityName, path);
        this.entityName = entityName;
        this.entityType = entityType;
        this.entityPath = path;
        this.squashTMVersion = squashTMVersion;
    }

    private static void validate(EntityType entityType, String entityName, String path) {
        if (!entityType.equals((Object)EntityType.ITERATION) && !entityType.equals((Object)EntityType.TEST_SUITE)) {
            throw new IllegalArgumentException("Unsupported type " + entityType);
        }
        if (path == null || path.isBlank()) {
            throw new IllegalArgumentException("Path cannot be blank.");
        }
        if (entityName == null || entityName.isBlank()) {
            throw new IllegalArgumentException("Entity name cannot be blank.");
        }
    }

    public String getEntityTypeAsString() {
        return this.normalizeEntityType(this.entityType);
    }

    private String normalizeEntityType(EntityType entityType) {
        return entityType.name().toLowerCase().replace("_", " ");
    }

    public String getEntityPath() {
        return String.valueOf(this.entityPath) + " > " + this.entityName;
    }

    public List<String> getEntityPathAsList() {
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(this.entityPath.split(" > ")));
        path.add(this.entityName);
        return path;
    }

    public String getEntityUuid() {
        return this.entityUuid;
    }

    public String getSquashTMVersion() {
        return this.squashTMVersion;
    }
}

