/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.TestAutomationServerCredentialsService;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

@Service(value="TestAutomationServerCredentialsService")
@Transactional
public class TestAutomationServerCredentialsServiceImpl
implements TestAutomationServerCredentialsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerCredentialsServiceImpl.class);
    private final TestAutomationConnectorRegistry taConnectorRegistry;
    private final TestAutomationServerManagerService testAutomationServerManagerService;
    private final StoredCredentialsManager storedCredentialsManager;

    @Inject
    public TestAutomationServerCredentialsServiceImpl(TestAutomationConnectorRegistry taConnectorRegistry, TestAutomationServerManagerService testAutomationServerManagerService, StoredCredentialsManager storedCredentialsManager) {
        this.taConnectorRegistry = taConnectorRegistry;
        this.testAutomationServerManagerService = testAutomationServerManagerService;
        this.storedCredentialsManager = storedCredentialsManager;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AuthenticationProtocol[] getSupportedProtocols(TestAutomationServer server) {
        return this.taConnectorRegistry.createConnector(server).getSupportedProtocols();
    }

    @Override
    public void validateCredentials(long serverId, ManageableCredentials manageableCredentials) {
        TestAutomationServer server = this.testAutomationServerManagerService.findById(serverId);
        TestAutomationConnector connector = this.taConnectorRegistry.getConnectorForKind(server.getKind());
        Credentials credentials = manageableCredentials.build(this.storedCredentialsManager, (ThirdPartyServer)server, null);
        try {
            connector.checkCredentials(server, credentials);
        }
        catch (TestAutomationException exception) {
            String serverName = server.getName();
            String serverUrl = server.getUrl();
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to authenticate to server {} with url {}", new Object[]{serverName, serverUrl, exception});
            }
            throw exception;
        }
    }
}

