/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.system;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.system.LogFileDownloadService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
public class LogFileDownloadServiceImpl
implements LogFileDownloadService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileDownloadServiceImpl.class);
    private final UserAccountService userAccountService;
    private final CustomProjectFinder customProjectFinder;
    private final Environment environment;
    @Value(value="${logging.dir:#{null}}")
    private String loggingPath;
    @Value(value="${squash.project-imports.folder-path:#{null}}")
    private String loggingPathImport;

    public LogFileDownloadServiceImpl(UserAccountService userAccountService, CustomProjectFinder customProjectFinder, Environment environment) {
        this.userAccountService = userAccountService;
        this.customProjectFinder = customProjectFinder;
        this.environment = environment;
    }

    @Override
    public File getCurrentLogFile() {
        this.checkIsLoggingPathSet();
        if (this.isDevMode()) {
            return new File(String.valueOf(this.loggingPath) + "/spring.log");
        }
        return new File(String.valueOf(this.loggingPath) + "/squash-tm.log");
    }

    @Override
    public List<String> getAllPreviousLogFileNames() {
        this.checkIsLoggingPathSet();
        if (this.isDevMode()) {
            return new ArrayList<String>();
        }
        return this.findAllLogFiles().stream().map(File::getName).toList();
    }

    private List<File> findAllLogFiles() {
        File logsFolder = new File(this.loggingPath);
        if (!logsFolder.exists() || !logsFolder.isDirectory()) {
            LOGGER.warn("Logs path '{}' is not a readable folder. There will be no log files", new Object[]{logsFolder.getAbsolutePath()});
            return new ArrayList<File>();
        }
        LOGGER.info("Enumerating log files in folder '{}'", new Object[]{logsFolder.getAbsolutePath()});
        File[] logFiles = logsFolder.listFiles((dir, name) -> name.startsWith("squash-tm.log."));
        if (logFiles != null) {
            return Arrays.stream(logFiles).sorted(Comparator.comparing(File::getName)).toList();
        }
        return new ArrayList<File>();
    }

    @Override
    public File getPreviousLogFile(String fileName) throws AccessDeniedException {
        this.checkIsLoggingPathSet();
        if (!this.isPreviousLogFile(fileName)) {
            throw new AccessDeniedException("File " + fileName + " is not a valid log file.");
        }
        if (this.isDevMode()) {
            throw new IllegalStateException("You should not call getPreviousLogFile in a dev build.");
        }
        return new File(String.valueOf(this.loggingPath) + "/" + fileName);
    }

    private boolean isPreviousLogFile(String fileName) {
        List<String> logFileNames = this.getAllPreviousLogFileNames();
        return logFileNames.contains(fileName);
    }

    private void checkIsLoggingPathSet() {
        if (this.loggingPath == null) {
            throw new IllegalStateException("Logging path is not set. It should be set in application.properties or as an environment variable with key 'logging.dir'.");
        }
    }

    private void checkIsLoggingPathImportSet() {
        if (this.loggingPathImport == null) {
            throw new IllegalStateException("Logging import path is not set. It should be set in application.properties or as an environment variable with key 'squash.project-imports.folder-path'.");
        }
    }

    @Override
    public File getLogFileWithPath(String filePath, String origin) throws IOException {
        this.checkIsAdminOrCanManageAtLeastOneProject();
        if (!this.isDevMode()) {
            this.checkIsInsideLogFolder(filePath, origin);
        }
        return new File(filePath);
    }

    private void checkIsAdminOrCanManageAtLeastOneProject() throws AccessDeniedException {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List<Long> manageableProjectIds = this.customProjectFinder.findAllManageableIds(currentUser);
        if (!currentUser.isAdmin() && manageableProjectIds.isEmpty()) {
            throw new AccessDeniedException("Current user cannot manage any project");
        }
    }

    private void checkIsInsideLogFolder(String filePath, String origin) throws IOException {
        switch (LogFileOrigin.getLogFileOrigin(origin)) {
            case SYNCHRO: {
                this.checkIsLoggingPathSet();
                this.checkIsInsideLogFolder(new File(this.loggingPath), filePath, LogFileOrigin.SYNCHRO.getName());
                break;
            }
            case IMPORT: {
                this.checkIsLoggingPathImportSet();
                this.checkIsInsideLogFolder(new File(this.loggingPathImport), filePath, LogFileOrigin.IMPORT.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log folder origin: " + origin);
            }
        }
    }

    private void checkIsInsideLogFolder(File logsFolder, String filePath, String name) throws IOException {
        File candidate = new File(filePath);
        if (!candidate.getCanonicalPath().startsWith(logsFolder.getCanonicalPath())) {
            throw new AccessDeniedException("File " + filePath + " is not a valid " + name + " log file.");
        }
    }

    private boolean isDevMode() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("dev");
    }

    private static enum LogFileOrigin {
        SYNCHRO("synchronisation"),
        IMPORT("import");

        private final String name;

        private LogFileOrigin(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static LogFileOrigin getLogFileOrigin(String origin) {
            try {
                return LogFileOrigin.valueOf(origin);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unsupported log file origin: " + origin);
            }
        }
    }
}

